﻿using Mall.Common.Enum;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.Product
{
    /// <summary>
    /// 商品留言表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_Leavemessage
    {
		/// <summary>
		/// 主键编号
		/// </summary>
		public int Id { get; set; }

		/// <summary>
		/// 商品编号
		/// </summary>
		public int GoodsId { get; set; }

		/// <summary>
		/// 用户编号
		/// </summary>
		public int UserId { get; set; }

		/// <summary>
		/// 用户名称
		/// </summary>
		public string UserName { get; set; }

		/// <summary>
		/// 用户头像
		/// </summary>
		public string UserPhoto { get; set; }

		/// <summary>
		/// 留言内容
		/// </summary>
		public string Content { get; set; }

		/// <summary>
		/// 商户号id
		/// </summary>
		public int TenantId { get; set; }

		/// <summary>
		/// 小程序id
		/// </summary>
		public int MallBaseId { get; set; }

		/// <summary>
		/// 报名时间
		/// </summary>
		public DateTime CreateTime { get; set; }

		/// <summary>
		/// 删除状态
		/// </summary>
		public DateStateEnum Status { get; set; }
	}
}
