﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.Education;
using Mall.Model.Extend.Education;

namespace Mall.Repository.Education
{
    public class Rb_Education_TalkRepository : BaseRepository<Rb_Education_Talk>
    {

        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(Rb_Education_Talk); } }
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<Rb_Education_Talk_Extend> GetEducationTalkList(Rb_Education_Talk_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT * from Rb_Education_Talk  where Status=0");
            if (where != null)
            {
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and TenantId={0}", where.TenantId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and MallBaseId={0}", where.MallBaseId);
                }
                if (where.Id > 0)
                {
                    sb.AppendFormat(" and Id={0}", where.Id);
                }
                if (where.IsOpen > 0)
                {
                    sb.AppendFormat(" and IsOpen={0}", where.IsOpen);
                }
            }
            return Get<Rb_Education_Talk_Extend>(sb.ToString()).ToList();
        }

        /// <summary>
        /// 话题分页
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>

        public List<Rb_Education_Talk_Extend> GetEducationTalkPageList(int pageIndex, int pageSize, out long rowCount, Rb_Education_Talk_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT * from Rb_Education_Talk  where Status=0");
            if (where != null)
            {
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and TenantId={0}", where.TenantId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and MallBaseId={0}", where.MallBaseId);
                }
                if (where.Id > 0)
                {
                    sb.AppendFormat(" and Id={0}", where.Id);
                }
                if (where.IsOpen > 0)
                {
                    sb.AppendFormat(" and IsOpen={0}", where.IsOpen);
                }
            }
            return GetPage<Rb_Education_Talk_Extend>(pageIndex, pageSize, out rowCount, sb.ToString()).ToList();
        }




    }
}
