﻿using Mall.Model.Entity.Finance;
using Mall.Model.Extend.Finance;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VT.FW.DB;

namespace Mall.Repository.Finance
{
    /// <summary>
    /// 财务流程关联扩展方法
    /// </summary>
    public class RB_FinanceFlowConnectRepository : BaseRepository<RB_FinanceFlowConnect>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_FinanceFlowConnect); } }


        /// <summary>
        /// 获取财务流程关联表
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public List<RB_FinanceFlowConnect_Extend> GetExtendList(RB_FinanceFlowConnect_Extend model)
        {
            string where = " WHERE 1=1 ";
            where += string.Format(" AND " + nameof(RB_FinanceFlowConnect.Status) + "={0}", 0);
            if (model.Type > 0)
            {
                where += string.Format(" AND " + nameof(RB_FinanceFlowConnect.Type) + "={0}", (int)model.Type);
            }
            if (model.Class > 0)
            {
                where += string.Format(" AND " + nameof(RB_FinanceFlowConnect.Class) + "={0}", (int)model.Class);
            }
            if (model.FlowtemplateId >= 0)
            {
                where += string.Format(" AND " + nameof(RB_FinanceFlowConnect.FlowtemplateId) + "={0}", model.FlowtemplateId);
            }
            if (model.SuitableObjectId >= 0)
            {
                where += string.Format(" AND " + nameof(RB_FinanceFlowConnect.SuitableObjectId) + "={0}", model.SuitableObjectId);
            }
            if (!string.IsNullOrWhiteSpace(model.SuitableObjectIds))
            {
                where += string.Format(" AND " + nameof(RB_FinanceFlowConnect.SuitableObjectId) + " in ({0})", model.SuitableObjectId);
            }
            if (!string.IsNullOrWhiteSpace(model.FlowtemplateIds))
            {
                where += string.Format(" AND " + nameof(RB_FinanceFlowConnect.FlowtemplateId) + " in ({0})", model.FlowtemplateIds);
            }

            string sql = string.Format(" SELECT * FROM {0} {1}", TableName, where);
            return Get<RB_FinanceFlowConnect_Extend>(sql).ToList();
        }

    }
}
