﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 载体申请信息仓储层
    /// </summary>
    public class RB_CarrierApplyForRepository : BaseRepository<RB_CarrierApplyFor>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_CarrierApplyFor); } }


        /// <summary>
        /// 载体信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_CarrierApplyFor_Extend> GetCarrierList(RB_CarrierApplyFor_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_CarrierApplyFor_Extend.Status)}=0 ");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_CarrierApplyFor_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_CarrierApplyFor_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.ID > 0)
                {
                    builder.Append($" AND {nameof(RB_CarrierApplyFor_Extend.ID)}={query.ID}");
                }
                if (query.CompanyId > 0)
                {
                    builder.Append($" AND {nameof(RB_CarrierApplyFor_Extend.CompanyId)}={query.CompanyId}");
                }
                if (query.ProjectType.HasValue && query.ProjectType > 0)
                {
                    builder.Append($" AND {nameof(RB_CarrierApplyFor_Extend.ProjectType)}={(int)query.ProjectType}");
                }
                if (!string.IsNullOrWhiteSpace(query.CarrierName))
                {
                    builder.Append($" AND {nameof(RB_CarrierApplyFor_Extend.CarrierName)} like '%{query.CarrierName}%'");
                }
                if (!string.IsNullOrWhiteSpace(query.Developers))
                {
                    builder.Append($" AND {nameof(RB_CarrierApplyFor_Extend.Developers)} like '%{query.Developers}%'");
                }

                if (!string.IsNullOrWhiteSpace(query.StartOpenTime))
                {
                    builder.Append($" and  DATE_FORMAT({nameof(RB_CarrierApplyFor_Extend.OpenTime)},'%Y-%m-%d' )>=DATE_FORMAT('{query.StartOpenTime}','%Y-%m-%d' ) ");
                }
                if (!string.IsNullOrWhiteSpace(query.EndOpenTime))
                {
                    builder.Append($" and  DATE_FORMAT({nameof(RB_CarrierApplyFor_Extend.OpenTime)},'%Y-%m-%d' )<= DATE_FORMAT('{query.EndOpenTime}','%Y-%m-%d' ) ");
                }
                if (query.MetroNum > 0 || !string.IsNullOrWhiteSpace(query.MetroName))
                {
                    builder.Append($" AND {nameof(RB_CarrierApplyFor_Extend.ID)} in (SELECT CarrierId from rb_carriermetro where `Status`=0  ");
                    if (query.MetroNum > 0)
                    {
                        builder.Append($" AND {nameof(RB_CarrierApplyFor_Extend.MetroNum)} = {query.MetroNum}");
                    }
                    if (!string.IsNullOrWhiteSpace(query.MetroName))
                    {
                        builder.Append($" AND {nameof(RB_CarrierApplyFor_Extend.MetroName)} like '%{query.MetroName}%'");
                    }
                    builder.Append(" )");
                }
                if (query.OrderBy == 1)
                {
                    builder.Append($" order by {nameof(RB_CarrierApplyFor_Extend.CreateDate)} desc");
                }
                else if (query.OrderBy == 2)
                {
                    builder.Append($" order by {nameof(RB_CarrierApplyFor_Extend.OpenTime)} desc");
                }
            }
            return Get<RB_CarrierApplyFor_Extend>(builder.ToString()).ToList();
        }
    }
}
