﻿using Mall.Model.Entity.AppletWeChat;
using Mall.Model.Extend.AppletWeChat;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.AppletWeChat
{
    /// <summary>
    /// 直播房间仓储层
    /// </summary>
    public class RB_Live_HouseRepository : BaseRepository<RB_Live_House>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Live_House); } }

        /// <summary>
        /// 获取直播房间
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Live_House> GetLiveHouseListRepository(RB_Live_House query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE 1=1");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Live_House.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Live_House.MallBaseId)}={query.MallBaseId}");
                }

            }
            return Get<RB_Live_House>(builder.ToString()).ToList();
        }


        /// <summary>
        /// 获取直播房间
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Live_House> GetLiveHousePageList(int pageIndex, int pageSize, out long rowCount, RB_Live_House query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE 1=1");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Live_House.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Live_House.MallBaseId)}={query.MallBaseId}");
                }

            }
            return GetPage<RB_Live_House>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 获取直播房间
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Live_HouseExtension_Extend> GetLiveHouseExtensionPageList(int pageIndex, int pageSize, out long rowCount, RB_Live_HouseExtension_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT a.*,b.ExtensionImg,b.ID as HouseImgID FROM {TableName} as a INNER  JOIN rb_live_houseimg as b on a.roomid=b.roomid WHERE 1=1");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Live_HouseExtension_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Live_HouseExtension_Extend.MallBaseId)}={query.MallBaseId}");
                }

            }
            return GetPage<RB_Live_HouseExtension_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }
    }
}
