﻿using Mall.Model.Entity.User;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Extend.User
{
    /// <summary>
    /// 拼团配置扩展实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_GroupBuyConfig_Extend : RB_GroupBuyConfig
    {
        /// <summary>
        /// 支付方式[online_pay-线上支付,huodao-货到付款,balance-余额支付]
        /// </summary>
        public List<string> Payment_TypeList
        {
            get
            {
                if (!string.IsNullOrWhiteSpace(this.Payment_Type))
                {
                    return Common.Plugin.JsonHelper.DeserializeObject<List<string>>(this.Payment_Type);
                }
                return new List<string>();
            }
        }

        /// <summary>
        /// 发货方式[express-快递配送,offline-到店自提,city-同城配送]
        /// </summary>
        public List<string> Send_TypeList
        {
            get
            {
                if (!string.IsNullOrWhiteSpace(this.Send_Type))
                {
                    return Common.Plugin.JsonHelper.DeserializeObject<List<string>>(this.Send_Type);
                }
                return new List<string>();
            }
        }
    }
}