﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Education;
using VT.FW.DB;

namespace Mall.Model.Extend.Education
{
    /// <summary>
    ///  教育-老师动态管理扩展表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class Rb_Education_Dynamic_Extend : Rb_Education_Dynamic
    {
        #region 扩展字段
        /// <summary>
        /// 操作人
        /// </summary>
        public List<string> FileList { get; set; }
        /// <summary>
        /// 是否点赞
        /// </summary>
        public bool HasLike { get; set; }
        /// <summary>
        /// 创建人姓名
        /// </summary>
        public string CreateByName { get; set; }
        /// <summary>
        /// 创建人头像
        /// </summary>
        public string CrearteByPhoto { get; set; }
        /// <summary>
        /// 点赞列表信息
        /// </summary>
        public List<Rb_Education_DynamicLike_Extend> LikeList { get; set; }

        /// <summary>
        /// 评论列表信息
        /// </summary>
        public List<Rb_Education_DynamicComment_Extend> CommentList { get; set; }


        /// <summary>
        /// 评论内容
        /// </summary>
        public string CommentContent { get; set; }

        /// <summary>
        /// 相关类型 1评论，2点赞
        /// </summary>
        public int RealtionType { get; set; }
        /// <summary>
        /// 评论id
        /// </summary>
        public int CommentId { get; set; }



        /// <summary>
        /// 当前登录人id
        /// </summary>
        public int UserId { get; set; }


        public string ReplyName { get; set; }

        public string ReplyPhoto { get; set; }

        #endregion
    }
}
