﻿using Mall.Model.Extend.TradePavilion;
using Mall.Repository.TradePavilion;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Module.TradePavilion
{
    /// <summary>
    /// 商会活动报名处理类
    /// </summary>
    public class CommerceConsultModule
    {
        /// <summary>
        /// 商会活动报名仓储层对象
        /// </summary>
        private readonly RB_Commerce_ConsultRepository consultRepository = new RB_Commerce_ConsultRepository();

        /// <summary>
        /// 获取商会活动报名分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Commerce_Consult_Extend> GetCommerceConsultPageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Commerce_Consult_Extend query)
        {
            return consultRepository.GetCommerceConsultPageListRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 新增修改商会活动报名
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetCommerceConsultModule(RB_Commerce_Consult_Extend model)
        {
            bool flag;
            if (model.Id > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Commerce_Consult_Extend.ActivityId),model.ActivityId },
                    {nameof(RB_Commerce_Consult_Extend.UserId),model.UserId },
                    {nameof(RB_Commerce_Consult_Extend.LinkMan),model.LinkMan },
                    {nameof(RB_Commerce_Consult_Extend.LinkTel),model.LinkTel },
                };
                flag = consultRepository.Update(fileds, new WhereHelper(nameof(RB_Commerce_Consult_Extend.Id), model.Id));
            }
            else
            {
                var newId = consultRepository.Insert(model);
                model.Id = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 根据编号获取商会活动报名实体
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public RB_Commerce_Consult_Extend GetCommerceConsultModule(object Id)
        {
            return consultRepository.GetEntity<RB_Commerce_Consult_Extend>(Id);
        }

        /// <summary>
        /// 更新商会活动报名状态
        /// </summary>
        /// <param name="Id"></param>
        /// <param name="Status"></param>
        /// <returns></returns>
        public bool RemoveCommerceConsultModule(int Id, int Status)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Commerce_Consult_Extend.Status),Status },
            };
           bool flag = consultRepository.Update(fileds, new WhereHelper(nameof(RB_Commerce_Consult_Extend.Id), Id));
            return flag;
        }
    }
}
