﻿using Mall.Model.Entity.Finance;
using Mall.Model.Extend.Finance;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Finance
{
   public class RB_Finance_RecordDetailRepository:BaseRepository<RB_Finance_RecordDetail>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Finance_RecordDetail); } }
        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Finance_RecordDetail> GetList(RB_Finance_RecordDetail dmodel)
        {
            string where = $" where 1=1  ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Finance_RecordDetail.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Finance_RecordDetail.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Type > 0)
            {
                where += $@" and {nameof(RB_Finance_RecordDetail.Type)}={dmodel.Type}";
            }

            string sql = $@"SELECT * FROM {TableName}  {where} order by Id asc";
            return Get<RB_Finance_RecordDetail>(sql).ToList();
        }



        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Finance_RecordDetail_Extend> GetListByOrderIds(string orderIds, RB_Finance_RecordDetail_Extend dmodel)
        {
            string where = $" where 1=1  ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Finance_RecordDetail.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Finance_RecordDetail.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Type > 0)
            {
                where += $@" and {nameof(RB_Finance_RecordDetail.Type)}={dmodel.Type}";
            }

            if (!string.IsNullOrWhiteSpace(orderIds))
            {
                where += $@" and {nameof(RB_Finance_RecordDetail.OrderId)} in ({orderIds})";
            }
            string sql = $@"SELECT * FROM {TableName}  {where} order by Id asc";
            return Get<RB_Finance_RecordDetail_Extend>(sql).ToList();
        }
    }
}
