﻿using Mall.Common.Enum;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 商会活动报名仓储层
    /// </summary>
    public class RB_Commerce_ConsultRepository : BaseRepository<RB_Commerce_Consult>
    {
        /// <summary>
        /// 获取商会活动报名分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Commerce_Consult_Extend> GetCommerceConsultPageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_Commerce_Consult_Extend query)
        {
            rowsCount = 0;
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_Commerce_Consult
WHERE 1=1
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Commerce_Consult_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new List<RB_Commerce_Consult_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Commerce_Consult_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Commerce_Consult_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.LinkMan))
                {
                    builder.AppendFormat(" AND {0} LIKE @Name ", nameof(RB_Commerce_Consult_Extend.LinkMan));
                    parameters.Add("Name", "%" + query.LinkMan.Trim() + "%");
                }
            }
            return GetPage<RB_Commerce_Consult_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }
   
    }
}
