﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Education;
using Mall.Model.Extend.Finance;

namespace Mall.Model.Extend.Education
{
    public class RB_Education_Consult_Extend : RB_Education_Consult
    {
        /// <summary>
        /// 活动编号【查询使用】
        /// </summary>
        public string QActivityIds { get; set; }

        /// <summary>
        /// 用户编号【查询使用】
        /// </summary>
        public string QUserIds { get; set; }

        /// <summary>
        /// 报名时间
        /// </summary>
        public string CreateTimeStr { get { return Common.ConvertHelper.FormatTime(this.CreateTime); } }

        /// <summary>
        /// 报名状态   1正常  2取消  3查询所有
        /// </summary>
        public int EnrollState { get; set; }

        /// <summary>
        /// 活动名称
        /// </summary>
        public string ActivityName { get; set; }

        /// <summary>
        /// 活动封面图
        /// </summary>
        public string CoverImg { get; set; }
        /// <summary>
        /// 活动开始时间
        /// </summary>
        public DateTime? StartTime { get; set; }
        /// <summary>
        /// 活动结束时间
        /// </summary>
        public DateTime? EndTime { get; set; }

        /// <summary>
        /// 类型名称
        /// </summary>
        public string TypeName { get; set; }

        /// <summary>
        /// 订单财务单据列表
        /// </summary>
        public List<RB_Finance_Extend> FinanceList { get; set; }

        /// <summary>
        /// 活动地址
        /// </summary>
        public string LocationName { get; set; }

        /// <summary>
        /// 报名时间
        /// </summary>
        public string CreateStartTime { get; set; }

        /// <summary>
        /// 报名时间
        /// </summary>
        public string CreateEndTime { get; set; }

        /// <summary>
        /// 销售名称
        /// </summary>
        public string EduSellName { get; set; }

        /// <summary>
        /// 生日
        /// </summary>
        public string StuBirth { get; set; }
    }


    /// <summary>
    /// 活动报名统计
    /// </summary>
    public class RB_Education_Consult_Statistics: RB_Education_Consult
    {
      
        public decimal DueInMoney { get; set; }
        public int GuestNum { get; set; }
        public int CancelNum { get; set; }
    }
}
