﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum.User;
using VT.FW.DB;

namespace Mall.Model.Entity.User
{
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Member_DepositBuy
    {
        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }

        /// <summary>
        /// 订单号
        /// </summary>
        public string OrderNo { get; set; }
        /// <summary>
        /// 用户id
        /// </summary>
        public int? UserId { get; set; }
        /// <summary>
        /// 储值卡id
        /// </summary>
        public int DepositId { get; set; }

        /// <summary>
        /// 储值卡名称
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 储值卡封面
        /// </summary>
        public string CouponIco { get; set; }
        /// <summary>
        /// 储值卡售价
        /// </summary>
        public decimal SalePrice { get; set; }

        /// <summary>
        /// 储值卡面值
        /// </summary>
        public decimal DepositPrice { get; set; }

        /// <summary>
        /// 有效天数
        /// </summary>
        public int IndateDay { get; set; }

        /// <summary>
        /// 储值卡过期时间
        /// </summary>
        public DateTime EndTime { get; set; }
        /// <summary>
        /// 状态  0-未支付   1-已支付
        /// </summary>
        public int Status { get; set; }

        /// <summary>
        /// 充值方式（1-在线充值，2-赠送 3-系统返利）
        /// </summary>
        public int RechargeType { get; set; }


        /// <summary>
        /// 订单来源（平台）  枚举
        /// </summary>        
        public UserSourceEnum? OrderSource
        {
            get;
            set;
        }
        /// <summary>
        /// 支付类型 枚举  1微信  2支付宝  
        /// </summary>        
        public Common.Enum.Goods.OrderPayTypeEnum? PayWay
        {
            get;
            set;
        }

        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号id
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }

        /// <summary>
        /// 备注
        /// </summary>
        public string Remarks { get; set; }


        /// <summary>
        /// 订单支付时间
        /// </summary>
        public DateTime PayTime { get; set; }
        /// <summary>
        /// 订单号
        /// </summary>        
        public string Out_Trade_No
        {
            get;
            set;
        }
        /// <summary>
        /// 微信支付订单号
        /// </summary>        
        public string Transaction_Id
        {
            get;
            set;
        }


        /// <summary>
        /// 赠送状态0-未赠送，1-已赠送，2-赠送中（还未领取）
        /// </summary>
        public int SendStatus { get; set; }

        /// <summary>
        /// 赠送时间
        /// </summary>
        public DateTime? SendTime { get; set; }
    }
}
