﻿using Mall.Model.Entity.GuideCar;
using Mall.Model.Extend.GuideCar;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.GuideCar
{
   public class RB_GuideCar_SiteRepository:BaseRepository<RB_GuideCar_Site>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_GuideCar_Site); } }
        /// <summary>
        /// 物料规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_GuideCar_Site_Extend> GetPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_GuideCar_Site_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE  {nameof(RB_GuideCar_Site_Extend.Status)}=0");
            if (query != null)
            {
                // where += $@" and {nameof(RB_Customer_InfoCreate.CustomerId)}={dmodel.CustomerId}";
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_GuideCar_Site_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_GuideCar_Site_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (!string.IsNullOrWhiteSpace(query.SiteName))
                {
                    builder.Append($" AND {nameof(RB_GuideCar_Site_Extend.SiteName)} like '%{query.SiteName}%'");
                }
                if (query.RulesType > 0)
                {
                    builder.Append($" AND {nameof(RB_GuideCar_Site_Extend.RulesType)}={(int)query.RulesType}");
                }
            }
            return GetPage<RB_GuideCar_Site_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 物流规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_GuideCar_Site_Extend> GetLogisticsRulesList(RB_GuideCar_Site_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_GuideCar_Site_Extend.Status)}=0 ");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND {nameof(RB_GuideCar_Site_Extend.ID)}={query.ID}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_GuideCar_Site_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_GuideCar_Site_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (!string.IsNullOrWhiteSpace(query.SiteName))
                {
                    builder.Append($" AND {nameof(RB_GuideCar_Site_Extend.SiteName)} like '%{query.SiteName}%'");
                }
                if (query.RulesType > 0)
                {
                    builder.Append($" AND {nameof(RB_GuideCar_Site_Extend.RulesType)}={(int)query.RulesType}");
                }
             
                if (!string.IsNullOrEmpty(query.SiteIds))
                {
                    builder.Append($" AND {nameof(RB_GuideCar_Site_Extend.ID)} in({query.SiteIds})");
                }
            }
            return Get<RB_GuideCar_Site_Extend>(builder.ToString()).ToList();
        }
    }
}
