﻿using Mall.Model.Entity.BaseSetUp;
using Mall.Model.Extend.GuideCar;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.GuideCar
{
  public  class RB_GuideCar_SiteRegionRepository:BaseRepository<RB_GuideCar_SiteRegion>
    {
        // <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_GuideCar_SiteRegion); } }

        // <summary>
        /// 表名称
        /// </summary>
        public string DestinationTableName { get { return nameof(RB_Destination); } }

        /// <summary>
        /// 获取物流地区列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_GuideCar_SiteRegion_Extend> GetListRepository(RB_GuideCar_SiteRegion_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(@$" SELECT a.*,b.`Name` as RegionName,b.ParentID,c.ParentID as GrandpaID FROM {TableName} as a 
LEFT JOIN {DestinationTableName} as b on a.RegionId = b.ID
LEFT JOIN {DestinationTableName} as c on b.ParentID = c.ID WHERE   a.{nameof(RB_GuideCar_SiteRegion_Extend.Status)}=0");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_SiteRegion_Extend.TenantId)}={query.TenantId}");
                }
                if (query.RulesType > 0)
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_SiteRegion_Extend.RulesType)}={(int)query.RulesType}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_SiteRegion_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.SiteId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_SiteRegion_Extend.SiteId)}={query.SiteId}");
                }
                if (!string.IsNullOrWhiteSpace(query.SiteIds))
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_SiteRegion_Extend.SiteId)} in ({query.SiteIds})");
                }
            }
            return Get<RB_GuideCar_SiteRegion_Extend>(builder.ToString()).ToList();
        }


        /// <summary>
        /// 获取物流地区列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_GuideCar_SiteRegion_Extend> GetListForSingle(RB_GuideCar_SiteRegion_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(@$" SELECT a.* FROM {TableName} as a WHERE   a.{nameof(RB_GuideCar_SiteRegion_Extend.Status)}=0");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_SiteRegion_Extend.TenantId)}={query.TenantId}");
                }
                if (query.RulesType > 0)
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_SiteRegion_Extend.RulesType)}={(int)query.RulesType}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_SiteRegion_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.SiteId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_SiteRegion_Extend.SiteId)}={query.SiteId}");
                }
                if (!string.IsNullOrWhiteSpace(query.SiteIds))
                {
                    builder.Append($" AND a.{nameof(RB_GuideCar_SiteRegion_Extend.SiteId)} in ({query.SiteIds})");
                }
            }
            return Get<RB_GuideCar_SiteRegion_Extend>(builder.ToString()).ToList();
        }

    }
}
