﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Entity.BaseSetUp;
using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Entity.User;
using Mall.Model.Extend.BaseSetUp;
using Mall.Model.Extend.MarketingCenter;
using Mall.Model.Extend.User;
using Mall.Module.BaseSetUp;
using Mall.Module.MarketingCenter;
using Mall.Module.Product;
using Mall.Module.User;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;


namespace Mall.WebApi.Controllers.MallBase
{
    /// <summary>
    /// 小程序商城控制器
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]

    public class MallController : BaseController
    {
        /// <summary>
        /// 商户账号处理类
        /// </summary>
        private readonly Module.User.TenantModule TenantModule = new Module.User.TenantModule();

        /// <summary>
        /// 商户小程序处理类
        /// </summary>
        private readonly Module.User.MiniProgramModule programModule = new Module.User.MiniProgramModule();


        /// <summary>
        /// 自定义页面处理类
        /// </summary>
        private readonly MiniprogramPageTemplModule miniprogramPageTemplModule = new MiniprogramPageTemplModule();

        /// <summary>
        /// 自定义模板处理类
        /// </summary>
        private readonly MiniprogramTemplateModule miniprogramTemplateModule = new MiniprogramTemplateModule();

        /// <summary>
        /// 产品处理类
        /// </summary>
        private readonly ProductModule productModule = new ProductModule();

 
        /// <summary>
        /// 用户处理类
        /// </summary>
        private readonly UserModule userModule = new UserModule();

        /// <summary>
        /// 小程序基础配置
        /// </summary>
        private readonly MallBaseModule mallBaseModule = new MallBaseModule();

        /// <summary>
        /// 用户积分
        /// </summary>
        private readonly IntegralModule integralModule = new IntegralModule();

        /// <summary>
        /// 小程序页面处理类
        /// </summary>
        private Module.User.MiniProgramPageModule programPageModule = new Module.User.MiniProgramPageModule();

        /// <summary>
        /// 小程序首页
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetHome()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            string MiniAppId = "";
            try
            {
                //小程序Id
                MiniAppId = RequestParm.MiniAppId;
            }
            catch (Exception ex)
            {
                Common.Plugin.LogHelper.Error("MallController_GetHome", ex);
            }

            //获取小程序信息
            var miniProgram = new RB_MiniProgram_Extend();
            if (MiniAppId != null && !string.IsNullOrEmpty(MiniAppId))
            {
                miniProgram = programModule.GetMiniProgramModule(new Model.Extend.User.RB_MiniProgram_Extend() { MiniAppId = MiniAppId }, isGetHomeData: true, isGetNav: 1);
            }
            int page_id = parms.GetInt("page_id");
            var homePage = new object();
            //底部导航
            var navbar = new object();
            var setting = new object();
            var share_setting = new object();
            var cat_style = new object();
            //授权页面
            var auth_page = new object();
            //用户信息
            var user_info = new object();
            if (page_id > 0)
            {
                var targetPage = miniprogramPageTemplModule.GetMiniprogramPageTemplModule(new RB_Miniprogram_Page_Templ_Extend()
                {
                    MallBaseId = miniProgram.MallBaseId,
                    TenantId = miniProgram.TenantId,
                    Id=page_id
                }, isGetHome: false);
                List<object> list = new List<object>();
                //自定义首页
                if (targetPage != null && targetPage.Id > 0)
                {
                    //获取模板编号
                    string templateIds = string.Join(",", targetPage.DetailsList.Select(qitem => qitem.TemplateId));
                    var templateList = miniprogramTemplateModule.GetMiniprogramTemplateListModule(new Model.Extend.MarketingCenter.RB_Miniprogram_Template_Extend()
                    {
                        MallBaseId = miniProgram.MallBaseId,
                        TenantId = miniProgram.TenantId,
                        QIds = templateIds
                    }, IsAnalyzePlus: true);
                    //解析模板
                    foreach (var item in targetPage.DetailsList)
                    {
                        var templateData = new
                        {
                            id = item?.Id ?? 0,
                            name = item?.NavName ?? "",
                            data = new List<object>()
                        };
                        var templateModel = templateList?.Where(qitem => qitem.Id == item.TemplateId)?.FirstOrDefault();
                        if (templateModel != null && templateModel.ComponentDataList != null && templateModel.ComponentDataList.Count() > 0)
                        {
                            foreach (var subItem in templateModel.ComponentDataList)
                            {
                                templateData.data.Add(MallHelper.PlusDataToObject(subItem, (miniProgram?.TenantId ?? 0), miniProgram.MallBaseId));
                            }
                        }
                        var tempObj = new
                        {
                            id = item.Id,
                            name = item.NavName,
                            page_id = 0,
                            template_id = item.Id,
                            template = templateData
                        };
                        list.Add(tempObj);
                    }

                    homePage = new
                    {
                        id = miniProgram.MallBaseId,
                        title = miniProgram.MallName,
                        show_navs = targetPage.IsShowNav,
                        is_home_page = targetPage.IsHome,
                        navs = list
                    };
                }
            }
            else
            {
                if (miniProgram != null && miniProgram.MallBaseId > 0)
                {
                    //底部导航
                    navbar = new
                    {
                        //底部导航背景颜色
                        bottom_background_color = miniProgram.BottomNavBgColor,
                        //顶部导航背景颜色
                        top_background_color = miniProgram.TopNavBgColor,
                        //顶部标题文字颜色
                        top_text_color = miniProgram.TopNavWordColor,
                        //导航底部是否开启阴影效果(0-未开启，1-开启)
                        shadow = miniProgram.BottomNavIsShadow,
                        //导航栏
                        navs = miniProgram.BottomTagList.Select(qitem => new
                        {
                            active_color = qitem.CheckedColor,
                            active_icon = qitem.CheckedIcon,
                            color = qitem.DefaultColor,
                            text = qitem.TagName,
                            icon = qitem.DefaultIcon,
                            url = qitem.TagLink,
                            open_type = "redirect",
                            key = qitem.TagLink == "/pages/live/index" ? "live" : "",
                        }),
                    };
                    //授权页面热区
                    var hotspotCancel = new object();
                    var hotspotLogin = new object();
                    if (miniProgram.AuthDataList != null && miniProgram.AuthDataList.Count > 0 && miniProgram.AuthDataList.Count == 2)
                    {
                        var first = miniProgram.AuthDataList[0];
                        var second = miniProgram.AuthDataList[1];
                        if (first.open_type == "login")
                        {
                            hotspotLogin = first;
                            hotspotCancel = second;
                        }
                        else
                        {
                            hotspotLogin = second;
                            hotspotCancel = first;
                        }
                    }
                    else
                    {
                        hotspotLogin = new AuthItem()
                        {
                            width = 224,
                            height = 80,
                            left = 340,
                            top = 566,
                            defaultX = 340,
                            defaultY = 566,
                            link = "",
                            open_type = "login"
                        };
                        hotspotCancel = new AuthItem()
                        {
                            width = 224,
                            height = 80,
                            left = 84,
                            top = 566,
                            defaultX = 84,
                            defaultY = 566,
                            link = "",
                            open_type = "cancel"
                        };
                    }
                    auth_page = new
                    {
                        pic_url = miniProgram.AuthUrl,
                        hotspot = hotspotLogin,
                        hotspot_cancel = hotspotCancel
                    };

                    var selfHomePage = miniprogramPageTemplModule.GetMiniprogramPageTemplModule(new RB_Miniprogram_Page_Templ_Extend()
                    {
                        MallBaseId = miniProgram.MallBaseId,
                        TenantId = miniProgram.TenantId,
                    }, isGetHome: true);
                    List<object> list = new List<object>();
                    //自定义首页
                    if (selfHomePage != null && selfHomePage.Id > 0)
                    {
                        //获取模板编号
                        string templateIds = string.Join(",", selfHomePage.DetailsList.Select(qitem => qitem.TemplateId));
                        var templateList = miniprogramTemplateModule.GetMiniprogramTemplateListModule(new Model.Extend.MarketingCenter.RB_Miniprogram_Template_Extend()
                        {
                            MallBaseId = miniProgram.MallBaseId,
                            TenantId = miniProgram.TenantId,
                            QIds = templateIds
                        }, IsAnalyzePlus: true);
                        //解析模板
                        foreach (var item in selfHomePage.DetailsList)
                        {
                            var templateData = new
                            {
                                id = item?.Id ?? 0,
                                name = item?.NavName ?? "",
                                data = new List<object>()
                            };
                            var templateModel = templateList?.Where(qitem => qitem.Id == item.TemplateId)?.FirstOrDefault();
                            if (templateModel != null && templateModel.ComponentDataList != null && templateModel.ComponentDataList.Count() > 0)
                            {
                                foreach (var subItem in templateModel.ComponentDataList)
                                {
                                    templateData.data.Add(MallHelper.PlusDataToObject(subItem, (miniProgram?.TenantId ?? 0), miniProgram.MallBaseId));
                                }
                            }
                            var tempObj = new
                            {
                                id = item.Id,
                                name = item.NavName,
                                page_id = 0,
                                template_id = item.Id,
                                template = templateData
                            };
                            list.Add(tempObj);
                        }

                        homePage = new
                        {
                            id = miniProgram.MallBaseId,
                            title = miniProgram.MallName,
                            show_navs = selfHomePage.IsShowNav,
                            is_home_page = selfHomePage.IsHome,
                            navs = list
                        };
                    }
                    //默认首页布局
                    else
                    {
                        //配置了首页
                        if (miniProgram.HomeDataList != null && miniProgram.HomeDataList.Count > 0)
                        {
                            var tempObj = MallHelper.DefaultHomepage(miniProgram);
                            list.Add(tempObj);
                            homePage = new
                            {
                                id = 0,
                                title = miniProgram.MallName,
                                show_navs = 0,
                                is_home_page = 0,
                                navs = list
                            };
                        }
                        //未配置自定义页面
                        else
                        {
                            homePage = new
                            {
                                id = miniProgram.MallBaseId,
                                title = miniProgram.MallName,
                                show_navs = 1,
                                is_home_page = 1,
                                navs = list
                            };
                        }
                    }

                    #region 基本设置
                    //基础配置 Add By:W 2020年6月1号
                    var mallBaseModel = mallBaseModule.GetListRepository(new RB_MallBase_Extend { TenantId = miniProgram.TenantId ?? 0, MallBaseId = miniProgram.MallBaseId }).FirstOrDefault();
                    if (mallBaseModel == null)
                    {
                        mallBaseModel = new RB_MallBase_Extend();
                    }
                    //获取物流配置
                    var logisticsRules = mallBaseModule.GetLogisticsList(new RB_Logistics { TenantId = miniProgram.TenantId ?? 0, MallBaseId = miniProgram.MallBaseId }).FirstOrDefault();
                    if (logisticsRules == null)
                    {
                        logisticsRules = new RB_Logistics();
                    }
                    //用户积分
                    var integralModel = integralModule.GetIntegralSettingsList(new RB_Integral_Settings { TenantId = miniProgram.TenantId ?? 0, MallBaseId = miniProgram.MallBaseId }).FirstOrDefault();
                    if (integralModel == null)
                    {
                        integralModel = new RB_Integral_Settings();
                    }
                    List<string> payment_type = new List<string>();
                    if (!string.IsNullOrWhiteSpace(mallBaseModel.PayWay))
                    {
                        foreach (var item in mallBaseModel.PayWay.Split(","))
                        {
                            switch (item)
                            {
                                case "1":
                                    payment_type.Add("online_pay");
                                    break;
                                case "2":
                                    payment_type.Add("huodao");
                                    break;
                                case "3":
                                    payment_type.Add("balance");
                                    break;
                                default:
                                    break;
                            }
                        }
                    }
                    List<string> send_type = new List<string>();
                    if (!string.IsNullOrWhiteSpace(mallBaseModel.DeliverWay))
                    {
                        foreach (var item in mallBaseModel.DeliverWay.Split(","))
                        {
                            switch (item)
                            {
                                case "1":
                                    send_type.Add("express");
                                    break;
                                case "2":
                                    send_type.Add("offline");
                                    break;
                                case "3":
                                    send_type.Add("city");
                                    break;
                                default:
                                    break;
                            }
                        }
                    }
                    List<string> good_negotiable = new List<string>();
                    if (!string.IsNullOrWhiteSpace(mallBaseModel.ConsultWay))
                    {
                        foreach (var item in mallBaseModel.ConsultWay.Split(","))
                        {
                            switch (item)
                            {
                                case "1":
                                    good_negotiable.Add("contact");
                                    break;
                                case "2":
                                    good_negotiable.Add("contact_tel");
                                    break;
                                case "3":
                                    good_negotiable.Add("contact_web");
                                    break;
                                default:
                                    break;
                            }
                        }
                    }

                    setting = new
                    {
                        contact_tel = mallBaseModel?.ContactNumber,
                        over_time = mallBaseModel?.CancelTime,
                        delivery_time = mallBaseModel?.AutoReceiving,
                        after_sale_time = mallBaseModel?.AfterTime,
                        payment_type = payment_type.ToArray(),//支付方式 
                        send_type = send_type.ToArray(),//发货方式
                        kdniao_mch_id = logisticsRules?.ExpressBirdID,//快递鸟配置
                        kdniao_api_key = logisticsRules?.ExpressBirdAPIKey,
                        member_integral = integralModel?.IntegralNum,
                        member_integral_rule = integralModel?.Explain,
                        good_negotiable = good_negotiable.ToArray(),//商品面议联系方式
                        mobile_verify = "",
                        is_small_app = mallBaseModel?.TurnMini,
                        small_app_id = mallBaseModel?.MinAppId,
                        small_app_url = mallBaseModel?.MinUrl,
                        small_app_pic = mallBaseModel?.TurnMiniIco,
                        is_customer_services = mallBaseModel?.OnlineService,
                        customer_services_pic = mallBaseModel?.OnlineServiceIco,
                        is_dial = mallBaseModel?.OneCall,
                        dial_pic = mallBaseModel?.OneCallIco,
                        is_web_service = mallBaseModel?.ServiceOutLink,
                        web_service_url = mallBaseModel?.OuterServiceLink,
                        web_service_pic = mallBaseModel?.ServiceOutLinkIco,
                        is_quick_navigation = mallBaseModel?.SuspendBtn,
                        quick_navigation_style = mallBaseModel?.SuspendStyle,
                        quick_navigation_opened_pic = mallBaseModel?.UnfoldIco,
                        quick_navigation_closed_pic = mallBaseModel?.PackUpIco,
                        is_show_stock = "",
                        is_use_stock = "",
                        sell_out_pic = "",
                        sell_out_other_pic = "",
                        is_common_user_member_price = mallBaseModel?.DetailsMemberPrice,
                        is_member_user_member_price = mallBaseModel?.DetailsVipMemberPrice,
                        is_share_price = mallBaseModel?.DetailsSharePrice,
                        is_purchase_frame = mallBaseModel?.BuySwitch,
                        purchase_num = mallBaseModel?.CarouselOrder,
                        is_comment = mallBaseModel?.DetailsComment,
                        is_sales = mallBaseModel?.DetailsBuyNum,
                        is_mobile_auth = mallBaseModel?.OtherIndexMoblie,
                        is_official_account = mallBaseModel?.OtherTencent,
                        is_manual_mobile_auth = mallBaseModel?.OtherManualMobile,
                        is_icon_members_grade = mallBaseModel?.OtherMemerLevel,
                        is_goods_video = mallBaseModel?.DetailsVideo,
                        is_quick_map = mallBaseModel?.ShortcutNavigation,
                        quick_map_pic = mallBaseModel?.ShortcutNavigationIco,
                        quick_map_address = mallBaseModel?.Address,
                        longitude = mallBaseModel?.LongAndLat.Split(",")[0],
                        latitude = mallBaseModel?.LongAndLat.Split(",")[1],
                        is_quick_home = mallBaseModel?.BackTopNavigation,
                        quick_home_pic = mallBaseModel?.BackTopNavigationIco,
                        logo = "",
                        share_title = mallBaseModel?.MinShareTitle,
                        share_pic = mallBaseModel?.MinShareIco,
                        is_add_app = mallBaseModel?.MinSwitch,
                        add_app_bg_color = mallBaseModel?.MinBackColor,
                        add_app_bg_transparency = mallBaseModel?.MinBackClarity,
                        add_app_bg_radius = mallBaseModel?.MinBackCircularBead,
                        add_app_text = mallBaseModel?.MinTips,
                        add_app_text_color = mallBaseModel?.MinTipsColor,
                        add_app_icon_color_type = mallBaseModel?.MinIcoColor,
                        is_close = "",
                        business_time_type = "",
                        business_time_custom_type = "",
                        business_time_type_day = "",
                        business_time_type_week = "",
                        auto_business = "",
                        auto_business_time = "",
                        is_icon_super_vip = "",
                        is_show_normal_vip = "",
                        is_show_super_vip = "",
                        is_required_position = mallBaseModel?.OtherMustAddress,
                        is_share_tip = mallBaseModel?.OtherApplyShare,
                        is_show_cart = mallBaseModel?.ListShopCar,
                        is_show_sales_num = mallBaseModel?.ListBuyCount,
                        is_show_goods_name = mallBaseModel?.ListName,
                        is_underline_price = mallBaseModel?.DetailsLineationPrice,
                        is_express = mallBaseModel?.DeatilsExpress,
                        is_not_share_show = mallBaseModel?.OtherNoShare,
                        is_show_cart_fly = mallBaseModel?.CarSuspendBtn,
                        is_show_score_top = mallBaseModel?.BackTopBtn,
                        express_select_type = logisticsRules?.LogisticsType,//待会儿处理
                        express_aliapy_code = logisticsRules?.AliyunAppCode,
                        is_quick_customize = mallBaseModel?.Custom,
                        quick_customize_pic = mallBaseModel?.TurnIco,
                        quick_customize_open_type = "",
                        quick_customize_params = "",
                        quick_customize_link_url = mallBaseModel?.TurnLink,
                        quick_customize_new_params = "",
                        theme_color = "",
                        latitude_longitude = mallBaseModel?.LongAndLat
                    };
                    #endregion


                    #region 分销基础信息
                    var distributorBasics = userModule.GetDistributorBasicsInfo((miniProgram.TenantId ?? 0).ToString(), miniProgram.MallBaseId);
                    if (!string.IsNullOrEmpty(distributorBasics.WithdrawWay))
                    {
                        distributorBasics.WithdrawWayList = JsonConvert.DeserializeObject<List<int>>(distributorBasics.WithdrawWay);
                    }
                    List<string> pay_type = new List<string>();
                    if (!string.IsNullOrWhiteSpace(distributorBasics.WithdrawWay))
                    {
                        foreach (var item in distributorBasics.WithdrawWayList)
                        {
                            switch (item)
                            {
                                case 1:
                                    pay_type.Add("auto");
                                    break;
                                case 2:
                                    pay_type.Add("wechat");
                                    break;
                                case 3:
                                    pay_type.Add("alipay");
                                    break;
                                case 4:
                                    pay_type.Add("bank");
                                    break;
                                case 5:
                                    pay_type.Add("balance");
                                    break;
                                default:
                                    break;
                            }
                        }
                    }

                    share_setting = new
                    {
                        level = distributorBasics?.DistributorTier,
                        is_rebate = distributorBasics?.InPurchasing,
                        price_type = distributorBasics?.DistributorCommissionType,
                        first = distributorBasics?.OneCommission,
                        second = distributorBasics?.TwoCommission,
                        third = distributorBasics?.ThreeCommission,
                        share_condition = "",
                        condition = distributorBasics?.ReferralsCondition ?? 0,
                        auto_share_val = "",
                        share_goods_status = "",
                        share_goods_warehouse_id = "",
                        pay_type = pay_type.ToArray(),
                        cash_max_day = distributorBasics?.DailyWithdrawalLimit,
                        min_money = distributorBasics?.MinimumWithdrawalLimit,
                        cash_service_charge = distributorBasics?.WithdrawFee,
                        agree = distributorBasics?.ApplicationProtocol,
                        content = distributorBasics?.UserNotes,
                        pic_url_apply = "",
                        pic_url_status = distributorBasics?.BackgroundImage,
                        pic_url_home_head = distributorBasics?.IndexImage,
                        become_condition = "",
                        cat_list = "",
                        is_show_share_level = "",
                    };
                    #endregion


                    #region share_setting_custom
                    var distributorCustom = userModule.GetDistributorCustomInfo((miniProgram.TenantId ?? 0).ToString(), miniProgram.MallBaseId);
                    var share_setting_custom = new
                    {
                        menus = new
                        {
                            money = new
                            {
                                name = distributorCustom?.DistributionCommissionName,
                                icon = distributorCustom?.DistributionCommissionImage,
                                open_type = "",
                                url = "",
                                tel = ""
                            },
                            order = new
                            {
                                name = distributorCustom?.DistributionOrderName,
                                icon = distributorCustom?.DistributionOrderImage,
                                open_type = "",
                                url = "",
                                tel = ""
                            },
                            cash = new
                            {
                                name = distributorCustom?.WithdrawDetialsName,
                                icon = distributorCustom?.WithdrawDetialsImage,
                                open_type = "",
                                url = "",
                                tel = ""
                            },
                            team = new
                            {
                                name = distributorCustom?.MyTeamName,
                                icon = distributorCustom?.MyTeamImage,
                                open_type = "",
                                url = "",
                                tel = ""
                            },
                            qrcode = new
                            {
                                name = distributorCustom?.PromoteQRCodeName,
                                icon = distributorCustom?.PromoteQRCodeImage,
                                open_type = "",
                                url = "",
                                tel = ""
                            },
                        },
                        words = new
                        {
                            can_be_presented = new { name = distributorCustom?.CommissionForWithdrawalName, defaultStr = "可提现佣金" },
                            already_presented = new { name = distributorCustom?.CommissionWithdrawnName, defaultStr = "已提现佣金" },
                            parent_name = new { name = distributorCustom?.ReferrerName, defaultStr = "推荐人" },
                            pending_money = new { name = distributorCustom?.CommissionTobePaidName, defaultStr = "待打款佣金" },
                            cash = new { name = distributorCustom?.WithdrawDepositName, defaultStr = "提现" },
                            user_instructions = new { name = distributorCustom?.UserNotesName, defaultStr = "用户须知" },
                            apply_cash = new { name = distributorCustom?.IWantToWithdrawName, defaultStr = "我要提现" },
                            cash_type = new { name = distributorCustom?.WithdrawalWayName, defaultStr = "提现方式" },
                            cash_money = new { name = distributorCustom?.WithdrawalAmountName, defaultStr = "提现金额" },
                            order_money_un = new { name = distributorCustom?.OutstandingCommissionName, defaultStr = "未结算佣金" },
                            share_name = new { name = distributorCustom?.DistributorName, defaultStr = "分销商" },
                            one_share = new { name = distributorCustom?.OneDistributionName, defaultStr = "一级分销名称" },
                            second_share = new { name = distributorCustom?.TwoDistributionName, defaultStr = "二级分销名称" },
                            three_share = new { name = distributorCustom?.ThreeDistributionName, defaultStr = "三级分销名称" },
                        },
                        apply = new
                        {
                            share_apply = new { name = distributorCustom?.DistributionApplication, defaultStr = "分销申请" },
                            share_apply_pact = new { name = distributorCustom?.ApplicationAgreement, defaultStr = "分销申请协议" },
                            apply_btn_color = distributorCustom?.ButtonTextColor,
                            apply_btn_background = distributorCustom?.ButtonColor,
                            apply_btn_title = distributorCustom?.ButtonText,
                            apply_btn_round = distributorCustom?.ButtonFilletPX,
                            apply_head_pic = distributorCustom?.HeadImage,
                            apply_end_pic = distributorCustom?.BottomImage
                        },

                    };
                    #endregion


                    #region 商品分类样式
                    var productCategoryStyle = productModule.GetProductCategoryStyleInfo(miniProgram.TenantId ?? 0, miniProgram.MallBaseId);
                    cat_style = new
                    {
                        cat_style = productCategoryStyle?.Type,
                        recommend_count = productCategoryStyle?.Style,
                        cat_goods_count = productCategoryStyle?.CategoryNum,
                        cat_goods_cols = productCategoryStyle?.RowNum
                    };
                    #endregion
                }
              
                if (RequestParm.OpenId != null && !string.IsNullOrWhiteSpace(RequestParm.OpenId))
                {
                    var memberModel = userModule.GetAppletUserCenterStatistics(RequestParm.OpenId);
                    user_info = memberModel;
                }
            }
            
            var miniPageList = programPageModule.GetMiniprogram_Page_ListExtModule(new RB_MiniProgram_Page_Extend() { MallBaseId = RequestParm.MallBaseId });
            var objResult = new
            {
                home_pages = homePage,
                navbar,
                user_info,
                setting,
                share_setting,
                cat_style,
                auth_page,//授权页面
                bar_title = miniPageList?.Select(qitem => new { name = qitem.PageName, value = qitem.PageUrl, new_name = qitem.SelfPageName }),//导航标题
            };
            return ApiResult.Success(data: objResult);
        }



       


        /// <summary>
        /// 用户中心
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetUserCenter()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            string MiniAppId = "";
            try
            {
                //小程序Id
                MiniAppId = RequestParm.MiniAppId;
            }
            catch (Exception ex)
            {
                Common.Plugin.LogHelper.Error("MallController_GetUserCenter", ex);
            }
            //获取小程序信息
            var miniProgram = programModule.GetMiniProgramModule(new Model.Extend.User.RB_MiniProgram_Extend() { MiniAppId = MiniAppId }, isGetUserCenterMenu: true);
            var user_info = new object();
            if (RequestParm.OpenId != null && !string.IsNullOrWhiteSpace(RequestParm.OpenId))
            {
                var memberModel = userModule.GetAppletUserCenterStatistics(RequestParm.OpenId);
                user_info = memberModel;
            }

            var data = new object();
            if (miniProgram != null && miniProgram.MallBaseId > 0)
            {
                var config = new
                {
                    //顶部导航
                    title_bar = new
                    {
                        //顶部背景颜色
                        background = miniProgram.TopNavBgColor,
                        //顶部文字颜色
                        color = miniProgram.TopNavWordColor,
                    },
                    //用户中心
                    user_center = new
                    {
                        //是否显示账户栏
                        is_account_status = (miniProgram.IsShowAccountNav == 0 ? 1 : 0),
                        //是否显示菜单栏
                        is_menu_status = (miniProgram.IsShowMenuNav == 0 ? 1 : 0),
                        //是否显示菜单栏
                        is_order_bar_status = (miniProgram.IsShowOrderNav == 0 ? 1 : 0),
                        //是否显示收藏夹
                        is_foot_bar_status = (miniProgram.IsShowFavorite == 0 ? 1 : 0),
                        //菜单样式
                        menu_style = (miniProgram.MenuNavStyle == 0 ? 1 : 2),
                        //头像样式
                        top_style = (miniProgram.HeadStyle),
                        //顶部默认背景图
                        top_pic_url = miniProgram.DefaultBgImg,
                        //普通用户背景图
                        member_pic_url = miniProgram.MemberBgImg,
                        //会员中心背景图
                        member_bg_pic_url = miniProgram.VipBgImg,
                        //头像内嵌背景图[暂无]
                        style_bg_pic_url = "",

                        //账户相关菜单
                        account = miniProgram?.AccountMenuList?.Select(qitem => new
                        {
                            icon_url = qitem.MenuIcon,
                            name = qitem.MenuName.Replace("我的", "").Replace("明细", "").Replace("记录", ""),
                            is_show = 1,
                            link_url = qitem.MenuUrl.Trim(),
                        }),
                        //自定义菜单
                        menus = miniProgram?.SelfMenuList?.Select(qitem => new
                        {
                            icon_url = qitem.MenuIcon,
                            name = qitem.MenuName,
                            link_url = qitem.MenuUrl.Trim(),
                            open_type = "navigate",
                            @params = "",

                        }),
                        //订单菜单列表
                        order_bar = miniProgram?.OrderMenuList?.Select(qitem => new
                        {
                            icon_url = qitem.MenuIcon,
                            name = qitem.MenuName,
                            link_url = qitem.MenuUrl.Trim(),
                            open_type = "navigate",
                            text = "",
                        }),
                        //收藏足迹
                        foot_bar = miniProgram?.FavoriteFootMenuList?.Select(qitem => new
                        {
                            icon_url = qitem.MenuIcon,
                            name = qitem.MenuName,
                            link_url = qitem.MenuUrl.Trim(),
                            open_type = "navigate",
                        }),
                        //版权设置
                        copyright = new
                        {
                            pic_url = miniProgram.CopyRightImg,
                            description = miniProgram.CopyRightWord,
                            link_url = miniProgram.CopyRightLink.Trim(),
                        }
                    }
                };

                data = new
                {
                    mall = new
                    {
                        //商城编号
                        id = miniProgram.MallBaseId,
                        //商城名称
                        name = miniProgram.MallName,
                        //是否删除
                        is_delete = miniProgram.Status,
                        //是否回收
                        is_recycle = miniProgram.Is_Recycle,
                        //是否禁用
                        is_disable = miniProgram.Status
                    },

                    //配置信息
                    config,
                    //用户信息
                    user_info,
                };
            }
            return ApiResult.Success(data: data);
        }

        /// <summary>
        /// 获取用户信息
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetUserInfo()
        {
            if (RequestParm.OpenId != null && !string.IsNullOrWhiteSpace(RequestParm.OpenId))
            {
                var memberModel = userModule.GetAppletUserCenterStatistics(RequestParm.OpenId);
                return ApiResult.Success(data: new { user_info = memberModel });
            }
            else
            {
                return ApiResult.Failed(message: "请获取用户OpenId");
            }
        }

        /// <summary>
        /// 获取用户信息
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetWeChatOpenId()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            string code = parms.GetStringValue("Code");
            string openId = "";
            if (RequestParm.MiniAppId != null && !string.IsNullOrWhiteSpace(RequestParm.MiniAppId))
            {
                var miniProgram = programModule.GetMiniProgramModule(new Model.Extend.User.RB_MiniProgram_Extend() { MiniAppId = RequestParm.MiniAppId });
                if (miniProgram != null && miniProgram.MallBaseId > 0)
                {
                    openId = Common.Plugin.WeiXinHelper.GetWeChatOpenId(miniProgram.MiniAppId, miniProgram.MiniAppSecret, code);
                }
            }
            return ApiResult.Success(data: openId);
        }
    }
}