﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;

namespace Mall.Repository.TradePavilion
{
  public  class RB_PrizeRepository:BaseRepository<RB_Prize>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Prize); } }

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Prize_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Prize_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT a.*,(SELECT COUNT(*) from rb_brand where `Status`=0 and FIND_IN_SET(a.Id,SourceIds)) FROM rb_prize as a  WHERE `Status`=0 ");
            if (query != null)
            {

                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Prize_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Prize_Extend.MallBaseId)}={query.MallBaseId}");
                }
            }
            builder.Append($" order by Id desc");
            return GetPage<RB_Prize_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }

        /// <summary>
        /// 奖项列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Prize_Extend> GetList(RB_Prize_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE 1=1");
            if (query != null)
            {

                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Prize_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_Prize_Extend.MallBaseId)}={query.MallBaseId}");
                }

                if (!string.IsNullOrWhiteSpace(query.QPrizeIds))
                {
                    builder.Append($" AND {nameof(RB_Prize_Extend.Id)} in ({query.QPrizeIds})");
                }
                if (query.Id > 0)
                {
                    builder.Append($" AND {nameof(RB_Prize_Extend.Id)}={query.Id}");
                }
                if (query.Status > -1)
                {
                    builder.Append($" AND {nameof(RB_Prize_Extend.Status)}={query.Status}");
                }
               
            }
            builder.Append($" order by Id desc");
            return Get<RB_Prize_Extend>(builder.ToString()).ToList();
        }
    }
}
