﻿using Mall.Common.Enum;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 商会活动表仓储层
    /// </summary>
    public class RB_Commerce_ActivityRepository : BaseRepository<RB_Commerce_Activity>
    {
        /// <summary>
        /// 获取商会活动分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Commerce_Activity_Extend> GetCommerceActivityPageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_Commerce_Activity_Extend query)
        {
            rowsCount = 0;
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.*,IFNULL(B.TypeName,'') AS ActivityTypeName,IFNULL(C.JoinNum,0) AS JoinNum
FROM rb_commerce_activity AS A LEFT JOIN rb_commerce_activitytype AS B ON A.ActivityType=B.Id
     LEFT JOIN (SELECT ActivityId,COUNT(1) AS JoinNum  FROM rb_commerce_consult WHERE `Status`=0 GROUP BY ActivityId) AS C ON A.Id=C.ActivityId
WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Commerce_Activity_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new List<RB_Commerce_Activity_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Commerce_Activity_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Commerce_Activity_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.ActivityName))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @Name ", nameof(RB_Commerce_Activity_Extend.ActivityName));
                    parameters.Add("Name", "%" + query.ActivityName.Trim() + "%");
                }
                if (query.ActivityType > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Commerce_Activity_Extend.ActivityType), query.ActivityType);
                }
            }
            builder.AppendFormat(" ORDER BY A.{0} DESC ", nameof(RB_Commerce_Activity_Extend.Id));
            return GetPage<RB_Commerce_Activity_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }

        /// <summary>
        /// 获取当前用户参加商会活动分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Commerce_Activity_Extend> GetUserCommerceActivityPageRepository(int pageIndex, int pageSize, out long rowsCount, RB_Commerce_Activity_Extend query)
        {
            rowsCount = 0;
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.*,IFNULL(B.TypeName,'') AS ActivityTypeName,IFNULL(C.JoinNum,0) AS JoinNum
FROM rb_commerce_activity AS A LEFT JOIN rb_commerce_activitytype AS B ON A.ActivityType=B.Id
     LEFT JOIN (SELECT ActivityId,COUNT(1) AS JoinNum  FROM rb_commerce_consult WHERE `Status`=0 GROUP BY ActivityId) AS C ON A.Id=C.ActivityId
     INNER JOIN RB_Commerce_Consult AS D ON A.Id=D.ActivityId
WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Commerce_Activity_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new List<RB_Commerce_Activity_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Commerce_Activity_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Commerce_Activity_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.ActivityName))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @Name ", nameof(RB_Commerce_Activity_Extend.ActivityName));
                    parameters.Add("Name", "%" + query.ActivityName.Trim() + "%");
                }
                if (query.ActivityType > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Commerce_Activity_Extend.ActivityType), query.ActivityType);
                }
                //当前用户参加的活动
                if (query.CreateBy > 0)
                {
                    builder.AppendFormat(" AND D.{0}={1} ", nameof(RB_Commerce_Consult_Extend.UserId), query.CreateBy);
                }
            }
            builder.AppendFormat(" ORDER BY A.{0} DESC ", nameof(RB_Commerce_Activity_Extend.Id));
            return GetPage<RB_Commerce_Activity_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Commerce_Activity_Extend> GetList(RB_Commerce_Activity_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"SELECT A.*,IFNULL(B.TypeName,'') AS ActivityTypeName
 FROM rb_commerce_activity AS A LEFT JOIN rb_commerce_activitytype AS B ON A.ActivityType=B.Id 
 WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Commerce_Activity_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new List<RB_Commerce_Activity_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Commerce_Activity_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Commerce_Activity_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.ActivityType > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Commerce_Activity_Extend.ActivityType), query.ActivityType);
                }
                if (!string.IsNullOrEmpty(query.ActivityIds))
                {
                    builder.AppendFormat(" AND A.{0} in({1}) ", nameof(RB_Commerce_Activity_Extend.Id), query.ActivityIds);
                }
            }
            return Get<RB_Commerce_Activity_Extend>(builder.ToString()).ToList();
        }
    }
}
