﻿using System;
using System.Collections.Generic;
using System.Linq;
using Mall.Common.API;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Mall.Common.Plugin;
using Mall.CacheManager.User;
using Newtonsoft.Json.Linq;
using Mall.Common;
using Mall.Module.Miai;
using Mall.Model.Extend.Assess;
using Mall.Model.Entity.Assess;
using Microsoft.AspNetCore.Authorization;
using Dnc.Api.Throttle;

namespace Mall.WebApi.Controllers.MallBase
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class AppletAssessController : BaseController
    {
        /// <summary>
        /// 估价处理类对象
        /// </summary>
        private readonly AssessModule assessModule = new AssessModule();

        #region 品牌版块
        /// <summary>
        /// 获取活动版块列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        [RateValve(Policy = Policy.Ip, Limit = 30, Duration = 60)]
        public ApiResult GetCategoryDropList()
        {
            var req = base.RequestParm;
            RB_Assess_Category_Extend demodel = JsonConvert.DeserializeObject<RB_Assess_Category_Extend>(req.msg.ToString());
            demodel.MallBaseId = req.MallBaseId;
            demodel.Enable = 1;
            var list = assessModule.GetCategoryList(demodel);
            return ApiResult.Success("", list.OrderByDescending(x => x.Sort).ThenBy(x => x.Id).Select(x => new
            {
                x.Id,
                x.Name,
                x.Image,
                x.Sort,
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:mm:ss")
            }));
        }

        /// <summary>
        /// 获取品牌分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [RateValve(Policy = Policy.Ip, Limit = 30, Duration = 60)]
        public ApiResult GetBrandDropList()
        {
            var req = base.RequestParm;
            RB_Assess_Brand_Extend demodel = JsonConvert.DeserializeObject<RB_Assess_Brand_Extend>(req.msg.ToString());

            demodel.MallBaseId = req.MallBaseId;
            var list = assessModule.GetBrandList(demodel);
            return ApiResult.Success("", list.Select(x => new
            {
                x.Id,
                x.Name,
                x.PinYin,
                x.Logo,
                x.IsHot,
                x.BrandImgList,
                x.MoreDesc,
                x.RemarkDesc
            }));
        }

        /// <summary>
        /// 获取品牌详情
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [RateValve(Policy = Policy.Ip, Limit = 30, Duration = 60)]
        public ApiResult GetBrandInfo() {
            var userInfo = base.AppletUserInfo;
            JObject parms = JObject.Parse(base.RequestParm.msg.ToString());
            int BrandId = parms.GetInt("BrandId", 0);
            if (BrandId <= 0) {
                return ApiResult.ParamIsNull();
            }

            var model = assessModule.GetBrandInfo(BrandId);
            if (model == null || model.MallBaseId != userInfo.MallBaseId) { return ApiResult.Failed(); }

            return ApiResult.Success("", new
            {
                model.Id,
                model.CategoryId,
                model.Name,
                model.Logo,
                model.IsHot,
                model.BrandImgList,
                model.MoreDesc,
                model.RemarkDesc
            });
        }

        #endregion

        #region 回收估价

        /// <summary>
        /// 我要估价
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [RateValve(Policy = Policy.Ip, Limit = 30, Duration = 60)]
        public ApiResult SetGoodsInfo() {
            var userInfo = base.AppletUserInfo;
            RB_Assess_Goods_Extend demodel = JsonHelper.DeserializeObject<RB_Assess_Goods_Extend>(base.RequestParm.msg.ToString());
            if (demodel.CategoryId <= 0)
            {
                return ApiResult.ParamIsNull("请传递分类ID");
            }
            if (demodel.BrandId <= 0)
            {
                return ApiResult.ParamIsNull("请传递品牌ID");
            }
            if (demodel.GoodsImgList == null || !demodel.GoodsImgList.Any())
            {
                return ApiResult.ParamIsNull("请传递组图");
            }
            foreach (var item in demodel.GoodsImgList)
            {
                if (string.IsNullOrEmpty(item.Name))
                {
                    return ApiResult.ParamIsNull("请传递组图标题");
                }
                if (string.IsNullOrEmpty(item.Path))
                {
                    return ApiResult.ParamIsNull("请传递组图路径");
                }
            }
            demodel.GoodsImg = JsonHelper.Serialize(demodel.GoodsImgList);

            if (demodel.MoreImgList == null)
            {
                demodel.MoreImgList = new List<AssessBrandImg>();
            }
            foreach (var item in demodel.MoreImgList)
            {
                if (string.IsNullOrEmpty(item.Name))
                {
                    return ApiResult.ParamIsNull("请传递组图标题");
                }
                if (string.IsNullOrEmpty(item.Path))
                {
                    return ApiResult.ParamIsNull("请传递组图路径");
                }
            }
            demodel.MoreImg = JsonHelper.Serialize(demodel.MoreImgList);


            demodel.UserId = userInfo.UserId;
            demodel.TenantId = userInfo.TenantId;
            demodel.MallBaseId = userInfo.MallBaseId;
            demodel.CreateDate = DateTime.Now;

            string msg = assessModule.SetGoodsInfo(demodel);
            if (msg == "")
            {
                return ApiResult.Success();
            }
            else {
                return ApiResult.Failed(msg);
            }
        }

        /// <summary>
        /// 我的估价分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [RateValve(Policy = Policy.Ip, Limit = 30, Duration = 60)]
        public ApiResult GetMyGoodsPageList() {
            var userInfo = base.AppletUserInfo;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(base.RequestParm.msg.ToString());
            RB_Assess_Goods_Extend demodel = JsonConvert.DeserializeObject<RB_Assess_Goods_Extend>(base.RequestParm.msg.ToString());

            demodel.TenantId = userInfo.TenantId;
            demodel.MallBaseId = userInfo.MallBaseId;
            demodel.UserId = userInfo.UserId;
            var list = assessModule.GetGoodsPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.CategoryId,
                x.CategoryName,
                x.BrandId,
                x.BrandName,
                x.GoodsImgList,
                x.MoreImgList,
                x.Remark,
                x.ReplyContent,
                ReplyDate = x.ReplyDate.HasValue ? x.ReplyDate.Value.ToString("yyyy-MM-dd") : "",
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:mm:ss")
            });
            return ApiResult.Success("", pagelist);
        }

        #endregion
    }
}