﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Net.Http.Headers;
using System.Threading.Tasks;
using Mall.Common.API;
using Microsoft.AspNetCore.Mvc;

namespace Mall.WebApi.Controllers.Export
{
    /// <summary>
    /// 文件下载
    /// </summary>
    public class ExportController : BaseController
    {
        /// <summary>
        /// 文件流下载
        /// </summary>
        /// <param name="requestData"></param>
        /// <returns></returns>
        [HttpPost]
        public HttpResponseMessage DownLoad()
        {
            try
            {
                HttpResponseMessage response = new HttpResponseMessage(HttpStatusCode.OK);
                switch (RequestParm.cmd)
                {
                    //商品购买力TOP排行
                    case "getSalesGoodTop":
                        var file_SalesGood = new Services.DMCService.BusService().DownLoadBusConfig(requestData);
                        Stream stream_SalesGood = new MemoryStream(file_SalesGood);
                        response.Content = new StreamContent(stream);
                        break;
                    //用户购买力TOP排行
                    case "getSalesUserTop":
                        var file_SalesUser = new Services.DMCService.BusService().DownLoadBusConfig(requestData);
                        Stream stream_SalesUser = new MemoryStream(file_SalesUser);
                        response.Content = new StreamContent(stream_SalesUser);
                        break;
                }
                response.Content.Headers.ContentType = new MediaTypeHeaderValue("application/octet-stream");
                response.Content.Headers.ContentDisposition = new ContentDispositionHeaderValue("attachment")
                {
                    FileName = "Test.xls"
                };
                return response;
            }
            catch (Exception ex)
            {
                Common.Plugin.LogHelper.Write(ex, string.Format("DownLoad_requestData: {0}", Common.Plugin.JsonHelper.Serialize(requestData)));
                return new HttpResponseMessage(HttpStatusCode.NoContent);
            }
        }
    }
}