﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Entity.BaseSetUp;
using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Extend.BaseSetUp;
using Mall.Module.BaseSetUp;
using Mall.Module.MarketingCenter;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
 

namespace Mall.WebApi.Controllers.MallBase
{
    /// <summary>
    /// 小程序商城控制器
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
   
    public  class MallController : BaseController
    {
        /// <summary>
        /// 商户账号处理类
        /// </summary>
        private Module.User.TenantModule TenantModule = new Module.User.TenantModule();

        /// <summary>
        /// 商户小程序处理类
        /// </summary>
        private Module.User.MiniProgramModule programModule = new Module.User.MiniProgramModule();


        /// <summary>
        /// 自定义页面处理类
        /// </summary>
        private readonly MiniprogramPageTemplModule miniprogramPageTemplModule = new MiniprogramPageTemplModule();

        /// <summary>
        /// 自定义模板处理类
        /// </summary>
        private readonly MiniprogramTemplateModule miniprogramTemplateModule = new MiniprogramTemplateModule();

        /// <summary>
        /// 小程序首页
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public ApiResult GetHome()
        {
            //小程序Id
            var MiniAppId = RequestParm.MiniAppId;
            MiniAppId = "wxacd9f8cc3480d29e";
            var homePage = new object();
            //获取小程序信息
            var miniProgram = programModule.GetMiniProgramModule(new Model.Extend.User.RB_MiniProgram_Extend() { MiniAppId = MiniAppId },isGetHomeData:true);
            if (miniProgram != null && miniProgram.MallBaseId > 0)
            {
                var selfHomePage = miniprogramPageTemplModule.GetMiniprogramPageTemplModule(new RB_Miniprogram_Page_Templ_Extend()
                {
                    MallBaseId = miniProgram.MallBaseId,
                    TenantId = miniProgram.TenantId,
                }, isGetHome: true);
                List<object> list = new List<object>();
                //自定义首页
                if (selfHomePage != null && selfHomePage.Id > 0)
                {
                    //获取模板编号
                    string templateIds = string.Join(",", selfHomePage.DetailsList.Select(qitem => qitem.TemplateId));
                    var templateList = miniprogramTemplateModule.GetMiniprogramTemplateListModule(new Model.Extend.MarketingCenter.RB_Miniprogram_Template_Extend()
                    {
                        MallBaseId = miniProgram.MallBaseId,
                        TenantId = miniProgram.TenantId,
                        QIds = templateIds
                    }, IsAnalyzePlus: true);
                    //解析模板
                    foreach (var item in templateList)
                    {

                        var tempObj = new {
                            id=item.Id,
                            name=item.TemplateName,
                            page_id=0,

                        };
                    
                    }

                    homePage = new
                    {
                        id = selfHomePage.Id,
                        title = selfHomePage.PageName,
                        show_navs = selfHomePage.IsShowNav,
                        is_home_page = selfHomePage.IsHome,
                        navs= list
                    };
                }
                //默认首页
                else
                {
                    //配置了首页
                    if (miniProgram.HomeDataList != null && miniProgram.HomeDataList.Count > 0)
                    {
                        homePage = new
                        {
                            id = 0,
                            title = miniProgram.MallName,
                            show_navs = 1,
                            is_home_page = 1,
                            navs = list
                        };
                    }
                    //未配置自定义页面
                    else
                    {
                        homePage = new
                        {
                            id = -1,
                            title = miniProgram.MallName,
                            show_navs = 1,
                            is_home_page = 1,
                            navs = list
                        };

                    }
                }
            }
            return ApiResult.Success(data: homePage);
        }

        /// <summary>
        /// 用户中心
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public ApiResult GetUserCenter()
        {
            //小程序Id
            var MiniAppId = RequestParm.MiniAppId;
            MiniAppId = "wxacd9f8cc3480d29e";
            //获取小程序信息
            var miniProgram = programModule.GetMiniProgramModule(new Model.Extend.User.RB_MiniProgram_Extend() { MiniAppId = MiniAppId }, isGetUserCenterMenu: true);
            var mall = new object();
            if (miniProgram != null && miniProgram.MallBaseId > 0)
            {
                mall = new
                {
                    id=miniProgram.MallBaseId,
                    name=miniProgram.MallName,

                };
            }
            return ApiResult.Success(data: mall);
        }
    }
}