﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Extend.Point;
using Mall.Repository.Point;
using Mall.Repository.User;
using VT.FW.DB;

namespace Mall.Module.Education
{
    public class PointModule
    {
        /// <summary>
        /// 点数产品仓储
        /// </summary>
        private readonly RB_Point_GoodsRepository pointGoodsRepository = new RB_Point_GoodsRepository();
        private readonly RB_Point_OrderRepository pointOrderRepository = new RB_Point_OrderRepository();
        private readonly RB_Member_PointBalanceRepository memberPointBalanceRepository = new RB_Member_PointBalanceRepository();
        /// <summary>
        /// 会员信息
        /// </summary>
        private readonly RB_Member_UserRepository member_UserRepository = new RB_Member_UserRepository();
        private readonly RB_Point_CourseClassRepository pointCourseClassRepository = new RB_Point_CourseClassRepository();
        private readonly RB_Point_TeacherCourseRepository pointTeacherCourseRepository = new RB_Point_TeacherCourseRepository();
        private readonly RB_Point_TeacherCourseOrderRepository pointTeacherCourseOrderRepository = new RB_Point_TeacherCourseOrderRepository();


        #region 点数商品
        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_Goods_Extend> GetPointGoodsList(RB_Point_Goods_Extend where)
        {
            return pointGoodsRepository.GetPointGoodsList(where);
        }



        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_Goods_Extend> GetPointGoodsPageList(int pageIndex, int pageSize, out long rowsCount, RB_Point_Goods_Extend where)
        {

            return pointGoodsRepository.GetPointGoodsPageList(pageIndex, pageSize, out rowsCount, where);
        }


        /// <summary>
        /// 新增/修改点数商品
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetPointGoods(RB_Point_Goods_Extend model)
        {
            if (model.ID == 0)
            {
                return pointGoodsRepository.Insert(model) > 0;
            }
            else
            {
                IDictionary<string, object> fileds = new Dictionary<string, object>
                {
                    { nameof(RB_Point_Goods_Extend.UpdateDate), model.UpdateDate },
                    { nameof(RB_Point_Goods_Extend.GoodsName), model.GoodsName },
                    { nameof(RB_Point_Goods_Extend.GivePoint), model.GivePoint },
                    { nameof(RB_Point_Goods_Extend.OriginalPrice), model.OriginalPrice },
                    { nameof(RB_Point_Goods_Extend.SellingPrice), model.SellingPrice },
                    { nameof(RB_Point_Goods_Extend.Sort), model.Sort },
                    { nameof(RB_Point_Goods_Extend.CostPrice), model.CostPrice },
                    { nameof(RB_Point_Goods_Extend.PonitNum), model.PonitNum }
                };
                IList<WhereHelper> auditrecordWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_Goods_Extend.ID),
                            FiledValue = model.ID,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_Goods_Extend.TenantId),
                            FiledValue = model.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_Goods_Extend.MallBaseId),
                            FiledValue = model.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };
                return pointGoodsRepository.Update(fileds, auditrecordWhereHelpers);
            }
        }


        /// <summary>
        /// 删除点数商品
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool DeletePointGoods(RB_Point_Goods_Extend model)
        {
            IDictionary<string, object> fileds = new Dictionary<string, object>
                {
                    { nameof(RB_Point_Goods_Extend.UpdateDate), model.UpdateDate },
                    { nameof(RB_Point_Goods_Extend.State),1 }
                };
            IList<WhereHelper> auditrecordWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_Goods_Extend.ID),
                            FiledValue = model.ID,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_Goods_Extend.TenantId),
                            FiledValue = model.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_Goods_Extend.MallBaseId),
                            FiledValue = model.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };
            return pointGoodsRepository.Update(fileds, auditrecordWhereHelpers);

        }

        #endregion

        #region 充值订单
        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_Order_Extend> GetPointOrderList(RB_Point_Order_Extend where)
        {
            return pointOrderRepository.GetPointOrderList(where);
        }



        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_Order_Extend> GetPointGoodsPageList(int pageIndex, int pageSize, out long rowsCount, RB_Point_Order_Extend where)
        {

            return pointOrderRepository.GetPointOrderPageList(pageIndex, pageSize, out rowsCount, where);
        }

        /// <summary>
        /// 新增/修改点数订单
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool UpdatePointOrder(RB_Point_Order_Extend newModel)
        {
            var umodel = member_UserRepository.GetEntity(newModel.UserId);
            if (umodel == null)
            {
                return false;
            }
            //判断订单状态是否是待支付  2020-06-16 Add By:W
            var model = pointOrderRepository.GetEntity(newModel.ID);
            if (model == null)
            {
                return false;
            }
            if (model.State != 0)
            {
                return false;
            }
            if (model.Income != newModel.Income)
            {
                return false;
            }
            var trans = pointOrderRepository.DbTransaction;
            bool flag;
            if (model.ID > 0)
            {

                IDictionary<string, object> fileds = new Dictionary<string, object>
                {
                    { nameof(RB_Point_Order_Extend.PaymentTime), newModel.PaymentTime },
                    { nameof(RB_Point_Order_Extend.OrderStatus), newModel.OrderStatus },
                    { nameof(RB_Point_Order_Extend.MerchantsNo), newModel.MerchantsNo },
                    { nameof(RB_Point_Order_Extend.OldPonitNum), newModel.OldPonitNum }
                };
                IList<WhereHelper> auditrecordWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_Order_Extend.ID),
                            FiledValue = model.ID,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_Order_Extend.TenantId),
                            FiledValue = model.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_Order_Extend.MallBaseId),
                            FiledValue = model.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };

                RB_Member_PointBalance_Extend memberBalanceModel = new RB_Member_PointBalance_Extend
                {
                    UserId = model.UserId,
                    Type = Common.Enum.MarketingCenter.RecordTypeEnum.Income,
                    PonitNum = newModel.PonitNum + newModel.GivePoint,
                    Description = "在线购买" + model.PonitNum + "点" + (model.GivePoint > 0 ? ("赠送" + model.GivePoint) : ""),
                    CreateDate = newModel.PaymentTime,
                    TenantId = model.TenantId,
                    MallBaseId = model.MallBaseId,
                    Remarks = "订单号：" + model.OrderNo + "在线购买支付" + model.Income + "元" + model.PonitNum + "点" + (model.GivePoint > 0 ? ("赠送" + model.GivePoint) : ""),
                    PlatformType = model.OrderSource
                };
                memberPointBalanceRepository.Insert(memberBalanceModel, trans);

                flag = pointOrderRepository.Update(fileds, auditrecordWhereHelpers, trans);
                if (flag)
                {
                    IDictionary<string, object> filedsUser = new Dictionary<string, object>
                {
                    { nameof(Model.Entity.User.RB_Member_User.PointNum), umodel.PointNum+model.PonitNum+model.GivePoint }
                };
                    IList<WhereHelper> userWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(Model.Entity.User.RB_Member_User.Id),
                            FiledValue = umodel.Id,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(Model.Entity.User.RB_Member_User.TenantId),
                            FiledValue = umodel.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(Model.Entity.User.RB_Member_User.MallBaseId),
                            FiledValue = umodel.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };
                    member_UserRepository.Update(filedsUser, userWhereHelpers, trans);
                }
                return flag;
            }
            else
            {
                return false;
            }
        }



        /// <summary>
        /// 新增/修改点数订单
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int SetPointOrder(RB_Point_Order_Extend model)
        {
            if (model.ID == 0)
            {
                return pointOrderRepository.Insert(model);
            }
            return 0;
        }



        #endregion


        #region 点数明细
        /// <summary>
        /// 获取点数明细
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Member_PointBalance_Extend> GetUserPointDetailPageList(int pageIndex, int pageSize, out long count, RB_Member_PointBalance_Extend demodel)
        {
            return memberPointBalanceRepository.GetPointBalancePageList(pageIndex, pageSize, out count, demodel);
        }

        /// <summary>
        /// 获取用户点数
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        public int GetUserPointBalance(int userId)
        {
            return member_UserRepository.GetEntity(userId)?.PointNum ?? 0;
        }
        #endregion


        #region 在线课程分类
        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_CourseClass_Extend> GetPointCourseClassList(RB_Point_CourseClass_Extend where)
        {
            return pointCourseClassRepository.GetPointCourseClassList(where);
        }


        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_CourseClass_Extend> GetPointCourseClassPageList(int pageIndex, int pageSize, out long rowsCount, RB_Point_CourseClass_Extend where)
        {
            return pointCourseClassRepository.GetPointCourseClassPageList(pageIndex, pageSize, out rowsCount, where);
        }

        /// <summary>
        /// 新增/修改点数商品
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetPointCourseClass(RB_Point_CourseClass_Extend model)
        {
            if (model.ID == 0)
            {
                return pointCourseClassRepository.Insert(model) > 0;
            }
            else
            {
                IDictionary<string, object> fileds = new Dictionary<string, object>
                {
                    { nameof(RB_Point_CourseClass_Extend.UpdateDate), model.UpdateDate },
                    { nameof(RB_Point_CourseClass_Extend.CourseClassType), (int)model.CourseClassType },
                    { nameof(RB_Point_CourseClass_Extend.StudentNumType), model.StudentNumType },
                    { nameof(RB_Point_CourseClass_Extend.IsPublic), model.IsPublic },
                    { nameof(RB_Point_CourseClass_Extend.IsFree), model.IsFree },
                    { nameof(RB_Point_CourseClass_Extend.Sort), model.Sort },
                    { nameof(RB_Point_CourseClass_Extend.PointNum), model.PointNum },
                    { nameof(RB_Point_CourseClass_Extend.Duration), model.Duration },
                    { nameof(RB_Point_CourseClass_Extend.DurationUnit), model.DurationUnit }
                };
                IList<WhereHelper> auditrecordWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_CourseClass_Extend.ID),
                            FiledValue = model.ID,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_CourseClass_Extend.TenantId),
                            FiledValue = model.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_CourseClass_Extend.MallBaseId),
                            FiledValue = model.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };
                return pointCourseClassRepository.Update(fileds, auditrecordWhereHelpers);
            }
        }


        /// <summary>
        /// 删除点数课程分类
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool DeletePointCourseClass(RB_Point_CourseClass_Extend model)
        {
            IDictionary<string, object> fileds = new Dictionary<string, object>
                {
                    { nameof(RB_Point_CourseClass_Extend.UpdateDate), model.UpdateDate },
                    { nameof(RB_Point_CourseClass_Extend.State),1 }
                };
            IList<WhereHelper> auditrecordWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_CourseClass_Extend.ID),
                            FiledValue = model.ID,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_CourseClass_Extend.TenantId),
                            FiledValue = model.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_CourseClass_Extend.MallBaseId),
                            FiledValue = model.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };
            return pointCourseClassRepository.Update(fileds, auditrecordWhereHelpers);

        }
        #endregion


        #region  教师排课
        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_TeacherCourse_Extend> GetTeacherCourseList(RB_Point_TeacherCourse_Extend where)
        {
            return pointTeacherCourseRepository.GetTeacherCourseList(where);
        }


        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_TeacherCourse_Extend> GetTeacherCoursePageList(int pageIndex, int pageSize, out long rowsCount, RB_Point_TeacherCourse_Extend where)
        {
            return pointTeacherCourseRepository.GetTeacherCoursePageList(pageIndex, pageSize, out rowsCount, where);
        }



        /// <summary>
        /// 新增/修改老师排课
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetTeacherCourse(RB_Point_TeacherCourse_Extend model)
        {
            if (model.ID == 0)
            {
                return pointTeacherCourseRepository.Insert(model) > 0;
            }
            else
            {
                IDictionary<string, object> fileds = new Dictionary<string, object>
                {
                    { nameof(RB_Point_TeacherCourse_Extend.UpdateDate), model.UpdateDate },
                    { nameof(RB_Point_TeacherCourse_Extend.CourseClassId), model.CourseClassId },
                    { nameof(RB_Point_TeacherCourse_Extend.TeacherId), model.TeacherId },
                    { nameof(RB_Point_TeacherCourse_Extend.StudyDate), model.StudyDate },
                    { nameof(RB_Point_TeacherCourse_Extend.StudyStartDate), model.StudyStartDate },
                    { nameof(RB_Point_TeacherCourse_Extend.StudyEndDate), model.StudyEndDate },
                    { nameof(RB_Point_TeacherCourse_Extend.PointNum), model.PointNum },
                    { nameof(RB_Point_TeacherCourse_Extend.CourseName), model.CourseName },
                    { nameof(RB_Point_TeacherCourse_Extend.MinDuration), model.MinDuration },
                     { nameof(RB_Point_TeacherCourse_Extend.StudyDuration), model.StudyDuration }
                };
                IList<WhereHelper> auditrecordWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_TeacherCourse_Extend.ID),
                            FiledValue = model.ID,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_TeacherCourse_Extend.TenantId),
                            FiledValue = model.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_TeacherCourse_Extend.MallBaseId),
                            FiledValue = model.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };
                return pointTeacherCourseRepository.Update(fileds, auditrecordWhereHelpers);
            }
        }


        /// <summary>
        /// 删除老师排课
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool DeleteTeacherCourse(RB_Point_TeacherCourse_Extend model)
        {
            IDictionary<string, object> fileds = new Dictionary<string, object>
                {
                    { nameof(RB_Point_TeacherCourse_Extend.UpdateDate), model.UpdateDate },
                    { nameof(RB_Point_TeacherCourse_Extend.State),1 }
                };
            IList<WhereHelper> auditrecordWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_TeacherCourse_Extend.ID),
                            FiledValue = model.ID,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_TeacherCourse_Extend.TenantId),
                            FiledValue = model.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(RB_Point_TeacherCourse_Extend.MallBaseId),
                            FiledValue = model.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };
            return pointTeacherCourseRepository.Update(fileds, auditrecordWhereHelpers);

        }
        #endregion

        #region 订单

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_TeacherCourseOrder_Extend> GetPointOrderList(RB_Point_TeacherCourseOrder_Extend where)
        {
            return pointTeacherCourseOrderRepository.GetPointOrderList(where);
        }


        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_TeacherCourseOrder_Extend> GetPointOrderPageList(int pageIndex, int pageSize, out long rowsCount, RB_Point_TeacherCourseOrder_Extend where)
        {
            return pointTeacherCourseOrderRepository.GetPointOrderPageList(pageIndex, pageSize, out rowsCount, where);
        }

        /// <summary>
        /// 获取订单详情
        /// </summary>
        /// <param name="orderId"></param>
        /// <returns></returns>
        public RB_Point_TeacherCourseOrder_Extend GetPointOrderInfo(int orderId, int MallBaseId)
        {
            var model = pointTeacherCourseOrderRepository.GetPointOrderInfo(new RB_Point_TeacherCourseOrder_Extend() { ID = orderId, MallBaseId = MallBaseId });
            return model;
        }



        public bool SetTeacherCourseOrder(RB_Point_TeacherCourseOrder_Extend model)
        {
            bool flag = false;
            var trans = pointTeacherCourseOrderRepository.DbTransaction;
            var umodel = member_UserRepository.GetEntity(model.UserId);
            if (umodel == null)
            {
                return false;
            }
            int orderId = 0;
            if (model.ID == 0)
            {
                orderId = pointTeacherCourseOrderRepository.Insert(model, trans);
            }
            else
            {
                orderId = model.ID;
            }
            if (model.OrderStaus == Common.Enum.Point.OrderStausEnum.Paid && model.TotalPointNum > 0)
            {
                RB_Member_PointBalance_Extend memberBalanceModel = new RB_Member_PointBalance_Extend
                {
                    OrderId = orderId,
                    UserId = model.UserId,
                    Type = Common.Enum.MarketingCenter.RecordTypeEnum.Expend,
                    PonitNum = model.TotalPointNum,
                    Description = "购买直播课程消费" + model.TotalPointNum + "点",
                    CreateDate = System.DateTime.Now,
                    TenantId = model.TenantId,
                    MallBaseId = model.MallBaseId,
                    Remarks = "上课时间：" + model.StudyDate.ToString("yyyy-MM-dd HH:mm") + "时长" + model.TotalStudyDuration.ToString("f2") + Common.Plugin.EnumHelper.GetEnumName(model.DurationUnit),
                    PlatformType = umodel.Source
                };
                memberPointBalanceRepository.Insert(memberBalanceModel, trans);

                IDictionary<string, object> filedsUser = new Dictionary<string, object>
                {
                    { nameof(Model.Entity.User.RB_Member_User.PointNum), umodel.PointNum-model.TotalPointNum }
                };
                IList<WhereHelper> userWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(Model.Entity.User.RB_Member_User.Id),
                            FiledValue = umodel.Id,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(Model.Entity.User.RB_Member_User.TenantId),
                            FiledValue = umodel.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(Model.Entity.User.RB_Member_User.MallBaseId),
                            FiledValue = umodel.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };
                member_UserRepository.Update(filedsUser, userWhereHelpers, trans);
            }
            return flag;
        }





        #endregion
    }
}
