﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum.Point;
using VT.FW.DB;

namespace Mall.Model.Entity.Point
{

    /// <summary>
    /// 老师课程
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Point_TeacherCourseOrder
    {
        public int ID { get; set; }

        /// <summary>
        /// 课程分类id
        /// </summary>
        public int CourseClassId { get; set; }

        /// <summary>
        /// 课程Id
        /// </summary>
        public int CourseId { get; set; }

        /// <summary>
        /// 老师id
        /// </summary>
        public int TeacherId { get; set; }

        /// <summary>
        /// 用户id
        /// </summary>
        public int UserId { get; set; }


        /// <summary>
        /// 学习时间
        /// </summary>
        public DateTime StudyDate { get; set; }

        /// <summary>
        /// 时长
        /// </summary>
        public decimal StudyDuration { get; set; }



        /// <summary>
        /// 时长
        /// </summary>
        public decimal TotalStudyDuration { get; set; }


        /// <summary>
        /// 时长单位
        /// </summary>
        public DurationUnitEnum DurationUnit { get; set; }


        /// <summary>
        /// 订单状态 0-代付款，1-已支付，2-已确认，3已完成
        /// </summary>
        public OrderStausEnum OrderStaus { get; set; }


        /// <summary>
        /// 是否推送放假信息0-否，1-是
        /// </summary>
        public int IsSendRoom { get; set; }


        /// <summary>
        /// 房间信息
        /// </summary>
        public string RoomInfo { get; set; }


        /// <summary>
        /// 总点数
        /// </summary>
        public int TotalPointNum { get; set; }



        /// <summary>
        /// 实际总点数
        /// </summary>
        public int ActualPointNum { get; set; }

        /// <summary>
        /// 基础点数
        /// </summary>
        public int BasePointNum { get; set; }



        /// <summary>
        /// 删除状态
        /// </summary>        
        public int? State
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }

    }
}
