﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.CacheManager.User;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Extend.Point;
using Mall.Module.Education;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace Mall.WebApi.Controllers.Education
{

    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class AppletPointController : BaseController
    {

        private readonly PointModule pointModule = new PointModule();


        #region 点数记录

        /// <summary>
        /// 小程序获取点数记录
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAppletUserPointDetailPageList() {
            var parms = RequestParm;
            var userInfo = AppletUserInfo;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            RB_Member_PointBalance_Extend demodel = JsonConvert.DeserializeObject<RB_Member_PointBalance_Extend>(RequestParm.msg.ToString());
            demodel.TenantId = userInfo.TenantId;
            demodel.MallBaseId = userInfo.MallBaseId;
            demodel.UserId = userInfo.UserId;
            var list = pointModule.GetUserPointDetailPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            int PointNum = pointModule.GetUserPointBalance(userInfo.UserId);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = new
            {
                PointNum,
                List = list.Select(x => new
                {
                    x.Id,
                    x.Type,
                    TypeName = x.Type.GetEnumName(),
                    x.Description,
                    x.PonitNum,
                    x.Remarks,
                    CreateDate = x.CreateDate.HasValue ? x.CreateDate.Value.ToString("yyyy-MM-dd HH:mm:ss") : ""
                })
            };
            return ApiResult.Success("", pagelist);
        }
        #endregion

        #region 订单列表

        /// <summary>
        /// 获取订单列表分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetPointOrderPageList()
        {
            var parms = RequestParm;
            var userInfo = AppletUserInfo;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            RB_Point_TeacherCourseOrder_Extend demodel = JsonConvert.DeserializeObject<RB_Point_TeacherCourseOrder_Extend>(RequestParm.msg.ToString());
            demodel.TenantId = userInfo.TenantId;
            demodel.MallBaseId = userInfo.MallBaseId;
            demodel.UserId = userInfo.UserId;//只能查询自己的订单列表
            var list = pointModule.GetPointOrderPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.ID,
                x.CourseClassId,
                CourseClassTypeName = x.CourseClassType.GetEnumName(),
                x.CourseId,
                x.CourseName,
                x.TeacherId,
                x.TeacherName,
                x.TeacherLogo,
                StudyDate = x.StudyDate.ToString("MM-dd HH:mm"),
                x.StudyDuration,
                x.TotalStudyDuration,
                DurationUnit = x.DurationUnit.GetEnumName(),
                x.OrderStaus,
                OrderStatusName = x.OrderStaus.GetEnumName(),
                x.IsSendRoom,
                x.RoomInfo,
                x.TotalPointNum,
                x.ActualPointNum,
                x.BasePointNum,
                x.UserId,
                x.UserName,
                CreateDate = x.CreateDate.HasValue ? x.CreateDate.Value.ToString("yyyy-MM-dd HH:mm:ss") : "",
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 获取订单详情
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetPointOrderInfo()
        {
            var userInfo = AppletUserInfo;
            var parms = JObject.Parse(RequestParm.msg.ToString());
            int OrderId = parms.GetInt("OrderId", 0);
            if (OrderId <= 0)
            {
                return ApiResult.ParamIsNull("请传递订单id");
            }

            var model = pointModule.GetPointOrderInfo(OrderId, userInfo.TenantId);
            if (model == null) { return ApiResult.Failed("订单不存在"); }
            if (model.UserId != userInfo.UserId) { return ApiResult.Failed("不是你的订单，无法查看"); }
            return ApiResult.Success("", new
            {
                model.ID,
                model.CourseClassId,
                CourseClassTypeName = model.CourseClassType.GetEnumName(),
                model.CourseId,
                model.CourseName,
                model.TeacherId,
                model.TeacherName,
                model.TeacherLogo,
                StudyDate = model.StudyDate.ToString("MM-dd HH:mm"),
                model.StudyDuration,
                model.TotalStudyDuration,
                DurationUnit = model.DurationUnit.GetEnumName(),
                model.OrderStaus,
                OrderStatusName = model.OrderStaus.GetEnumName(),
                model.IsSendRoom,
                model.RoomInfo,
                model.TotalPointNum,
                model.ActualPointNum,
                model.BasePointNum,
                model.UserId,
                model.UserName,
                CreateDate = model.CreateDate.HasValue ? model.CreateDate.Value.ToString("yyyy-MM-dd HH:mm:ss") : "",
            });
        }

        #endregion
    }
}
