﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Property
{
    /// <summary>
    /// rb_group Entity
    /// </summary> 
    [Serializable]
    [DB(ConnectionName = "UserConnection")]
    public class RB_Group
    {

        /// <summary>
        /// 主键
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 集团名称
        /// </summary>     
        public string GroupName
        {
            get;
            set;
        }
        /// <summary>
        /// 域名
        /// </summary>        
        public string Domain
        {
            get;
            set;
        }
        /// <summary>
        /// 联系人
        /// </summary>     
        public string ContactPersion
        {
            get;
            set;
        }
        /// <summary>
        /// 联系电话(手机)
        /// </summary>   
        public string MobilePhone
        {
            get;
            set;
        }
        /// <summary>
        /// 座机
        /// </summary>        
        public string Tel
        {
            get;
            set;
        }
        /// <summary>
        /// 地址
        /// </summary>        
        public string Address
        {
            get;
            set;
        }
        /// <summary>
        /// 备注
        /// </summary>        
        public string Remarks
        {
            get;
            set;
        }
        /// <summary>
        /// 状态
        /// </summary>        
        public Common.Enum.DateStateEnum? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 创建时间
        /// </summary>        
        public DateTime CreateTime
        {
            get;
            set;
        }
        /// <summary>
        /// 创建人变化
        /// </summary>        
        public int? CreateBy
        {
            get;
            set;
        }
        /// <summary>
        /// 更新时间
        /// </summary>        
        public DateTime UpdateTime
        {
            get;
            set;
        }
        /// <summary>
        /// 更新人
        /// </summary>        
        public int? UpdateBy
        {
            get;
            set;
        }
        /// <summary>
        /// 出团通知名
        /// </summary>        
        public string NoticesName
        {
            get;
            set;
        }
        /// <summary>
        /// 机场服务人员
        /// </summary>       
        public string AirportServicePerson
        {
            get;
            set;
        }
        /// <summary>
        /// 机场服务人员电话
        /// </summary>      
        public string AirportServicePhone
        {
            get;
            set;
        }
        public string Aliases
        {
            get;
            set;
        }
        /// <summary>
        /// 版本id
        /// </summary>        
        public int? Versions_Id
        {
            get;
            set;
        }
        /// <summary>
        /// 部门最大层级
        /// </summary>
        public int? MaxDepartmentTier { get; set; }
        /// <summary>
        /// logo
        /// </summary>
        public string Logo { get; set; }
        /// <summary>
        /// 绑定的管理员帐号
        /// </summary>
        public int? AdminAccount { get; set; }

        /// <summary>
        /// 绑定的管理员角色
        /// </summary>
        public int? AdminRole { get; set; }

        /// <summary>
        /// B2B域名
        /// </summary>
        public string B2BDomain { get; set; }

        /// <summary>
        /// 集团下账户数量
        /// </summary>
        public int? EmployeeNum { get; set; }

        /// <summary>
        /// 是否有同业网站(0-没有，1-有)
        /// </summary>
        public int IsOpenB2B { get; set; }

        /// <summary>
        /// 是否有直客网站(0-没有，1-有)
        /// </summary>
        public int IsOpenB2C { get; set; }

        /// <summary>
        /// 是否有行程特色(0-没有，1-有)
        /// </summary>
        public int IsOpenTripFeature { get; set; }

        /// <summary>
        /// 行程特色背景图片
        /// </summary>
        public string TripFeatureImg { get; set; }

        /// <summary>
        /// 集团公章图片地址
        /// </summary>
        public string ZhangImg { get; set; }

        /// <summary>
        /// 使用航班类型(0-系统默认航班,1-自定义航班信息)
        /// </summary>
        public int UseFlightType { get; set; }
    }
}
