﻿using VT.FW.DB;
using Mall.Common.Enum.MallBase;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Reserve
{
    /// <summary>
    /// 预约专区基础
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Reserve_Base
    {
        /// <summary>
        /// id
        /// </summary>
        public int Id { get; set; }



        /// <summary>
        /// 提前预定分钟
        /// </summary>
        public int AdvanceMinute { get; set; }


        /// <summary>
        /// 订单状态变更
        /// </summary>
        public string OrderStateJson { get; set; }



        /// <summary>
        /// 营业时间
        /// </summary>
        public string BusinessHoursJson { get; set; }

        /// <summary>
        /// 	付款方式
        /// </summary>
        public string PayTypeJson { get; set; }

        /// <summary>
        /// 商户id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateDate { get; set; }

        /// <summary>
        /// 修改人(员工id)
        /// </summary>
        public int UpdateBy { get; set; }

        /// <summary>
        /// 修改时间
        /// </summary>
        public DateTime UpdateDate { get; set; }
    }
}
