﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Common.Enum.Goods;
using Mall.Model.Entity.User;

namespace Mall.Model.Extend.Product
{
    /// <summary>
    /// 商品订单表扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_Order_Extend : RB_Goods_Order
    {
        /// <summary>
        /// 司导服务类型
        /// </summary>
        public GuideCarGoodsTypeEnum? CarType { get; set; }
        /// <summary>
        /// 司导预约开始时间
        /// </summary>
        public DateTime? TripSTime { get; set; }
        /// <summary>
        /// 司导预约结束时间
        /// </summary>
        public DateTime? TripETime { get; set; }
        /// <summary>
        /// 赠送的会员等级
        /// </summary>
        public int PresentFXGrade { get; set; }
        /// <summary>
        /// 公司id
        /// </summary>
        public int CompanyId { get; set; }
        /// <summary>
        /// 公司返佣比例
        /// </summary>
        public decimal CompanyProfitRate { get; set; }
        /// <summary>
        /// 订单ids
        /// </summary>
        public string OrderIds { get; set; }
        /// <summary>
        /// 订单号s
        /// </summary>
        public string orderNos { get; set; }
        /// <summary>
        /// 是否来自购物车  1是  2否
        /// </summary>
        public int? IsFormShoppingCart { get; set; }
        /// <summary>
        /// 购物车ids
        /// </summary>
        public List<int> ShoppingCartIdList { get; set; }
        /// <summary>
        /// 收货地址id
        /// </summary>
        public int? ShoppingAddressId { get; set; }
        /// <summary>
        /// 是否排除取消订单
        /// </summary>
        public int? IsNotSelectCancel { get; set; }
        /// <summary>
        /// 是否查询已付款的  1是  2否
        /// </summary>
        public int? IsSelectPayMoney { get; set; }
        /// <summary>
        /// 商品id
        /// </summary>
        public int? GoodsId { get; set; }

        public int PayMemerNum { get; set; }

        public int TotalPayMemerNum { get; set; }
        /// <summary>
        /// 分销用户id
        /// </summary>
        public int? DistributionUserId { get; set; }
        /// <summary>
        /// 商品订单数量
        /// </summary>
        public int? OrderNum { get; set; }
        /// <summary>
        /// 开始时间
        /// </summary>
        public string StartTime { get; set; }
        /// <summary>
        /// 结束时间
        /// </summary>
        public string EndTime { get; set; }
        /// <summary>
        /// 用户名称
        /// </summary>
        public string UserName { get; set; }
        /// <summary>
        /// 商品名称
        /// </summary>
        public string GoodsName { get; set; }

        /// <summary>
        /// 订单对应的总件数
        /// </summary>
        public int GoodsTotalNum { get; set; }

        /// <summary>
        /// 货号
        /// </summary>
        public string ProductCode { get; set; }
        /// <summary>
        /// 订单类型
        /// </summary>
        public int? OrderType { get; set; }
        /// <summary>
        /// 多个状态查询
        /// </summary>
        public string OrderStatusIds { get; set; }
        /// <summary>
        /// 明细列表
        /// </summary>
        public List<RB_Goods_OrderDetail_Extend> DetailList { get; set; }
        /// <summary>
        /// 订单返佣列表
        /// </summary>
        public List<RB_Goods_OrderCommission_Extend> OrderCommissionList { get; set; }


        /// <summary>
        /// 订单返佣列表
        /// </summary>
        public List<RB_SmallShops_Commission_Extend> SmallShopsCommissionOrderList { get; set; }


        /// <summary>
        /// 优惠券信息  //2020-08-25 Add By:w
        /// </summary>
        public List<User.RB_Member_DiscountCoupon_Extend> MemberDiscountCouponList { get; set; }



        /// <summary>
        /// 是否发放佣金   1是  2否
        /// </summary>
        public int? IsOrderCommission { get; set; }
        /// <summary>
        /// 是否可以申请售后   1是  2否
        /// </summary>
        public int? IsCanApplyForAfterSale { get; set; }
        /// <summary>
        /// 导出选项
        /// </summary>
        public List<int> ExcelEnumIds { get; set; }
        /// <summary>
        /// 区域地址
        /// </summary>
        public string DistrictAddress { get; set; }
        /// <summary>
        /// 收货地址id
        /// </summary>
        public int? AddressId { get; set; }
        /// <summary>
        /// 使用积分
        /// </summary>
        public int? Use_Integral { get; set; }
        /// <summary>
        /// 使用优惠卷id
        /// </summary>
        public int? User_Coupon_Id { get; set; }
        /// <summary>
        /// 使用课程卡id
        /// </summary>
        public int? Use_Education_Id { get; set; }

        /// <summary>
        /// 使用储值卡id
        /// </summary>
        public int Use_Deposit_Id { get; set; }
        /// <summary>
        /// 优惠券描述
        /// </summary>
        public string CouponDestription { get; set; }

        /// <summary>
        /// 支付方式
        /// </summary>
        public OrderPayTypeEnum? OrderPayType { get; set; }

        /// <summary>
        /// 唯一识别码
        /// </summary>        
        public string OpenId
        {
            get;
            set;
        }



        public string SmallShopsName { get; set; }

        #region 订单导入

        /// <summary>
        /// 平台名称
        /// </summary>
        public string PlatformNameImport { get; set; }
        /// <summary>
        /// 规格导入
        /// </summary>
        public string SpecificationImport { get; set; }
        /// <summary>
        /// 成本价
        /// </summary>
        public decimal CostMoneyImport { get; set; }
        /// <summary>
        /// 支付方式
        /// </summary>
        public string PaymentWayImport { get; set; }
        /// <summary>
        /// 订单状态
        /// </summary>
        public string OrderStatusImport { get; set; }
        /// <summary>
        /// 付款状态
        /// </summary>
        public string PaymentStatusImport { get; set; }
        /// <summary>
        /// 售价
        /// </summary>
        public decimal SellMoneyImport { get; set; }
        /// <summary>
        /// 原价
        /// </summary>
        public decimal OriginalMoneyImport { get; set; }
        /// <summary>
        /// 省
        /// </summary>
        public string PName { get; set; }
        /// <summary>
        /// 市
        /// </summary>
        public string CName { get; set; }
        /// <summary>
        /// 区
        /// </summary>
        public string DName { get; set; }

        #endregion



        #region 司导信息

        /// <summary>
        /// 导游名称
        /// </summary>
        public string GuideName { get; set; }

        /// <summary>
        /// 从业年限
        /// </summary>
        public decimal GuideWorkYears { get; set; }

        /// <summary>
        /// 用户评分
        /// </summary>
        public decimal GuideScore { get; set; }

        /// <summary>
        /// 联系电话
        /// </summary>
        public string GuideTelephone { get; set; }



        /// <summary>
        /// 头像
        /// </summary>
        public string GuidePhoto { get; set; }

        /// <summary>
        /// 车辆名称
        /// </summary>
        public string CarName { get; set; }
        /// <summary>
        /// 车辆颜色
        /// </summary>
        public string CarColorName { get; set; }


        /// <summary>
        /// 车辆类型
        /// </summary>
        public int? CarClass { get; set; }


        /// <summary>
        /// 车辆品牌
        /// </summary>
        public int? CarBrandId { get; set; }



        #endregion

        /// <summary>
        /// 门店名称
        /// </summary>
        public string StoreName { get; set; }

        /// <summary>
        /// 门店地址
        /// </summary>
        public string StoresAddress { get; set; }

        /// <summary>
        /// 线下订单数
        /// </summary>
        public int OfflineOrder { get; set; }
    }

    /// <summary>
    /// 订单优惠金额
    /// </summary>
    public class RB_Goods_CouponModel
    {
        /// <summary>
        /// 商品id
        /// </summary>
        public int GoodsId { get; set; }
        /// <summary>
        /// key
        /// </summary>
        public string Key { get; set; }
        /// <summary>
        /// 商品总价格(包含减积分)
        /// </summary>
        public decimal TotalMoney { get; set; }
        /// <summary>
        /// 优惠券金额
        /// </summary>
        public decimal CouponMoney { get; set; }
    }
}
