﻿using Mall.Common.Enum;
using Mall.Model.Extend.Product;
using Mall.Repository.Product;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Module.Product
{
   /// <summary>
   /// 商品留言处理类
   /// </summary>
   public  class GoodsLeavemessageModule
    {
        /// <summary>
        /// 商品留言仓储层对象
        /// </summary>
        private readonly RB_Goods_LeavemessageRepository goods_LeavemessageRepository = new RB_Goods_LeavemessageRepository();

        /// <summary>
        /// 获取商品留言分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Goods_Leavemessage_Extend> GetGoodsLeavemessagePageModule(int pageIndex, int pageSize, out long rowsCount, RB_Goods_Leavemessage_Extend query)
        {
            return goods_LeavemessageRepository.GetGoodsLeavemessagePageRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 新增商品留言
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetGoodsLeavemessageModule(RB_Goods_Leavemessage_Extend model)
        {
            var newId = goods_LeavemessageRepository.Insert(model);
            model.Id = newId;
            return newId > 0;
        }

        /// <summary>
        /// 删除商品留言
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public bool RemoveGoodsLeavemessageModule(int Id)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                { nameof(RB_Goods_Leavemessage_Extend.Status),(int)DateStateEnum.Delete}
            };
            return goods_LeavemessageRepository.Update(fileds, new WhereHelper(nameof(RB_Goods_Leavemessage_Extend.Id), Id));
        }
    }
}
