﻿using Mall.Model.Extend.User;
using Mall.Repository.User;
using System.Collections.Generic;
using VT.FW.DB;

namespace Mall.Module.User
{
    /// <summary>
    /// 用户管理
    /// </summary>
    public class MemberUserModule
    {
        /// <summary>
        /// 用户管理
        /// </summary>
        private readonly RB_Member_UserRepository member_UserRepository = new RB_Member_UserRepository();

        /// <summary>
        /// 根据用户Id更新用户头像和名称
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetMemberUserNameAndPhoto(RB_Member_User_Extend extModel)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                { nameof(RB_Member_User_Extend.Name),extModel.AliasName},
                { nameof(RB_Member_User_Extend.Photo),extModel.Photo},
            };
            return member_UserRepository.Update(fileds, new WhereHelper(nameof(RB_Member_User_Extend.Id), extModel.Id));
        }



        public bool SetMemberUserPhoneNum(RB_Member_User_Extend extModel)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                { nameof(RB_Member_User_Extend.PhoneNum),extModel.PhoneNum},
            };
            return member_UserRepository.Update(fileds, new WhereHelper(nameof(RB_Member_User_Extend.Id), extModel.Id));
        }
    }
}
