﻿using Mall.AOP.CustomerAttribute;
using Mall.Model.Extend.User;
using Mall.Repository.User;
using NPOI.POIFS.Storage;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Module.User
{
    /// <summary>
    /// 商户菜单处理类
    /// </summary>
    public class TenantMenuModule
    {
        /// <summary>
        /// 商户菜单仓储层对象
        /// </summary>
        private readonly RB_Tenant_MenuRepository tenant_MenuRepository = new RB_Tenant_MenuRepository();

        /// <summary>
        /// 获取商户菜单列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Tenant_Menu_Extend> GetTenantMenuListModule(RB_Tenant_Menu_Extend query)
        {
            return tenant_MenuRepository.GetTenantMenuListRepository(query);
        }

        /// <summary>
        /// 新增修改商户菜单
        /// </summary>
        /// <param name="list"></param>
        /// <returns></returns>
        [TransactionCallHandler]
        public bool SetTenantMenuModule(List<RB_Tenant_Menu_Extend> list)
        {
            bool flag = false;
            if (list != null && list.Count > 0)
            {
                tenant_MenuRepository.DeleteOne(new WhereHelper(nameof(RB_Tenant_Menu_Extend.TenantId), list[0].TenantId));
                foreach (var item in list)
                {
                    flag = tenant_MenuRepository.Insert(item) > 0;
                }
            }
            return flag;
        }
    }
}
