﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common.Enum;
using Mall.Model.Entity.Education;
using Mall.Model.Extend.Education;

namespace Mall.Repository.Education
{
    public class RB_Education_ActivityPlanRepository : BaseRepository<RB_Education_ActivityPlan>
    {
        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Education_ActivityPlan_Extend> GetActivityPlanList(RB_Education_ActivityPlan_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.* FROM RB_Education_ActivityPlan AS A 
WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Education_ActivityPlan_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new List<RB_Education_ActivityPlan_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Education_ActivityPlan_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Education_ActivityPlan_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.ActivityId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Education_ActivityPlan_Extend.ActivityId), query.ActivityId);
                }

                if (!string.IsNullOrWhiteSpace(query.TitleIds))
                {
                    builder.AppendFormat(" AND A.{0} in ({1}) ", nameof(RB_Education_ActivityPlan_Extend.TitleId), query.TitleIds);
                }
            }
            return Get<RB_Education_ActivityPlan_Extend>(builder.ToString()).ToList();
        }
    }
}
