﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common.Enum;
using Mall.Model.Entity.Finance;
using Mall.Model.Extend.Finance;

namespace Mall.Repository.Finance
{
    /// <summary>
    /// 平台账户仓储层
    /// </summary>
    public class RB_PlatformAccountRepository : BaseRepository<RB_PlatformAccount>
    {
        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public List<RB_PlatformAccount_Extend> GetList(RB_PlatformAccount_Extend model)
        {
            string where = " WHERE 1=1  and b." + nameof(RB_PlatformAccount_Extend.Status) + "=" + (int)DateStateEnum.Normal;
            where += string.Format(" AND a." + nameof(RB_PlatformAccount_Extend.Status) + "={0} ", (int)DateStateEnum.Normal);
            if (model.RB_Group_Id > 0)
            {
                where += string.Format(" AND a." + nameof(RB_PlatformAccount_Extend.RB_Group_Id) + "={0} ", model.RB_Group_Id);
            }
            if (model.RB_Branch_Id >= 0)
            {
                where += string.Format(" AND b.RB_Branch_Id={0} ", model.RB_Branch_Id);
            }
            if (model.BackId > 0)
            {
                where += string.Format(" AND a." + nameof(RB_PlatformAccount_Extend.BackId) + "={0} ", model.BackId);
            }
            if (!string.IsNullOrWhiteSpace(model.AccountIdStr))
            {
                where += string.Format(" AND a." + nameof(RB_PlatformAccount_Extend.ID) + " in({0}) ", model.AccountIdStr);
            }
            if (model.TypeId > 0)
            {
                where += string.Format(" AND a." + nameof(RB_PlatformAccount_Extend.TypeId) + "={0} ", model.TypeId);
            }
            if (model.CurrencyId > 0)
            {
                where += string.Format(" AND a." + nameof(RB_PlatformAccount_Extend.CurrencyId) + "={0} ", model.CurrencyId);
            }
            if (!string.IsNullOrWhiteSpace(model.Alias))
            {
                where += string.Format(" AND a." + nameof(RB_PlatformAccount_Extend.Alias) + " like'%{0}%' ", model.Alias);
            }
            return Get<RB_PlatformAccount_Extend>("select a.*,b.RB_Branch_Id,c.`Name` as TypeName,e.`Code` as CurrencyCode,e.`Name` as CurrencyName,e.CurrentRate,e.OutCashRate as PayRate,e.ExchangeRates,d.`Name` as BankName,d.Logo as BankIcon from rb_platformaccount a LEFT JOIN RB_AccountRelation b on a.ID=b.AccountID AND b.AccountType=2 LEFT JOIN rb_accounttype as c on a.TypeId = c.ID LEFT JOIN rb_financialinstitutions d on a.BackId = d.ID LEFT JOIN rb_currency e on a.CurrencyId = e.ID " + where).ToList();
        }
    }
}
