﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 载体地铁申请信息仓储层
    /// </summary>
    public class RB_CarrierMetroApplyForRepository : BaseRepository<RB_CarrierMetroApplyFor>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_CarrierMetroApplyFor); } }


        /// <summary>
        /// 载体信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_CarrierMetroApplyFor_Extend> GetCarrierMetroList(RB_CarrierMetroApplyFor_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_CarrierMetroApplyFor_Extend.Status)}=0 ");
            if (query != null)
            {

                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_CarrierMetroApplyFor_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_CarrierMetroApplyFor_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.CarrierId > 0)
                {
                    builder.Append($" AND {nameof(RB_CarrierMetroApplyFor_Extend.CarrierId)}={query.CarrierId}");
                }
                if (query.MetroNum > 0)
                {
                    builder.Append($" AND {nameof(RB_CarrierMetroApplyFor_Extend.MetroNum)}={query.MetroNum}");
                }
                if (!string.IsNullOrWhiteSpace(query.MetroName))
                {
                    builder.Append($" AND {nameof(RB_CarrierMetroApplyFor_Extend.MetroName)} like '%{query.MetroName}%'");
                }
                if (!string.IsNullOrWhiteSpace(query.CarrierIds))
                {
                    builder.Append($" AND {nameof(RB_CarrierMetroApplyFor_Extend.CarrierId)} in({query.CarrierIds})  ");
                }
            }
            return Get<RB_CarrierMetroApplyFor_Extend>(builder.ToString()).ToList();
        }
    }
}
