﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common;
using Mall.Common.Plugin;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using Mall.Repository;
using Mall.Repository.User;
using Mall.Repository.Product;
using Mall.Model.Extend.Product;

namespace Mall.Module.User
{
    /// <summary>
    /// 商户用户处理层
    /// </summary>
    public class UserModule
    {
        /// <summary>
        /// 用户管理
        /// </summary>
        private readonly RB_Member_UserRepository member_UserRepository = new RB_Member_UserRepository();
        /// <summary>
        /// 会员等级
        /// </summary>
        private readonly RB_Member_GradeRepository member_GradeRepository = new RB_Member_GradeRepository();
        /// <summary>
        /// 会员权益
        /// </summary>
        private readonly RB_Member_EquityRepository member_EquityRepository = new RB_Member_EquityRepository();
        /// <summary>
        /// 用户积分
        /// </summary>
        private readonly RB_Member_IntegralRepository member_IntegralRepository = new RB_Member_IntegralRepository();
        /// <summary>
        /// 用户余额
        /// </summary>
        private readonly RB_Member_BalanceRepository member_BalanceRepository = new RB_Member_BalanceRepository();
        /// <summary>
        /// 素材
        /// </summary>
        private readonly RB_Material_InfoRepository material_InfoRepository = new RB_Material_InfoRepository();
        /// <summary>
        /// 分销基础配置
        /// </summary>
        private readonly RB_Distributor_BasicsRepository distributor_BasicsRepository = new RB_Distributor_BasicsRepository();


        /// <summary>
        /// 获取用户分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_User_Extend> GetMemberUserPageList(int pageIndex, int pageSize, out long count, RB_Member_User_Extend dmodel) {
            var list= member_UserRepository.GetPageList(pageIndex, pageSize, out count, dmodel);
            if (list.Any()) {
                List<RB_Member_Grade_Extend> gradeList = new List<RB_Member_Grade_Extend>();
                if (list.Where(x => x.MemberGrade > 0).Any())
                {
                    var gradeIds = string.Join(",", list.Where(x => x.MemberGrade > 0).Select(x => x.MemberGrade ?? 0));
                    gradeList = member_GradeRepository.GetList(new RB_Member_Grade_Extend() { GradeIds = gradeIds, TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId });
                }
                foreach (var item in list) {
                    if (item.MemberGrade > 0)
                    {
                        item.MemberGradeName = gradeList.Where(x => x.Id == item.MemberGrade).FirstOrDefault()?.Name ?? "";
                    }
                    else {
                        item.MemberGradeName = "普通会员";
                    }
                }
            }
            return list;
        }

        /// <summary>
        /// 获取用户信息
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        public RB_Member_User_Extend GetMemberUserInfo(int userId)
        {
            return member_UserRepository.GetEntity(userId).RefMapperTo<RB_Member_User_Extend>();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_User_Extend> GetMemberUserList(RB_Member_User_Extend dmodel)
        {
            var list = member_UserRepository.GetList(dmodel);
            if (list.Any())
            {
                List<RB_Member_Grade_Extend> gradeList = new List<RB_Member_Grade_Extend>();
                if (list.Where(x => x.MemberGrade > 0).Any())
                {
                    var gradeIds = string.Join(",", list.Where(x => x.MemberGrade > 0).Select(x => x.MemberGrade ?? 0));
                    gradeList = member_GradeRepository.GetList(new RB_Member_Grade_Extend() { GradeIds = gradeIds, TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId });
                }
                foreach (var item in list)
                {
                    if (item.MemberGrade > 0)
                    {
                        item.MemberGradeName = gradeList.Where(x => x.Id == item.MemberGrade).FirstOrDefault()?.Name ?? "";
                    }
                    else
                    {
                        item.MemberGradeName = "普通会员";
                    }
                }
            }
            return list;
        }

        /// <summary>
        /// 获取等级分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_Grade_Extend> GetMemberGradePageList(int pageIndex, int pageSize, out long count, RB_Member_Grade_Extend dmodel) {
            var list = member_GradeRepository.GetPageList(pageIndex, pageSize, out count, dmodel);
            if (list.Any()) {
                string Ids = string.Join(",", list.Select(x => x.Id));
                var elist = member_EquityRepository.GetList(new RB_Member_Equity_Extend() { GradeIds = Ids, TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId });

                List<int> MaterialIds = new List<int>();
                MaterialIds.AddRange(list.Select(x => x.Icon ?? 0).Distinct().ToList());
                MaterialIds.AddRange(list.Select(x => x.BackgroundImage ?? 0).Distinct().ToList());
                List<RB_Material_Info_Extend> mlist = new List<RB_Material_Info_Extend>();
                if (MaterialIds.Any()) {
                    mlist = material_InfoRepository.GetList(new RB_Material_Info_Extend() { MaterialIds = string.Join(",", MaterialIds), TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId });
                }
                foreach (var item in list) {
                    item.EquityList = elist.Where(x => x.GradeId == item.Id).ToList();
                    item.IconPath = mlist.Where(x => x.Id == item.Icon).FirstOrDefault()?.Path ?? "";
                    item.BackgroundImagePath = mlist.Where(x => x.Id == item.BackgroundImage).FirstOrDefault()?.Path ?? "";
                }
            }
            return list;
        }

        /// <summary>
        /// 后台修改用户信息
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetMemberUserInfoForHT(RB_Member_User_Extend demodel)
        {
            Dictionary<string, object> files = new Dictionary<string, object>() {
                { nameof(RB_Member_User.MemberGrade),demodel.MemberGrade},
                { nameof(RB_Member_User.SuperiorId),demodel.SuperiorId},
                { nameof(RB_Member_User.ContactWay),demodel.ContactWay},
                { nameof(RB_Member_User.Remark),demodel.Remark},
                { nameof(RB_Member_User.AliasName),demodel.AliasName},
                { nameof(RB_Member_Grade.UpdateDate),demodel.UpdateDate}
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                    FiledName=nameof(RB_Member_User.Id),
                    FiledValue=demodel.Id,
                    OperatorEnum=OperatorEnum.Equal
                }
            };
            return member_UserRepository.Update(files, wheres);
        }

        /// <summary>
        /// 获取会员等级列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_Grade_Extend> GetMemberGradeList(RB_Member_Grade_Extend dmodel)
        {
            var list = member_GradeRepository.GetList(dmodel);
            if (list.Any())
            {
                string Ids = string.Join(",", list.Select(x => x.Id));
                var elist = member_EquityRepository.GetList(new RB_Member_Equity_Extend() { GradeIds = Ids, TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId });

                List<int> MaterialIds = new List<int>();
                MaterialIds.AddRange(list.Select(x => x.Icon ?? 0).Distinct().ToList());
                MaterialIds.AddRange(list.Select(x => x.BackgroundImage ?? 0).Distinct().ToList());
                List<RB_Material_Info_Extend> mlist = new List<RB_Material_Info_Extend>();
                if (MaterialIds.Any())
                {
                    mlist = material_InfoRepository.GetList(new RB_Material_Info_Extend() { MaterialIds = string.Join(",", MaterialIds), TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId });
                }
                foreach (var item in list)
                {
                    item.EquityList = elist.Where(x => x.GradeId == item.Id).ToList();
                    item.IconPath = mlist.Where(x => x.Id == item.Icon).FirstOrDefault()?.Path ?? "";
                    item.BackgroundImagePath = mlist.Where(x => x.Id == item.BackgroundImage).FirstOrDefault()?.Path ?? "";
                }
            }
            return list;
        }

        /// <summary>
        /// 新增会员等级
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetMemberGradeInfo(RB_Member_Grade_Extend demodel)
        {
            var trans = member_GradeRepository.DbTransaction;
            try
            {
                if (demodel.Id > 0)
                {
                    Dictionary<string, object> files = new Dictionary<string, object>() {
                        { nameof(RB_Member_Grade.BackgroundImage),demodel.BackgroundImage},
                        { nameof(RB_Member_Grade.Discount),demodel.Discount},
                        { nameof(RB_Member_Grade.Enabled),demodel.Enabled},
                        { nameof(RB_Member_Grade.Grade),demodel.Grade},
                        { nameof(RB_Member_Grade.Icon),demodel.Icon},
                        { nameof(RB_Member_Grade.IsAutoUpGrade),demodel.IsAutoUpGrade},
                        { nameof(RB_Member_Grade.IsMemberBuy),demodel.IsMemberBuy},
                        { nameof(RB_Member_Grade.MemberBuyMoney),demodel.MemberBuyMoney},
                        { nameof(RB_Member_Grade.MemberSpecification),demodel.MemberSpecification},
                        { nameof(RB_Member_Grade.Name),demodel.Name},
                        { nameof(RB_Member_Grade.UpGradeMoney),demodel.UpGradeMoney},
                        { nameof(RB_Member_Grade.UpdateDate),demodel.UpdateDate},
                    };
                    List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                         FiledName=nameof(RB_Member_Grade.Id),
                          FiledValue=demodel.Id,
                           OperatorEnum=OperatorEnum.Equal
                        }
                    };
                    bool flag = member_GradeRepository.Update(files, wheres, trans);
                    if (flag) {
                        var elist = member_EquityRepository.GetList(new RB_Member_Equity_Extend() { GradeId = demodel.Id });
                        List<RB_Member_Equity_Extend> InsertList = new List<RB_Member_Equity_Extend>();
                        List<RB_Member_Equity_Extend> UpdateList = new List<RB_Member_Equity_Extend>();
                        List<RB_Member_Equity_Extend> DeleteList = new List<RB_Member_Equity_Extend>();
                        if (demodel.EquityList != null && demodel.EquityList.Any()) {
                            InsertList = demodel.EquityList.Where(x => x.Id == 0).ToList();
                            UpdateList = demodel.EquityList.Where(x => elist.Select(y => y.Id).Contains(x.Id)).ToList();
                            DeleteList = elist.Where(x => !demodel.EquityList.Select(y => y.Id).Contains(x.Id)).ToList();
                        }
                        foreach (var item in InsertList) {
                            member_EquityRepository.Insert(new RB_Member_Equity()
                            {
                                Content = item.Content,
                                CreateDate = demodel.CreateDate,
                                GradeId = demodel.Id,
                                Id = 0,
                                Image = item.Image,
                                MallBaseId = demodel.MallBaseId,
                                Status = 0,
                                TenantId = demodel.TenantId,
                                Title = item.Title,
                                UpdateDate = demodel.CreateDate
                            }, trans);
                        }
                        foreach (var item in UpdateList) {
                            Dictionary<string, object> cols = new Dictionary<string, object>() {
                                { nameof(RB_Member_Equity.Content),item.Content},
                                { nameof(RB_Member_Equity.Image),item.Image},
                                { nameof(RB_Member_Equity.Title),item.Title},
                                { nameof(RB_Member_Equity.UpdateDate),demodel.UpdateDate},
                            };
                            List<WhereHelper> wheres1 = new List<WhereHelper>() {
                                new WhereHelper(){
                                     FiledName=nameof(RB_Member_Equity.Id),
                                      FiledValue=item.Id,
                                       OperatorEnum=OperatorEnum.Equal
                                }
                            };
                            member_EquityRepository.Update(cols, wheres1, trans);
                        }
                        foreach (var item in DeleteList) {
                            Dictionary<string, object> cols = new Dictionary<string, object>() {
                                { nameof(RB_Member_Equity.Status),1},
                                { nameof(RB_Member_Equity.UpdateDate),demodel.UpdateDate},
                            };
                            List<WhereHelper> wheres1 = new List<WhereHelper>() {
                                new WhereHelper(){
                                     FiledName=nameof(RB_Member_Equity.Id),
                                      FiledValue=item.Id,
                                       OperatorEnum=OperatorEnum.Equal
                                }
                            };
                            member_EquityRepository.Update(cols, wheres1, trans);
                        }
                    }
                    member_GradeRepository.DBSession.Commit();
                    return flag;
                }
                else
                {
                    int Id = member_GradeRepository.Insert(demodel, trans);
                    bool flag = Id > 0;
                    if (flag)
                    {
                        //插入权益
                        if (demodel.EquityList != null && demodel.EquityList.Any())
                        {
                            foreach (var item in demodel.EquityList)
                            {
                                member_EquityRepository.Insert(new Model.Entity.User.RB_Member_Equity()
                                {
                                    Content = item.Content,
                                    CreateDate = demodel.CreateDate,
                                    GradeId = Id,
                                    Id = 0,
                                    Image = item.Image,
                                    MallBaseId = demodel.MallBaseId,
                                    Status = 0,
                                    TenantId = demodel.TenantId,
                                    Title = item.Title,
                                    UpdateDate = demodel.CreateDate
                                }, trans);
                            }
                        }
                    }
                    member_GradeRepository.DBSession.Commit();
                    return flag;
                }
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "SetMemberGradeInfo");
                member_GradeRepository.DBSession.Rollback();
                return false;
            }
        }

        /// <summary>
        /// 删除会员等级
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelMemberGradeInfo(int gradeId, string uid)
        {
            Dictionary<string, object> cols = new Dictionary<string, object>() {
                { nameof(RB_Member_Grade.Status),1},
                { nameof(RB_Member_Grade.UpdateDate),DateTime.Now},
            };
            List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Member_Grade.Id),
                        FiledValue=gradeId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Member_Grade.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            return member_GradeRepository.Update(cols, wheres1);
        }

        /// <summary>
        /// 获取积分分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Member_Integral_Extend> GetMemberIntegralPageList(int pageIndex, int pageSize, out long count, RB_Member_Integral_Extend demodel)
        {
            return member_IntegralRepository.GetPageList(pageIndex, pageSize, out count, demodel);
        }

        /// <summary>
        /// 保存积分
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetMemberIntegralInfo(RB_Member_Integral_Extend demodel)
        {
            var umodel = member_UserRepository.GetEntity(demodel.UserId);
            int Integral = 0;
            if (demodel.Type == 1)
            {
                Integral = (umodel.Integral ?? 0) + (demodel.Integral ?? 0);
            }
            else {
                Integral = (umodel.Integral ?? 0) - (demodel.Integral ?? 0);
            }
            if (Integral < 0) {
                Integral = 0;
            }
            Dictionary<string, object> keys = new Dictionary<string, object>() {
                { nameof(RB_Member_User.Integral),Integral}
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                    FiledName=nameof(RB_Member_User.Id),
                    FiledValue=demodel.UserId,
                    OperatorEnum=OperatorEnum.Equal
                }
            };
            bool flag = member_UserRepository.Update(keys, wheres);
            if (flag)
            {
                return member_IntegralRepository.Insert(demodel) > 0;
            }
            return false;
        }

        /// <summary>
        /// 获取余额分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Member_Balance_Extend> GetMemberBalancePageList(int pageIndex, int pageSize, out long count, RB_Member_Balance_Extend demodel)
        {
            return member_BalanceRepository.GetPageList(pageIndex, pageSize, out count, demodel);
        }

        /// <summary>
        /// 保存余额充值
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetMemberBalanceInfo(RB_Member_Balance_Extend demodel)
        {
            var umodel = member_UserRepository.GetEntity(demodel.UserId);
            decimal Balance = 0;
            if (demodel.Type == 1)
            {
                Balance = (umodel.Balance ?? 0) + (demodel.Balance ?? 0);
            }
            else
            {
                Balance = (umodel.Balance ?? 0) - (demodel.Balance ?? 0);
            }
            if (Balance < 0)
            {
                Balance = 0;
            }
            Dictionary<string, object> keys = new Dictionary<string, object>() {
                { nameof(RB_Member_User.Balance),Balance}
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                    FiledName=nameof(RB_Member_User.Id),
                    FiledValue=demodel.UserId,
                    OperatorEnum=OperatorEnum.Equal
                }
            };
            bool flag = member_UserRepository.Update(keys, wheres);
            if (flag)
            {
                return member_BalanceRepository.Insert(demodel) > 0;
            }
            return false;
        }

        /// <summary>
        /// 设置分销基础配置
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetDistributorBasicsInfo(RB_Distributor_Basics_Extend demodel)
        {
            var OModel = distributor_BasicsRepository.GetList(new RB_Distributor_Basics_Extend() { TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId }).FirstOrDefault();
            if (OModel != null)
            {
                demodel.Id = OModel.Id;
                Dictionary<string, object> keyValuePairs = new Dictionary<string, object>() {
                    { nameof(RB_Distributor_Basics.DistributorTier),demodel.DistributorTier},
                    { nameof(RB_Distributor_Basics.InPurchasing),demodel.InPurchasing},
                    { nameof(RB_Distributor_Basics.ReferralsCondition),demodel.ReferralsCondition},
                    { nameof(RB_Distributor_Basics.ApplyFor),demodel.ApplyFor},
                    { nameof(RB_Distributor_Basics.DistributorCondition),demodel.DistributorCondition},
                    { nameof(RB_Distributor_Basics.DistributorCommissionType),demodel.DistributorCommissionType},
                    { nameof(RB_Distributor_Basics.OneCommission),demodel.OneCommission},
                    { nameof(RB_Distributor_Basics.TwoCommission),demodel.TwoCommission},
                    { nameof(RB_Distributor_Basics.ThreeCommission),demodel.ThreeCommission},
                    { nameof(RB_Distributor_Basics.GradeEntrance),demodel.GradeEntrance},
                    { nameof(RB_Distributor_Basics.GradeEntranceimage),demodel.GradeEntranceimage},
                    { nameof(RB_Distributor_Basics.WithdrawWay),demodel.WithdrawWay},
                    { nameof(RB_Distributor_Basics.MinimumWithdrawalLimit),demodel.MinimumWithdrawalLimit},
                    { nameof(RB_Distributor_Basics.DailyWithdrawalLimit),demodel.DailyWithdrawalLimit},
                    { nameof(RB_Distributor_Basics.WithdrawFee),demodel.WithdrawFee},
                    { nameof(RB_Distributor_Basics.ApplicationProtocol),demodel.ApplicationProtocol},
                    { nameof(RB_Distributor_Basics.UserNotes),demodel.UserNotes},
                    { nameof(RB_Distributor_Basics.BackgroundImage),demodel.BackgroundImage},
                    { nameof(RB_Distributor_Basics.IndexImage),demodel.IndexImage},
                    { nameof(RB_Distributor_Basics.UpdateDate),demodel.UpdateDate}
                };
                List<WhereHelper> whereHelpers = new List<WhereHelper>() {
                    new WhereHelper(){
                         FiledName=nameof(RB_Distributor_Basics.Id),
                          FiledValue=demodel.Id,
                           OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper(){
                         FiledName=nameof(RB_Distributor_Basics.TenantId),
                          FiledValue=demodel.TenantId,
                           OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper(){
                         FiledName=nameof(RB_Distributor_Basics.MallBaseId),
                          FiledValue=demodel.MallBaseId,
                           OperatorEnum=OperatorEnum.Equal
                    }
                };
                return distributor_BasicsRepository.Update(keyValuePairs, whereHelpers);
            }
            else
            {
                return distributor_BasicsRepository.Insert(demodel) > 0;
            }
        }

        /// <summary>
        /// 获取分销基础信息
        /// </summary>
        /// <param name="basicsId"></param>
        /// <returns></returns>
        public RB_Distributor_Basics_Extend GetDistributorBasicsInfo(int basicsId)
        {
            var model = distributor_BasicsRepository.GetEntity(basicsId).RefMapperTo<RB_Distributor_Basics_Extend>();
            if (model == null) {
                return new RB_Distributor_Basics_Extend();
            }
            model.IndexImagePath = material_InfoRepository.GetEntity(model.IndexImage)?.Path ?? "";
            model.BackgroundImagePath = material_InfoRepository.GetEntity(model.BackgroundImage)?.Path ?? "";
            return model;
        }

        public RB_Distributor_Basics_Extend GetDistributorBasicsInfo(string uid, int mallBaseId)
        {
            var model = distributor_BasicsRepository.GetList(new RB_Distributor_Basics_Extend() { TenantId = Convert.ToInt32(uid), MallBaseId = mallBaseId }).FirstOrDefault();
            if (model == null)
            {
                return new RB_Distributor_Basics_Extend();
            }
            model.IndexImagePath = material_InfoRepository.GetEntity(model.IndexImage)?.Path ?? "";
            model.BackgroundImagePath = material_InfoRepository.GetEntity(model.BackgroundImage)?.Path ?? "";
            return model;
        }
    }
}
