﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum;
using Mall.Common.Enum.MarketingCenter;
using VT.FW.DB;

namespace Mall.Model.Entity.MarketingCenter
{

    /// <summary>
    /// 活动基础配置表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_ActivitySurvey
    { /// <summary>
      /// 编号
      /// </summary>
        public int ID { get; set; }
        /// <summary>
        /// 标题
        /// </summary>

        public string Title { get; set; }


        /// <summary>
        /// 活动开始时间
        /// </summary>
        public DateTime? StartDate { get; set; }


        /// <summary>
        /// 活动结束时间
        /// </summary>
        public DateTime? EndDate { get; set; }


        /// <summary>
        /// 份数
        /// </summary>
        public int SurveyNum { get; set; }

        /// <summary>
        /// 活动说明
        /// </summary>
        public string Description { get; set; }


        /// <summary>
        /// 奖品地址
        /// </summary>
        public string PrizeAddress { get; set; }

        /// <summary>
        /// 奖品类型
        /// </summary>
        public PrizeTypeEnum? PrizeType { get; set; }

        /// <summary>
        /// 删除
        /// </summary>
        public DateStateEnum State { get; set; }

        /// <summary>
        /// 
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// 
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }

        /// <summary>
        /// 创建时间
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }

        /// <summary>
        /// 修改时间
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
    }
}
