﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Finance;
using VT.FW.DB;

namespace Mall.Model.Extend.Finance
{
    /// <summary>
    /// 单据交易方式扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "FinanceConnection")]
    public class RB_TradeWay_Extend : RB_TradeWay
    {
        /// <summary>
        /// 所属公司id
        /// </summary>
        public int? BranchId { get; set; }
        /// <summary>
        /// 财务单据id Str
        /// </summary>
        public string FrIdStr { get; set; }
        /// <summary>
        /// 币种
        /// </summary>
        public string CurrencyName { get; set; }
        /// <summary>
        /// 别名
        /// </summary>
        public string Alias { get; set; }
        /// <summary>
        /// 开户行
        /// </summary>
        public string Openingbank { get; set; }
        /// <summary>
        ///账号
        /// </summary>
        public string BankNo { get; set; }
        /// <summary>
        /// 所属平台
        /// </summary>
        public int? BackId { get; set; }
        /// <summary>
        /// 账户类型
        /// </summary>
        public int? AccountTypeId
        {
            get; set;
        }
        /// <summary>
        /// 账户类型字符串
        /// </summary>
        public string AccountType { get; set; }
        /// <summary>
        /// 交易凭证
        /// </summary>
        public List<RB_Voucher> vorcherInos { get; set; }
    }
}
