﻿using System;
using System.Collections.Generic;
using System.Linq;
using Dnc.Api.Throttle;
using Mall.CacheManager.User;
using Mall.Common;
using Mall.Common.API;
using Mall.Common.Enum;
using Mall.Common.Enum.Goods;
using Mall.Common.Enum.MarketingCenter;
using Mall.Common.Plugin;
using Mall.Model.Extend.Coffee;
using Mall.Model.Extend.Product;
using Mall.Module.Education;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace Mall.WebApi.Controllers.Education
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class CoffeeController : BaseController
    {
        private readonly CoffeeModule coffeeModule = new CoffeeModule();

        /// <summary>
        /// 获取咖啡劵统计
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetCoffeeStatistics()
        {
            RB_Member_CoffeeLog_Extend demodel = JsonHelper.DeserializeObject<RB_Member_CoffeeLog_Extend>(base.RequestParm.msg.ToString());
            demodel.MallBaseId = RequestParm.MallBaseId;

            var list = coffeeModule.GetCoffeeStatistics(demodel);
            return ApiResult.Success("", list);
        }

        /// <summary>
        /// 咖啡劵统计下载
        /// </summary>
        [HttpPost]
        public FileContentResult GetCoffeeStatisticsToExcel()
        {
            RB_Member_CoffeeLog_Extend demodel = JsonHelper.DeserializeObject<RB_Member_CoffeeLog_Extend>(base.RequestParm.msg.ToString());
            demodel.MallBaseId = RequestParm.MallBaseId;
            string ExcelName = "咖啡" + (demodel.SelectType == 1 ? "日报表" : demodel.SelectType == 2 ? "月报表" : "年报表") + DateTime.Now.ToString("yyyyMMddHHmmss") + ".xls";
            List<ExcelDataSource> slist = new List<ExcelDataSource>();
            ExcelDataSource header = new ExcelDataSource()
            {
                ExcelRows = new List<ExcelColumn>(30) {
                    new ExcelColumn(value: "日期") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "核销人") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "员工赠送") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "员工购买") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "学员赠送") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "学员购买") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "来宾赠送") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "来宾购买") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "收款") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "出品杯数") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER }
                }
            };
            slist.Add(header);

            try
            {
                List<ExcelDataSource> list = coffeeModule.GetCoffeeStatisticsToExcel(demodel);
                slist.AddRange(list);

                var byteData = ExcelTempLateHelper.ToExcelExtend(slist);

                return File(byteData, "application/octet-stream", ExcelName);
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, string.Format("GetFileFromWebApi_requestData: {0}", JsonHelper.Serialize(RequestParm)));
                var byteData1 = ExcelTempLateHelper.ToExcelExtend(slist);
                return File(byteData1, "application/octet-stream", ExcelName);
            }

        }

        /// <summary>
        /// 获取咖啡劵消费分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetCoffeeCouponsPageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(base.RequestParm.msg.ToString());
            RB_Member_CoffeeLog_Extend demodel = JsonHelper.DeserializeObject<RB_Member_CoffeeLog_Extend>(base.RequestParm.msg.ToString());
            demodel.MallBaseId = RequestParm.MallBaseId;

            var list = coffeeModule.GetCoffeeCouponsPageList(pageModel.pageIndex, pageModel.pageSize, out long count, demodel);
            pageModel.count = Convert.ToInt32(count);
            pageModel.pageData = list.Select(x => new
            {
                x.Id,
                x.Type,
                x.BuyType,
                x.Number,
                x.Remark,
                x.EmpType,
                x.UserName,
                x.UserIcon,                
                x.EmpStuName,
                CreateByName = x.EmpName,
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:mm")
            });
            return ApiResult.Success("", pageModel);
        }

        /// <summary>
        /// 导出咖啡劵明细
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public FileContentResult GetCoffeeCouponsListToExcel()
        {
            string ExcelName = "咖啡使用明细" + DateTime.Now.ToString("yyyyMMddHHmmss") + ".xls";
            List<ExcelDataSource> slist = new List<ExcelDataSource>();
            ExcelDataSource header = new ExcelDataSource()
            {
                ExcelRows = new List<ExcelColumn>(30) {
                    new ExcelColumn(value: "用户名称") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "用户头像") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "使用类型") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "消费类型") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "员工类型") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "员工/学员") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "数量") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "备注") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "核销人") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "时间") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER }
                }
            };
            slist.Add(header);

            try
            {
                RB_Member_CoffeeLog_Extend demodel = JsonHelper.DeserializeObject<RB_Member_CoffeeLog_Extend>(base.RequestParm.msg.ToString());
                demodel.MallBaseId = RequestParm.MallBaseId;
                //不能超过2月时间
                if ((Convert.ToDateTime(demodel.EndTime) - Convert.ToDateTime(demodel.StartTime)).Days > 62) {
                    var byteData1 = ExcelTempLateHelper.ToExcelExtend(slist);
                    return File(byteData1, "application/octet-stream", ExcelName);
                }

                var list = coffeeModule.GetCoffeeCouponsPageList(1, 9999, out long count, demodel);
                foreach (var item in list) {
                    ExcelDataSource datarow = new ExcelDataSource()
                    {
                        ExcelRows = new List<ExcelColumn>(30) {
                                new ExcelColumn(value: item.UserName){ },
                                new ExcelColumn(value: item.UserIcon){ },
                                new ExcelColumn(value: item.Type ==1?"存入":"消费"){ },
                                new ExcelColumn(value: item.BuyType ==1?"赠送":item.BuyType==2?"购买":"-"){ },
                                new ExcelColumn(value: item.EmpType==1?"员工":item.EmpType==2?"学员":"来宾"){ },
                                new ExcelColumn(value: item.EmpStuName){ },
                                new ExcelColumn(value: item.Number.ToString()){ },
                                new ExcelColumn(value: item.Remark){ },
                                new ExcelColumn(value: item.EmpName){ },
                                new ExcelColumn(value: item.CreateDate.ToString("yyyy-MM-dd HH:mm")){ },
                            },
                        ColumnHight = 30
                    };
                    slist.Add(datarow);
                }

                var byteData = ExcelTempLateHelper.ToExcelExtend(slist);

                return File(byteData, "application/octet-stream", ExcelName);
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, string.Format("GetFileFromWebApi_requestData: {0}", JsonHelper.Serialize(RequestParm)));
                var byteData1 = ExcelTempLateHelper.ToExcelExtend(slist);
                return File(byteData1, "application/octet-stream", ExcelName);
            }

        }
    }
}