﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Finance;

namespace Mall.Model.Extend.Product
{
    /// <summary>
    /// 商品订单明细表扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_OrderDetail_Extend : RB_Goods_OrderDetail
    {
        /// <summary>
        /// 用户id
        /// </summary>
        public int? UserId { get; set; }
        /// <summary>
        /// 商品乘坐人数
        /// </summary>
        public int? GoodsRideNum { get; set; }
        /// <summary>
        /// 订单财务单据列表
        /// </summary>
        public List<RB_Finance_Extend> FinanceList { get; set; }
        /// <summary>
        /// 是否直播订单
        /// </summary>
        public int? IsLiveOrder { get; set; }
        /// <summary>
        /// 单据状态  1已制单   2未制单
        /// </summary>
        public int? FinanceStatus { get; set; }
        /// <summary>
        /// 会员优惠
        /// </summary>
        public object Discounts { get; set; }
        /// <summary>
        /// 属性列表
        /// </summary>
        public object Attr_list { get; set; }
        /// <summary>
        /// 快递费用
        /// </summary>
        public decimal? Express { get; set; }
        /// <summary>
        /// 推荐返佣
        /// </summary>
        public RB_Goods_OrderIntroduction_Extend OrderIntroduction { get; set; }
        /// <summary>
        /// 微店返佣
        /// </summary>
        public RB_SmallShops_Commission_Extend SmallShopsCommission { get; set; }
        /// <summary>
        /// 返佣的总金额
        /// </summary>
        public decimal TCommissionMoney { get; set; }
        /// <summary>
        /// 重量
        /// </summary>
        public int? GoodsWeight { get; set; }
        /// <summary>
        /// 订单ids
        /// </summary>
        public string OrderIds { get; set; }
        /// <summary>
        /// 商品副标题
        /// </summary>
        public string GoodsSubName { get; set; }
        /// <summary>
        /// 图片地址
        /// </summary>
        public string CoverImagePath { get; set; }
        /// <summary>
        /// 明细ids
        /// </summary>
        public string OrderDetailIds { get; set; }
        /// <summary>
        /// 是否已发货
        /// </summary>
        public int? IsBindExpress { get; set; }
        /// <summary>
        /// 商品分类ids
        /// </summary>
        public List<int> CategoryIdList { get; set; }
        /// <summary>
        /// 剩余库存
        /// </summary>
        public int InventoryNum { get; set; }
        /// <summary>
        /// 规格价格列表id
        /// </summary>
        public int SpeciPriceId { get; set; }
        /// <summary>
        /// 是否开启单独返佣  1是  2否
        /// </summary>
        public int? SeparateDistribution { get; set; }
        /// <summary>
        /// 分销类型 1普通  2详细
        /// </summary>
        public int? SeparateDistributionType { get; set; }
        /// <summary>
        /// 分销佣金类型  1百分比  2固定值
        /// </summary>
        public int? SeparateDistributionMoneyType { get; set; }

        /// <summary>
        /// 规格列表
        /// </summary>
        public List<string> SpecificationList { get; set; }
        /// <summary>
        /// 规格名称列表
        /// </summary>
        public List<string> SpecificationNameList { get; set; }
        /// <summary>
        /// 是否申请售后
        /// </summary>
        public int? IsApplyForAfterSale { get; set; }

        /// <summary>
        /// 会员价格
        /// </summary>
        public decimal MemberPrice { get; set; }
        /// <summary>
        /// 佣金金额
        /// </summary>
        public decimal CommissionPrice { get; set; }
        /// <summary>
        /// 正常商品金额
        /// </summary>
        public decimal NorGoodsMoney { get; set; }

        /// <summary>
        /// 积分赠送
        /// </summary>        
        public int? IntegralPresent
        {
            get;
            set;
        }
        /// <summary>
        /// 赠送类型  2固定值  1百分比
        /// </summary>        
        public int? IntegralPresentType
        {
            get;
            set;
        }

        #region 自动生成收入单据新增字段

        /// <summary>
        /// 订单号
        /// </summary>
        public string OrderNo { get; set; }


        /// <summary>
        /// 1-商品，2-运费,3-保险
        /// </summary>
        public int FinanceType { get; set; }
        #endregion
        #region 供应商商品信息
        public string StartTime { get; set; }

        public string EndTime { get; set; }


        /// <summary>
        /// 是否制单
        /// </summary>
        public int IsFinance { get; set; }


        /// <summary>
        /// 订单商品ids
        /// </summary>
        public List<int> IdList { get; set; }


        public int IsPublic { get; set; }
        #endregion


        /// <summary>
        /// 供应商名称
        /// </summary>
        public string SupplierName { get; set; }


        /// <summary>
        /// 是否查询所有，0-全部，1-成本，2-运费，3-保险成本
        /// </summary>
        public int IsSelectAll { get; set; }


        /// <summary>
        /// 订单分类  0正常订单  1司导订单
        /// </summary>
        public int OrderClassify { get; set; }

        /// <summary>
        /// 规格key（出库的规格），没有修改为
        /// </summary>
        public string NewSpecificationSort { get; set; }


        /// <summary>
        /// 规格(出库的规格名称)
        /// </summary>        
        public string NewSpecification
        {
            get;
            set;
        }


        /// <summary>
        /// 规格(出库的数量)
        /// </summary>        
        public int NewNumber
        {
            get;
            set;
        }


        /// <summary>
        /// 商品id
        /// </summary>        
        public int NewGoodsId
        {
            get;
            set;
        }


        /// <summary>
        /// 出库商品名称
        /// </summary>
        public string NewGoodsName { get; set; }


        /// <summary>
        /// 财务单据创建人
        /// </summary>
        public int FinanceCreateBy { get; set; }


        #region 司导信息
        /// <summary>
        /// 站点名称
        /// </summary>
        public string SiteName { get; set; }
        /// <summary>
        /// 导游名称
        /// </summary>
        public string GuideName { get; set; }

        /// <summary>
        /// 从业年限
        /// </summary>
        public decimal GuideWorkYears { get; set; }

        /// <summary>
        /// 用户评分
        /// </summary>
        public decimal GuideScore { get; set; }

        /// <summary>
        /// 联系电话
        /// </summary>
        public string GuideTelephone { get; set; }



        /// <summary>
        /// 头像
        /// </summary>
        public string GuidePhoto { get; set; }

        /// <summary>
        /// 车辆名称
        /// </summary>
        public string CarName { get; set; }
        /// <summary>
        /// 车辆颜色
        /// </summary>
        public string CarColorName { get; set; }


        /// <summary>
        /// 车辆类型
        /// </summary>
        public int? CarClass { get; set; }

        /// <summary>
        /// 车辆品牌
        /// </summary>
        public string CarBrandName { get; set; }

        /// <summary>
        /// 乘坐人数
        /// </summary>
        public int RideNum { get; set; }

        /// <summary>
        /// 车辆类型
        /// </summary>
        public string GuideCarType { get; set; }



        #endregion

    }
}
