﻿using Mall.Common.AOP;
using Mall.Model.Entity.Finance;
using System;
using System.Collections.Generic;

namespace Mall.Model.Extend.Finance
{
    /// <summary>
    /// 公司银行账户表扩展 实体
    /// </summary> 
    [Serializable]
    [DB(ConnectionName = "FinanceConnection")]
    public class RB_BackAccount_Extend : RB_BackAccount
    {
        /// <summary>
        /// 期初开始时间str
        /// </summary>
        public string BeginTimeStr { get; set; }
        /// <summary>
        /// 账户id Str
        /// </summary>
        public string AccountIdStr { get; set; }
        /// <summary>
        /// 模板ID
        /// </summary>
        public int? TemplateId { get; set; }
        /// <summary>
        /// 账户是否配置收款0-否1-是
        /// </summary>
        public int? Is_Income { get; set; }
        /// <summary>
        /// 账户是否配置支款0-否1-是
        /// </summary>
        public int? Is_Outcome { get; set; }
        /// <summary>
        /// 收款负责人名称
        /// </summary>
        public string InemName { get; set; }
        /// <summary>
        /// 付款负责人
        /// </summary>
        public string OutemName { get; set; }
        /// <summary>
        /// 上期损益
        /// </summary>
        public decimal? ProfitLossMoney { get; set; }
        /// <summary>
        /// 公司ID
        /// </summary>
        public int? BranchId
        {
            get;
            set;
        }
        /// <summary>
        /// 账户分类名称
        /// </summary>
        public string AccountTypeName { set; get; }

        /// <summary>
        /// 币种
        /// </summary>
        public string CurrencyName { get; set; }

        /// <summary>
        /// 银行名称
        /// </summary>
        public string BackName { get; set; }

        /// <summary>
        /// 银行logo
        /// </summary>
        public string BackLogo { get; set; }

        /// <summary>
        /// 账户类型
        /// </summary>
        public string TypeName { get; set; }
        /// <summary>
        /// 汇率
        /// </summary>
        public decimal? Rate { get; set; }
        /// <summary>
        /// 币种汇率
        /// </summary>
        public decimal? CurrencyRate { get; set; }
        /// <summary>
        /// 付款汇率
        /// </summary>
        public decimal PayRate { get; set; }
        /// <summary>
        /// 上调汇率
        /// </summary>
        public decimal ExchangeRates { get; set; }
        /// <summary>
        /// 币种类型
        /// </summary>
        public int IsStandardCurrency { get; set; }
        /// <summary>
        /// 外币货币代码
        /// </summary>
        public string CurrencyCode { get; set; }
        /// <summary>
        /// 本位币货币代码
        /// </summary>
        public string StandardCurrencyCode { get; set; }
        /// <summary>
        /// 账户分类
        /// </summary>
        public int? BankType { get; set; }
        /// <summary>
        ///公私
        /// </summary>
        public int? Is_Public { get; set; }

        /// <summary>
        /// 公司名称
        /// </summary>
        public string BranchName { get; set; }

    }
}