﻿using Mall.Common.AOP;
using Mall.Common.Enum.User;
using Mall.Model.Extend.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 专题表扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Topic_Extend : Model.Entity.User.RB_Topic
    {
        /// <summary>
        /// 专题名称
        /// </summary>
        public string TopicName { get; set; }

        /// <summary>
        /// 专题列表布局方式
        /// </summary>
        public string FlexTypeStr
        {
            get
            {
                string str = "";
                if (this.FlexType > 0)
                {
                    switch (Convert.ToInt32(this.FlexType))
                    {
                        case 1: str = "小图模式"; break;
                        case 2: str = "大图模式"; break;
                        case 3: str = "多图模式"; break;
                    }
                }
                return str;
            }
        }

        /// <summary>
        /// 是否精选字符串
        /// </summary>
        public string IsChoiceStr
        {
            get
            {
                string str = "";
                if (this.IsChoice >= 0)
                {
                    switch (Convert.ToInt32(this.IsChoice))
                    {
                        case 0: str = "否"; break;
                        case 1: str = "是"; break;
                    }
                }
                return str;
            }
        }

        /// <summary>
        /// 前端组件
        /// </summary>
        public List<ComponentItem> ComponentDataList { get; set; }
    }
}
