﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Model.Extend.Product;
using Mall.Module.User;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Mall.Common.Plugin;
using Mall.Common.Enum.User;
using Mall.CacheManager.User;
using Newtonsoft.Json.Linq;
using Mall.Common;
using Mall.Module.Product;
using Mall.Model.Extend.User;

namespace Mall.WebApi.Controllers.MallBase
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class AppletOrderController : BaseController
    {

        private readonly OrderModule orderModule = new OrderModule();

        #region 购物车

        /// <summary>
        /// 获取用户购物车
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetGoodsShoppingCartPageList() {
            var parms = RequestParm;
            var userInfo = AppletUserInfo;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(parms.msg.ToString());
            RB_Goods_Extend demodel = JsonConvert.DeserializeObject<RB_Goods_Extend>(parms.msg.ToString());

            demodel.TenantId = userInfo.TenantId;
            demodel.MallBaseId = userInfo.MallBaseId;
            demodel.UserId = userInfo.UserId;
            var list = orderModule.GetGoodsShoppingCartPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.GoodsId,
                x.GoodsName,
                x.CoverImage,
                x.Price,
                x.InventoryNum,
                x.SpecificationList,
                x.Number,
                x.GoodsStatus,
                x.TenantId,
                x.MallBaseId,
                CreateDate = x.CreateDate.HasValue ? x.CreateDate.Value.ToString("yyyy-MM-dd HH:mm:ss") : ""
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 加入购物车
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetGoodsShoppingCartInfo() {
            var req = RequestParm;
            var userInfo = AppletUserInfo;
            RB_Goods_ShoppingCart_Extend demodel = JsonConvert.DeserializeObject<RB_Goods_ShoppingCart_Extend>(req.msg.ToString());
            if ((demodel.GoodsId??0) <= 0) {
                return ApiResult.ParamIsNull("请传递商品id");
            }
            if ((demodel.Number ?? 0) <= 0) {
                return ApiResult.ParamIsNull("数量必须大于0");
            }
            demodel.TenantId = userInfo.TenantId;
            demodel.MallBaseId = userInfo.MallBaseId;
            demodel.UserId = userInfo.UserId;
            demodel.SpecificationSort ??= "";
            return orderModule.SetGoodsShoppingCartGetInfo(demodel);
        }

        /// <summary>
        /// 设置购物车数量
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetGoodsShoppingCartNumGetInfo() {
            var req = RequestParm;
            var userInfo = AppletUserInfo;
            JObject prams = JObject.Parse(req.msg.ToString());
            int ShoppingCartId = prams.GetInt("ShoppingCartId", 0);
            int Number = prams.GetInt("Number", 0);
            if (ShoppingCartId <= 0 || Number <= 0) {
                return ApiResult.ParamIsNull();
            }

            bool flag = orderModule.SetGoodsShoppingCartNumGetInfo(ShoppingCartId, Number, userInfo.TenantId, userInfo.MallBaseId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else {
                return ApiResult.Failed();
            }
        }

        /// <summary>
        /// 删除购物车
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult DelGoodsShoppingCartInfo() {
            var req = RequestParm;
            var userInfo = AppletUserInfo;
            JObject prams = JObject.Parse(req.msg.ToString());
            string ShoppingCartIds = prams.GetStringValue("ShoppingCartIdList");            
            if (string.IsNullOrEmpty(ShoppingCartIds))
            {
                return ApiResult.ParamIsNull();
            }
            try
            {
                List<int> scList = JsonConvert.DeserializeObject<List<int>>(ShoppingCartIds);
                ShoppingCartIds = string.Join(",", scList);
            }
            catch (Exception)
            {
                return ApiResult.ParamIsNull("");
            }

            bool flag = orderModule.DelGoodsShoppingCartInfo(ShoppingCartIds, userInfo.UserId, userInfo.TenantId, userInfo.MallBaseId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }

        #endregion

        #region 订单管理

        /// <summary>
        /// 我的订单分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAppletGoodsMyOrderPageList()
        {
            var parms = RequestParm;
            var userInfo = AppletUserInfo;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(parms.msg.ToString());
            RB_Goods_Order_Extend demodel = JsonConvert.DeserializeObject<RB_Goods_Order_Extend>(parms.msg.ToString());

            demodel.TenantId = userInfo.TenantId;
            demodel.MallBaseId = userInfo.MallBaseId;
            demodel.UserId = userInfo.UserId;
            demodel.Recycled = 1;
            if (demodel.OrderStatus == Common.Enum.Goods.OrderStatusEnum.WaitSendGoods) {
                demodel.OrderStatusIds = "2,6";//待处理也是待发货状态才有的
                demodel.OrderStatus = 0;
            }
            var list = orderModule.GetAppletGoodsMyOrderPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.OrderId,
                x.OrderNo,
                x.DeliveryMethod,
                DeliveryMethodName = x.DeliveryMethod.GetEnumName(),
                x.Income,
                x.FreightMoney,
                x.CouponMoney,
                x.PaymentWay,
                PaymentWayName = x.PaymentWay.GetEnumName(),
                DetailList = x.DetailList.Select(y => new {
                    y.Id,
                    y.CoverImagePath,
                    y.OrderType,
                    OrderTypeName = y.OrderType.GetEnumName(),
                    y.GoodsName,
                    y.Specification,
                    y.ProductCode,
                    y.Final_Price,
                    y.Number
                }),
                x.OrderStatus,
                OrderStatusName = x.OrderStatus.GetEnumName(),
                x.TenantId,
                x.MallBaseId,
                CreateDate = x.CreateDate.HasValue ? x.CreateDate.Value.ToString("yyyy-MM-dd HH:mm:ss") : ""
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 获取我的订单详情
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAppletMyOrderInfo() {
            var req = RequestParm;
            var userInfo = AppletUserInfo;
            JObject parms = JObject.Parse(req.msg.ToString());
            int OrderId = parms.GetInt("OrderId", 0);
            if (OrderId <= 0)
            {
                return ApiResult.ParamIsNull();
            }

            return orderModule.GetAppletMyOrderInfo(OrderId, userInfo.UserId, userInfo.TenantId, userInfo.MallBaseId);
        }

        /// <summary>
        /// 获取我的订单商品售后初始信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAppletMyOrderAfterSaleInfo()
        {
            var req = RequestParm;
            var userInfo = AppletUserInfo;
            JObject parms = JObject.Parse(req.msg.ToString());
            int OrderDetailId = parms.GetInt("OrderDetailId", 0);
            if (OrderDetailId <= 0)
            {
                return ApiResult.ParamIsNull();
            }

            return orderModule.GetAppletMyOrderAfterSaleInfo(OrderDetailId, userInfo.UserId, userInfo.TenantId, userInfo.MallBaseId);
        }

        /// <summary>
        /// 申请售后
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetAppletMyOrderAfterSale() {
            var req = RequestParm;
            var userInfo = AppletUserInfo;
            JObject parms = JObject.Parse(req.msg.ToString());
            int OrderDetailId = parms.GetInt("OrderDetailId", 0);
            if (OrderDetailId <= 0)
            {
                return ApiResult.ParamIsNull();
            }

            return ApiResult.Success();
        }

        /// <summary>
        /// 获取我的订单快递信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAppletMyOrderExpressInfo() {
            var req = RequestParm;
            var userInfo = AppletUserInfo;
            JObject parms = JObject.Parse(req.msg.ToString());
            int OrderId = parms.GetInt("OrderId", 0);
            if (OrderId <= 0)
            {
                return ApiResult.ParamIsNull();
            }

            var Robj = orderModule.GetAppletMyOrderExpressInfo(OrderId, userInfo.TenantId, userInfo.MallBaseId);
            return ApiResult.Success("", Robj);
        }

        /// <summary>
        /// 结算页面详情
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAppletGoodsSettlementInfo() {
            var req = RequestParm;
            var userInfo = AppletUserInfo;
            RB_Goods_Order_Extend demodel = JsonConvert.DeserializeObject<RB_Goods_Order_Extend>(req.msg.ToString());

            if (demodel.DetailList == null || !demodel.DetailList.Any())
            {
                return ApiResult.ParamIsNull("请传递商品信息");
            }
            foreach (var item in demodel.DetailList)
            {
                if ((item.GoodsId ?? 0) <= 0)
                {
                    return ApiResult.ParamIsNull("请传递商品id");
                }
                if ((item.Number ?? 0) <= 0)
                {
                    return ApiResult.ParamIsNull("请传递商品数量");
                }
            }
            demodel.TenantId = userInfo.TenantId;
            demodel.MallBaseId = userInfo.MallBaseId;
            demodel.UserId = userInfo.UserId;
            return orderModule.GetAppletGoodsSettlementInfo(demodel);
        }

        /// <summary>
        /// 结算页面修改快递，获取快递费用
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAppletGoodsSettlementExpress()
        {
            var req = RequestParm;
            var userInfo = AppletUserInfo;
            RB_Goods_Order_Extend demodel = JsonConvert.DeserializeObject<RB_Goods_Order_Extend>(req.msg.ToString());
            if ((demodel.ShoppingAddressId ?? 0) <= 0) {
                return ApiResult.ParamIsNull("请传递收货地址id");
            }
            if (demodel.DetailList == null || !demodel.DetailList.Any())
            {
                return ApiResult.ParamIsNull("请传递商品信息");
            }
            foreach (var item in demodel.DetailList)
            {
                if ((item.GoodsId ?? 0) <= 0)
                {
                    return ApiResult.ParamIsNull("请传递商品id");
                }
                if ((item.Number ?? 0) <= 0)
                {
                    return ApiResult.ParamIsNull("请传递商品数量");
                }
            }
            demodel.TenantId = userInfo.TenantId;
            demodel.MallBaseId = userInfo.MallBaseId;
            demodel.UserId = userInfo.UserId;
            return orderModule.GetAppletGoodsSettlementExpress(demodel);
        }

        /// <summary>
        /// 下单
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetAppletGoodsOrderInfo() {
            var req = RequestParm;
            var userInfo = AppletUserInfo;
            RB_Goods_Order_Extend demodel = JsonConvert.DeserializeObject<RB_Goods_Order_Extend>(req.msg.ToString());
            if (demodel.IsFormShoppingCart == 1) {
                if (demodel.ShoppingCartIdList == null || !demodel.ShoppingCartIdList.Any()) {
                    return ApiResult.ParamIsNull("请传递购物车id");
                }
            }
            if (string.IsNullOrEmpty(demodel.Consignee)) {
                return ApiResult.ParamIsNull("请传递收件人");
            }
            if (string.IsNullOrEmpty(demodel.Mobile)) {
                return ApiResult.ParamIsNull("请传递收件人手机号码");
            }
            if (demodel.DeliveryMethod != Common.Enum.Goods.OrderDeliveryMethodEnum.VerificationShop)
            {
                if ((demodel.District ?? 0) <= 0)
                {
                    return ApiResult.ParamIsNull("收货地址有误");
                }
                if (string.IsNullOrEmpty(demodel.ShoppingAddress)) {
                    return ApiResult.ParamIsNull("收货详细地址不能为空");
                }
            }
           
            if (demodel.DetailList == null || !demodel.DetailList.Any()) {
                return ApiResult.ParamIsNull("请传递商品信息");
            }
            foreach (var item in demodel.DetailList) {
                if ((item.GoodsId ?? 0) <= 0) {
                    return ApiResult.ParamIsNull("请传递商品id");
                }
                if ((item.Number ?? 0) <= 0) {
                    return ApiResult.ParamIsNull("请传递商品数量");
                }
                if (string.IsNullOrEmpty(item.Specification)) {
                    return ApiResult.ParamIsNull("请传递规格名");
                }
            }
            
            demodel.BuyerMessage ??= "";//买家留言
            demodel.OrderSource ??= UserSourceEnum.WeiXin;
            #region 赋默认值
            demodel.TenantId = userInfo.TenantId;
            demodel.MallBaseId = userInfo.MallBaseId;
            demodel.Country ??= 2;
            demodel.OrderStatus = Common.Enum.Goods.OrderStatusEnum.NonPayment;
            demodel.CreateDate = DateTime.Now;
            demodel.Fee ??= 0;
            demodel.FreightMoney ??= 0;
            demodel.HistoryOrderStatus ??= 0;
            demodel.IsApplyForCancel ??= 2;
            demodel.IsOrderCommission ??= 2;
            demodel.MerchantsNo ??= "";
            demodel.Recycled ??= 2;
            demodel.Refund ??= 0;
            demodel.Status = 0;
            demodel.UpdateDate = DateTime.Now;
            demodel.UserId = userInfo.UserId;
            #endregion

            return orderModule.SetAppletGoodsOrderInfo(demodel);            
        }

        /// <summary>
        /// 未付款取消订单/已付款申请取消订单
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult CancelAppletGoodsOrderInfo() {
            var req = RequestParm;
            var userInfo = AppletUserInfo;
            JObject parms = JObject.Parse(req.msg.ToString());
            int OrderId = parms.GetInt("OrderId", 0);
            int Type = parms.GetInt("Type", 1);//1未付款取消  2已付款未发货申请取消
            string Remark = parms.GetStringValue("Remark");//type=2 申请备注
            if (OrderId <= 0) {
                return ApiResult.ParamIsNull();
            }
            if (Type == 2) {
                if (string.IsNullOrEmpty(Remark)) {
                    return ApiResult.ParamIsNull("请输入取消申请备注");
                }
            }

            bool flag = orderModule.CancelAppletGoodsOrderInfo(OrderId, Type, Remark, userInfo.UserId, userInfo.TenantId, userInfo.MallBaseId);
            if (flag) { return ApiResult.Success(); } else { return ApiResult.Failed(); }
        }

        #endregion
    }
}