﻿using Mall.Common.AOP;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 角色表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Role
    {

        /// <summary>
        /// 角色编号
        /// </summary>        
        public int RoleId
        {
            get;
            set;
        }

        /// <summary>
        /// 角色名称
        /// </summary>        
        public string RoleName
        {
            get;
            set;
        }

        /// <summary>
        /// 备注/描述
        /// </summary>        
        public string RoleIntro
        {
            get;
            set;
        }

        /// <summary>
        /// 角色权限
        /// </summary>        
        public string RoleAuth
        {
            get;
            set;
        }

        /// <summary>
        /// 商户号Id
        /// </summary>        
        public int? TenantId
        {
            get;
            set;
        }

        /// <summary>
        /// 小程序Id
        /// </summary>        
        public int? MallBaseId
        {
            get;
            set;
        }

        /// <summary>
        /// 状态(0-正常,1-删除)
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
    }
}
