﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Text;
using System.Threading.Tasks;

namespace DapperExtensions.Lambda
{
    /// <summary>
    /// WHERE 泛型接口
    /// </summary>
    /// <typeparam name="T"></typeparam>
    public interface IWhere<T> : IWhere where T : class
    {
        /// <summary>
        /// 新增And条件
        /// </summary>
        /// <param name="lambdaWhere">表达式</param>
        void And(Expression<Func<T, bool>> lambdaWhere);

        /// <summary>
        /// 新增And条件
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <param name="lambdaWhere">表达式</param>
        void And<T2>(Expression<Func<T, T2, bool>> lambdaWhere);

        /// <summary>
        /// 新增And条件
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <param name="lambdaWhere">表达式</param>
        void And<T2, T3>(Expression<Func<T, T2, T3, bool>> lambdaWhere);

        /// <summary>
        /// 新增And条件
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <typeparam name="T4">约束</typeparam>
        /// <param name="lambdaWhere">表达式</param>
        void And<T2, T3, T4>(Expression<Func<T, T2, T3, T4, bool>> lambdaWhere);

        /// <summary>
        /// 新增And条件
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <typeparam name="T4">约束</typeparam>
        /// <typeparam name="T5">约束</typeparam>
        /// <param name="lambdaWhere">表达式</param>
        void And<T2, T3, T4, T5>(Expression<Func<T, T2, T3, T4, T5, bool>> lambdaWhere);

        /// <summary>
        /// 新增And条件
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <typeparam name="T4">约束</typeparam>
        /// <typeparam name="T5">约束</typeparam>
        /// <typeparam name="T6">约束</typeparam>
        /// <param name="lambdaWhere">表达式</param>
        void And<T2, T3, T4, T5, T6>(Expression<Func<T, T2, T3, T4, T5, T6, bool>> lambdaWhere);

        /// <summary>
        /// 新增Or条件
        /// </summary>
        /// <param name="lambdaWhere">表达式</param>
        void Or(Expression<Func<T, bool>> lambdaWhere);

        /// <summary>
        /// 新增Or条件
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <param name="lambdaWhere">表达式</param>
        void Or<T2>(Expression<Func<T, T2, bool>> lambdaWhere);

        /// <summary>
        /// 新增Or条件
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <param name="lambdaWhere">表达式</param>
        void Or<T2, T3>(Expression<Func<T, T2, T3, bool>> lambdaWhere);

        /// <summary>
        /// 新增Or条件
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <typeparam name="T4">约束</typeparam>
        /// <param name="lambdaWhere">表达式</param>
        void Or<T2, T3, T4>(Expression<Func<T, T2, T3, T4, bool>> lambdaWhere);

        /// <summary>
        /// 新增Or条件
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <typeparam name="T4">约束</typeparam>
        /// <typeparam name="T5">约束</typeparam>
        /// <param name="lambdaWhere">表达式</param>
        void Or<T2, T3, T4, T5>(Expression<Func<T, T2, T3, T4, T5, bool>> lambdaWhere);

        /// <summary>
        /// 新增Or条件
        /// </summary>
        /// <typeparam name="T2">约束</typeparam>
        /// <typeparam name="T3">约束</typeparam>
        /// <typeparam name="T4">约束</typeparam>
        /// <typeparam name="T5">约束</typeparam>
        /// <typeparam name="T6">约束</typeparam>
        /// <param name="lambdaWhere">表达式</param>
        void Or<T2, T3, T4, T5, T6>(Expression<Func<T, T2, T3, T4, T5, T6, bool>> lambdaWhere);
    }

    /// <summary>
    /// WHERE接口
    /// </summary>
    public interface IWhere 
    {  
        /// <summary>
        /// 新增And条件
        /// </summary>
        /// <param name="where">where条件</param>

        void And(WhereClip where);

        /// <summary>
        /// 新增Or条件
        /// </summary>
        /// <param name="where">where条件</param>
        void Or(WhereClip where);

        /// <summary>
        /// 转换成WhereClip
        /// </summary>
        /// <returns></returns>
        WhereClip ToWhereClip();
    }
}
