﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum.Point;
using VT.FW.DB;

namespace Mall.Model.Entity.Point
{

    /// <summary>
    /// 排课分类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Point_CourseClass
    {
        public int ID { get; set; }
        /// <summary>
        /// 排序
        /// </summary>        
        public int? Sort
        {
            get;
            set;
        }

        /// <summary>
        /// 标题
        /// </summary>
        public string Title { get; set; }

        /// <summary>
        /// 分类图片
        /// </summary>
        public string ClassPic { get; set; }

        /// <summary>
        /// 分类类型
        /// </summary>
        public CourseClassTypeEnum CourseClassType { get; set; }


        /// <summary>
        /// 上课人数
        /// </summary>
        public StudentNumTypeEnum StudentNumType { get; set; }

        /// <summary>
        /// 是否为公开课0-否，1-是
        /// </summary>
        public int IsPublic { get; set; }


        /// <summary>
        /// 是否免费0-否，1-是
        /// </summary>
        public int IsFree { get; set; }


        /// <summary>
        /// 点数
        /// </summary>
        public int PointNum { get; set; }


        /// <summary>
        /// 多少时长
        /// </summary>
        public decimal Duration { get; set; }


        /// <summary>
        /// 时长单位
        /// </summary>
        public DurationUnitEnum DurationUnit { get; set; }



        /// <summary>
        /// 删除状态
        /// </summary>        
        public int? State
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }

    }
}
