﻿using Mall.Common.Enum;
using System;
using VT.FW.DB;

namespace Mall.Model.Entity.TradePavilion
{
    /// <summary>
    /// 韩国馆新闻实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Commerce_News
    {
        /// <summary>
        /// 主键编号
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 类型(1-新闻，2-服务类型)
        /// </summary>
        public int Type { get; set; }

        /// <summary>
        /// 封面图
        /// </summary>
        public string CoverImg { get; set; }

        /// <summary>
        /// 新闻标题
        /// </summary>
        public string Title { get; set; }

        /// <summary>
        /// 行业
        /// </summary>
        public string Industry { get; set; }

        /// <summary>
        /// 发布时间
        /// </summary>
        public DateTime PublishTime { get; set; }

        /// <summary>
        /// 新闻详情
        /// </summary>
        public string NewsInfo { get; set; }

        /// <summary>
        /// 商户号id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateDate { get; set; }

        /// <summary>
        /// 修改人
        /// </summary>
        public int UpdateBy { get; set; }

        /// <summary>
        /// 修改时间
        /// </summary>
        public DateTime UpdateDate { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>
        public DateStateEnum Status { get; set; }
    }
}
