﻿using Mall.Common.Enum;
using System;
using VT.FW.DB;

namespace Mall.Model.Entity.TradePavilion
{
	/// <summary>
	/// 公司信息实体类
	/// </summary>
	[Serializable]
	[DB(ConnectionName = "DefaultConnection")]
	public class RB_Company
    {
		/// <summary>
		/// 主键(公司编号)
		/// </summary>
		public int CompanyId { get; set; }

		/// <summary>
		/// 公司名称
		/// </summary>
		public string CompanyName { get; set; }

		/// <summary>
		/// 公司英文名称
		/// </summary>
		public string CompanyEnName { get; set; }

		/// <summary>
		/// 联系人(责任人)
		/// </summary>
		public string Principal { get; set; }

		/// <summary>
		/// 联系电话
		/// </summary>
		public string Mobile { get; set; }

		/// <summary>
		/// 邮箱
		/// </summary>
		public string EMail { get; set; }

		/// <summary>
		/// 法人
		/// </summary>
		public string LegalPerson { get; set; }

		/// <summary>
		/// 公司微信
		/// </summary>
		public string WechatNo { get; set; }

		/// <summary>
		/// 公司介绍
		/// </summary>
		public string CompanyIntro { get; set; }

		/// <summary>
		/// 官网
		/// </summary>
		public string DomainUrl { get; set; }

		/// <summary>
		/// 成立时间
		/// </summary>
		public DateTime? FoundingTime { get; set; }

		/// <summary>
		/// 员工人数
		/// </summary>
		public int EmployeeNum { get; set; }

		/// <summary>
		/// 年销售(万元)
		/// </summary>
		public decimal AnnualSales { get; set; }

		/// <summary>
		/// 年进口额
		/// </summary>
		public decimal AnnualImport { get; set; }

		/// <summary>
		/// 详细地址
		/// </summary>
		public string Address { get; set; }

		/// <summary>
		/// 详细地址(英文)
		/// </summary>
		public string EnAddress { get; set; }

		/// <summary>
		/// 行业
		/// </summary>
		public string Industry { get; set; }

		/// <summary>
		/// 主要出口国
		/// </summary>
		public string ExportCountry { get; set; }

		/// <summary>
		/// 主要进口国家
		/// </summary>
		public string ImportCountry { get; set; }

		/// <summary>
		/// 进口品目
		/// </summary>
		public string ImportCategory { get; set; }

		/// <summary>
		/// 其他内容
		/// </summary>
		public string OtherInfo { get; set; }

		/// <summary>
		/// 商户号id
		/// </summary>
		public int TenantId { get; set; }

		/// <summary>
		/// 小程序id
		/// </summary>
		public int MallBaseId { get; set; }

		/// <summary>
		/// 创建人
		/// </summary>
		public int CreateBy { get; set; }

		/// <summary>
		/// 创建时间
		/// </summary>
		public DateTime CreateDate { get; set; }

		/// <summary>
		/// 修改人
		/// </summary>
		public int UpdateBy { get; set; }

		/// <summary>
		/// 修改时间
		/// </summary>
		public DateTime UpdateDate { get; set; }

		/// <summary>
		/// 删除状态
		/// </summary>
		public DateStateEnum Status { get; set; }
	}
}
