﻿using Mall.Model.Entity.BaseSetUp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.BaseSetUp
{
    /// <summary>
    /// 微店基础设置仓储层
    /// </summary>
    public class RB_MicroShop_BasicsRepository : BaseRepository<RB_MicroShop_Basics>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_MicroShop_Basics); } }



        /// <summary>
        /// 微店基础配置
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_MicroShop_Basics> GetMicroShopBasicsPageList(int pageIndex, int pageSize, out long rowCount, RB_MicroShop_Basics query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE  {nameof(RB_MicroShop_Basics.Status)}=0");
            if (query != null)
            {
                // where += $@" and {nameof(RB_Customer_InfoCreate.CustomerId)}={dmodel.CustomerId}";
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_MicroShop_Basics.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_MicroShop_Basics.MallBaseId)}={query.MallBaseId}");
                }
               
            }
            return GetPage<RB_MicroShop_Basics>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 微店基础配置
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_MicroShop_Basics> GetMicroShopBasicsList(RB_MicroShop_Basics query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_MicroShop_Basics.Status)}=0 ");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND {nameof(RB_MicroShop_Basics.ID)}={query.ID}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_MicroShop_Basics.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_MicroShop_Basics.MallBaseId)}={query.MallBaseId}");
                }
               
            }
            return Get<RB_MicroShop_Basics>(builder.ToString()).ToList();
        }
    }
}
