﻿using Mall.Common.Enum;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.MarketingCenter
{
    /// <summary>
    /// 分享详情实体表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Share_Friend
    {
        /// <summary>
        /// 主键
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 分类编号
        /// </summary>
        public int CateId { get; set; }

        /// <summary>
        /// 商品编号
        /// </summary>
        public int GoodsId { get; set; }

        /// <summary>
        /// 封面图
        /// </summary>
        public string CoverImg { get; set; }

        /// <summary>
        /// 素材图片
        /// </summary>
        public string MaterialImg { get; set; }

        /// <summary>
        /// 素材文案
        /// </summary>
        public string MaterialInfo { get; set; }

        /// <summary>
        /// 链接地址
        /// </summary>
        public string LinkUrl { get; set; }

        /// <summary>
        /// 是否置顶(1-是）
        /// </summary>
        public int IsTop { get; set; }

        /// <summary>
        /// 排序
        /// </summary>
        public int SortNum { get; set; }

        /// <summary>
        /// 启用-1,禁用-0
        /// </summary>
        public int IsUse { get; set; }

        /// <summary>
        /// 删除状态(1-删除)
        /// </summary>
        public DateStateEnum Status { get; set; }

        /// <summary>
        /// 商户号
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateDate { get; set; }

        /// <summary>
        /// 更新人
        /// </summary>
        public int UpdateBy { get; set; }

        /// <summary>
        /// 更新时间
        /// </summary>
        public DateTime UpdateDate { get; set; }

        /// <summary>
        /// 分享数量
        /// </summary>
        public int ShareCount { get; set; }
    }
}
