﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum.MiAi;
using VT.FW.DB;

namespace Mall.Model.Entity.Miai
{
    /// <summary>
    /// 相亲会员基础资料
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_MiAi_BaseInfo
    {
        /// <summary>
        /// 编号
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 会员id
        /// </summary>
        public int UserId { get; set; }


        /// <summary>
        /// 性别1-男，2-女
        /// </summary>
        public int Sex { get; set; }

        /// <summary>
        /// 生日
        /// </summary>
        public string Birthday { get; set; }

        /// <summary>
        /// 体重
        /// </summary>
        public decimal Weight { get; set; }


        /// <summary>
        /// 身高
        /// </summary>
        public decimal Height { get; set; }


        /// <summary>
        /// 学历
        /// </summary>
        public EducationTypeEnum? EducationType { get; set; }

        /// <summary>
        /// 婚姻
        /// </summary>
        public MarriageEnum? Marriage { get; set; }


        /// <summary>
        /// 名称
        /// </summary>
        public string RealName { get; set; }

        /// <summary>
        /// 身份证号
        /// </summary>
        public string IDCardNo { get; set; }

        /// <summary>
        /// 身份证号
        /// </summary>
        public string IDCard { get; set; }

        /// <summary>
        /// 身份证反面
        /// </summary>
        public string IDCardBack { get; set; }


        /// <summary>
        /// 户口
        /// </summary>
        public string HuKou { get; set; }

        /// <summary>
        /// 籍贯
        /// </summary>
        public string NativePlace { get; set; }

        /// <summary>
        /// 房屋信息
        /// </summary>
        public string HouseInfo { get; set; }

        /// <summary>
        /// 学校信息
        /// </summary>
        public string SchoolInfo { get; set; }

        /// <summary>
        /// 年收入
        /// </summary>
        public string YearMoney { get; set; }

        /// <summary>
        /// 职务
        /// </summary>
        public string Job { get; set; }

        /// <summary>
        /// 其他兄弟姐妹
        /// </summary>
        public string OtherPople { get; set; }
        /// <summary>
        /// 专业
        /// </summary>
        public string MajorInfo { get; set; }

        /// <summary>
        /// 车辆信息
        /// </summary>
        public string CarInfo { get; set; }

        /// <summary>
        /// 父亲工作信息
        /// </summary>
        public string FatherInfo { get; set; }

        /// <summary>
        /// 母亲工作信息
        /// </summary>
        public string MotherInfo { get; set; }

        /// <summary>
        /// 关于
        /// </summary>
        public string About { get; set; }

        /// <summary>
        /// 理想爱情
        /// </summary>
        public string IdealLove { get; set; }


        /// <summary>
        /// 相册
        /// </summary>
        public string Album { get; set; }

        /// <summary>
        /// 浏览数
        /// </summary>
        public int BrowseNum { get; set; }


        /// <summary>
        /// 关注数
        /// </summary>
        public int FollowNum { get; set; }

        /// <summary>
        /// 商户号Id
        /// </summary>        
        public int? TenantId
        {
            get;
            set;
        }

        /// <summary>
        /// 小程序Id
        /// </summary>        
        public int? MallBaseId
        {
            get;
            set;
        }


        /// <summary>
        /// 创建时间
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }

        /// <summary>
        /// 删除状态
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
    }
}
