﻿using Mall.Model.Extend.TradePavilion;
using Mall.Repository.TradePavilion;
using System.Collections.Generic;
using System.Linq;
using VT.FW.DB;

namespace Mall.Module.TradePavilion
{
    /// <summary>
    /// 公司信息处理类
    /// </summary>
    public class CompanyModule
    {
        private readonly RB_CompanyRepository companyRepository = new RB_CompanyRepository();
        private readonly RB_CompanyBrandRepository brandRepository = new RB_CompanyBrandRepository();

        /// <summary>
        /// 获取公司信息分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Company_Extend> GetCompanyPageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Company_Extend query)
        {
            var list = companyRepository.GetCompanyPageListRepository(pageIndex, pageSize, out rowsCount, query);
            if (list != null && list.Any())
            {
                string carrierIds = string.Join(",", list.Select(x => x.CompanyId));
                if (!string.IsNullOrWhiteSpace(carrierIds))
                {
                    var metroList = brandRepository.GetBrandList(new RB_CompanyBrand_Extend { TenantId = query.TenantId, MallBaseId = query.MallBaseId, CompanyIds = carrierIds });
                    if (metroList != null && metroList.Any())
                    {
                        foreach (var item in list)
                        {
                            item.BrandModel = new RB_CompanyBrand_Extend();
                            item.BrandModel = metroList.Where(x => x.CompanyId == item.CompanyId).FirstOrDefault();
                            if (item.BrandModel != null && !string.IsNullOrWhiteSpace(item.BrandModel.CustomerType))
                            {
                                item.BrandModel.CustomerTypeInfo = new List<string>();
                                foreach (var itemCustomerType in item.BrandModel.CustomerType.Split(","))
                                {
                                    if (!string.IsNullOrWhiteSpace(itemCustomerType)&& itemCustomerType != "5")
                                    {
                                        item.BrandModel.CustomerTypeInfo.Add(Common.Plugin.EnumHelper.GetEnumName((Common.Enum.TradePavilion.CustomerTypeEnum)System.Convert.ToInt32(itemCustomerType)));
                                    }
                                    else if(!string.IsNullOrWhiteSpace(itemCustomerType))
                                    {
                                        item.BrandModel.CustomerTypeInfo.Add(item.BrandModel.CustomerOtherType);
                                    }
                                }
                            }
                        }
                    }
                }
            }

            return list;
        }


        /// <summary>
        /// 获取公司信息实体
        /// </summary>
        /// <param name="CompanyId"></param>
        /// <returns></returns>
        public RB_Company_Extend GetCompanyEntity(object CompanyId)
        {
            var model = companyRepository.GetEntity<RB_Company_Extend>(CompanyId);
           
            return model;
        }

        /// <summary>
        /// 获取公司信息实体
        /// </summary>
        /// <param name="CompanyId"></param>
        /// <returns></returns>
        public RB_Company_Extend GetCompanyModule(object CompanyId)
        {
            var model = companyRepository.GetEntity<RB_Company_Extend>(CompanyId);
            if (model != null && model.CompanyId > 0)
            {
                var metroList = brandRepository.GetBrandList(new RB_CompanyBrand_Extend { TenantId = model.TenantId, MallBaseId = model.MallBaseId, CompanyId = model.CompanyId });
                if (metroList != null && metroList.Any())
                {
                    model.BrandModel = new RB_CompanyBrand_Extend();
                    model.BrandModel = metroList.FirstOrDefault();
                    if (model.BrandModel != null && !string.IsNullOrWhiteSpace(model.BrandModel.CustomerType))
                    {
                        model.BrandModel.CustomerTypeInfo = new List<string>();
                        foreach (var itemCustomerType in model.BrandModel.CustomerType.Split(","))
                        {
                            if (itemCustomerType != "5")
                            {
                                model.BrandModel.CustomerTypeInfo.Add(Common.Plugin.EnumHelper.GetEnumName(itemCustomerType));
                            }
                            else
                            {
                                model.BrandModel.CustomerTypeInfo.Add(model.BrandModel.CustomerOtherType);
                            }
                        }
                    }

                }
            }
            return model;
        }

        /// <summary>
        /// 获取公司信息实体
        /// </summary>
        /// <param name="CompanyId"></param>
        /// <returns></returns>
        public RB_Company_Extend GetCompanyByUserIdModule(int userId)
        {
            var model =companyRepository.GetCompanyRepository(new RB_Company_Extend() { CreateBy = userId });
            if (model != null && model.CompanyId > 0)
            {
                var metroList = brandRepository.GetBrandList(new RB_CompanyBrand_Extend { TenantId = model.TenantId, MallBaseId = model.MallBaseId, CompanyId = model.CompanyId });
                if (metroList != null && metroList.Any())
                {
                    model.BrandModel = new RB_CompanyBrand_Extend();
                    model.BrandModel = metroList.FirstOrDefault();
                    if (model.BrandModel != null && !string.IsNullOrWhiteSpace(model.BrandModel.CustomerType))
                    {
                        model.BrandModel.CustomerTypeInfo = new List<string>();
                        foreach (var itemCustomerType in model.BrandModel.CustomerType.Split(","))
                        {
                            if (itemCustomerType != "5")
                            {
                                model.BrandModel.CustomerTypeInfo.Add(Common.Plugin.EnumHelper.GetEnumName(itemCustomerType));
                            }
                            else
                            {
                                model.BrandModel.CustomerTypeInfo.Add(model.BrandModel.CustomerOtherType);
                            }
                        }
                    }
                }
            }
            return model;
        }

        /// <summary>
        /// 新增修改公司信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int SetCompanyModule(RB_Company_Extend model)
        {
            int ID = 0;
            if (model.CompanyId > 0)
            {
                ID = model.CompanyId;
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Company_Extend.CompanyName),model.CompanyName },
                    {nameof(RB_Company_Extend.Principal),model.Principal },
                    {nameof(RB_Company_Extend.Mobile),model.Mobile },
                    {nameof(RB_Company_Extend.BusinessLicense),model.BusinessLicense },
                    {nameof(RB_Company_Extend.LegalPerson),model.LegalPerson },
                    {nameof(RB_Company_Extend.UnifiedCode),model.UnifiedCode },
                    {nameof(RB_Company_Extend.CompanyIntro),model.CompanyIntro },
                    {nameof(RB_Company_Extend.CompanyStatus),model.CompanyStatus },
                    {nameof(RB_Company_Extend.UpdateBy),model.UpdateBy },
                    {nameof(RB_Company_Extend.UpdateDate),model.UpdateDate },
                };
                companyRepository.Update(fileds, new WhereHelper(nameof(RB_Company_Extend.CompanyId), model.CompanyId));
            }
            else
            {
                var newId = companyRepository.Insert(model);
                model.CompanyId = newId;
                ID = newId;
            }
            return ID;
        }

        /// <summary>
        /// 更新公司信息状态
        /// </summary>
        /// <param name="CompanyId"></param>
        /// <param name="Status"></param>
        /// <returns></returns>
        public bool RemoveCompanyModule(int CompanyId, int Status)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Company_Extend.Status),Status },
            };
            bool flag = companyRepository.Update(fileds, new WhereHelper(nameof(RB_Company_Extend.CompanyId), CompanyId));
            return flag;
        }

        /// <summary>
        /// 更新公司审核状态
        /// </summary>
        /// <param name="CompanyId"></param>
        /// <param name="Status"></param>
        /// <returns></returns>
        public bool UpdateCompanyStatus(int CompanyId, int Status)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Company_Extend.CompanyStatus),Status },
            };
            bool flag = companyRepository.Update(fileds, new WhereHelper(nameof(RB_Company_Extend.CompanyId), CompanyId));
            return flag;
        }
    }
}
