﻿using Mall.Common.Enum.MallBase;
using Mall.Model.Entity.BaseSetUp;
using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Extend.BaseSetUp;
using Mall.Model.Extend.MarketingCenter;
using Mall.Model.Extend.Product;
using Mall.Model.Extend.User;
using Mall.Module.BaseSetUp;
using Mall.Module.MarketingCenter;
using Mall.Module.Product;
using Mall.Module.Reserve;
using Mall.Module.User;
using Mall.Repository.Product;
using Mall.Repository.User;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Mall.WebApi.Controllers
{
    /// <summary>
    /// 小程序首页帮助类
    /// </summary>
    public class MallHelper
    {
        /// <summary>
        /// 产品处理类
        /// </summary>
        private static ProductModule productModule = new ProductModule();

        /// <summary>
        /// 导航图标处理类
        /// </summary>
        private static MiniProgramNaviconModule programNaviconModule = new MiniProgramNaviconModule();

        /// <summary>
        /// 内容管理
        /// </summary>
        private static ContentModule contentModule = new ContentModule();

        /// <summary>
        /// 商户小程序处理类
        /// </summary>
        private static Module.User.MiniProgramModule programModule = new Module.User.MiniProgramModule();

        /// <summary>
        /// 小程序基础配置
        /// </summary>
        private static MallBaseModule mallBaseModule = new MallBaseModule();

        /// <summary>
        /// 用户积分
        /// </summary>
        private static IntegralModule integralModule = new IntegralModule();

        /// <summary>
        /// 充值设置
        /// </summary>
        private static RechargeModule rechargeModule = new RechargeModule();

        /// <summary>
        /// 用户处理类
        /// </summary>
        private static UserModule userModule = new UserModule();

        /// <summary>
        /// 微店
        /// </summary>
        private static RB_SmallShops_InfoRepository smallShops_InfoRepository = new RB_SmallShops_InfoRepository();
        /// <summary>
        /// 微店商品价格
        /// </summary>
        private static RB_SmallShops_PriceRepository smallShops_PriceRepository = new RB_SmallShops_PriceRepository();
        /// <summary>
        /// 商品规格价格
        /// </summary>
        private static RB_Goods_SpecificationPriceRepository goods_SpecificationPriceRepository = new RB_Goods_SpecificationPriceRepository();

        /// <summary>
        /// 产品处理类
        /// </summary>
        private static Module.Education.EducationModule educationModule = new Module.Education.EducationModule();

        /// <summary>
        /// 线下服务配置处理类
        /// </summary>
        private static ReserveModule reserveModule = new ReserveModule();


        /// <summary>
        /// 模板处理类
        /// </summary>
        private static MiniprogramTemplateModule miniprogramTemplateModule = new MiniprogramTemplateModule();
        /// <summary>
        /// 模板处理类
        /// </summary>
        private static Module.Miai.MiaiModule miaiModule = new Module.Miai.MiaiModule();


        private static Module.TradePavilion.CommerceActivityModule commerceActivityModule = new Module.TradePavilion.CommerceActivityModule();

        /// <summary>
        /// 解析插件数据为对象
        /// </summary>
        /// <param name="item"></param>
        /// <returns></returns>
        public static object PlusDataToObject(ComponentItem subItem, int TenantId, int MallBaseId, int SmallShopsId, int IsOpenSchool, int StoreId,  int UserId = 0)
        {
            var obj = new object();
            switch (subItem.Id)
            {
                //背景插件
                case "background":
                    var backgroundData = subItem.data as backgroundItem;
                    if (backgroundData != null && !string.IsNullOrWhiteSpace(backgroundData.backgroundPicUrl))
                    {
                        backgroundData.backgroundPicUrl = Common.Config.GetFileUrl(backgroundData.backgroundPicUrl);
                    }
                    obj = new
                    {
                        id = subItem.Id,
                        data = backgroundData
                    };
                    break;
                //搜索插件
                case "search":
                    var searchData = subItem.data as searchItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = searchData
                    };
                    break;
                //导航组件
                case "nav":
                    var navData = subItem.data as navItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = navData
                    };
                    break;
                case "nav-page":
                    var navPageData = subItem.data as navPageItem;
                    if (navPageData != null && navPageData.navs != null && navPageData.navs.Count > 0)
                    {
                        var subList = navPageData.navs.Where(qitem => qitem.ShowType == 1)?.ToList() ?? new List<navPageIconItem>();
                        if (subList != null && subList.Count > 0)
                        {
                            string tempIds = string.Join(",", subList.Select(qitem => qitem.TemplateId));
                            List<RB_Miniprogram_Template_Extend> tempList = new List<RB_Miniprogram_Template_Extend>();
                            if (!string.IsNullOrEmpty(tempIds))
                            {
                                tempList = miniprogramTemplateModule.GetMiniprogramTemplateListModule(new RB_Miniprogram_Template_Extend() { QIds = tempIds }, TenantId, MallBaseId, UserId, IsAnalyzePlus: true);
                            }
                            foreach (var item in navPageData.navs)
                            {
                                if (item.ShowType == 1)
                                {
                                    var tempModel = tempList?.Where(qitem => qitem.Id == item.TemplateId)?.FirstOrDefault();
                                    if (tempModel != null && tempModel.Id > 0)
                                    {
                                        item.TemplateData = tempModel.ComponentDataList;
                                    }
                                }
                            }
                        }
                    }
                    obj = new
                    {
                        id = subItem.Id,
                        data = navPageData
                    };
                    break;
                //轮播广告插件
                case "banner":
                    var bannerData = subItem.data as bannerItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = bannerData
                    };
                    break;
                //公告组件
                case "notice":
                    var noticeData = subItem.data as noticeItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = noticeData
                    };
                    break;
                //专题组件
                case "topic":
                    var topicData = subItem.data as topicItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = topicData
                    };
                    break;
                //标题组件
                case "link":
                    var linkData = subItem.data as linkItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = linkData
                    };
                    break;
                //图片广告插件
                case "rubik":
                    var rubikData = subItem.data as rubikItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = rubikData
                    };
                    break;
                //视频插件
                case "video":
                    var videoData = subItem.data as videoItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = videoData
                    };
                    break;
                //商品插件
                case "goods":
                    var goodsData = subItem.data as goodsItem;
                    if (goodsData != null)
                    {
                        //显示商品分类
                        if (goodsData.showCat)
                        {
                            if (goodsData.catList != null && goodsData.catList.Count > 0)
                            {
                                foreach (var childItem in goodsData.catList)
                                {
                                    //自定义商品
                                    if (childItem.staticGoods)
                                    {
                                        if (childItem.goodsList != null && childItem.goodsList.Count > 0)
                                        {
                                            var Ids = "0," + string.Join(",", childItem.goodsList.Select(qitem => qitem.id));
                                            var tempGoodsList = productModule.GetProductGoodsList(new Model.Extend.Product.RB_Goods_Extend()
                                            {
                                                TenantId = TenantId,
                                                MallBaseId = MallBaseId,
                                                GoodsIds = Ids,
                                                GoodsStatus = 1,
                                                GoodsClassify = 1,//查询非司导
                                                GoodsPageType = IsOpenSchool == 1 ? Common.Enum.Goods.GoodsPageTypeEnum.School : Common.Enum.Goods.GoodsPageTypeEnum.Mall
                                            }, SmallShopsId: SmallShopsId);

                                            List<GoodsDetailsItem2> newGoodsList = new List<GoodsDetailsItem2>();
                                            foreach (var goodItem in childItem.goodsList)
                                            {
                                                var lastItem = new GoodsDetailsItem2();
                                                var tempGood = tempGoodsList?.Where(qitem => qitem.Id == goodItem.id)?.FirstOrDefault();
                                                if (tempGood != null && tempGood.Id > 0)
                                                {
                                                    lastItem.id = tempGood.Id;
                                                    lastItem.name = tempGood.Name;
                                                    lastItem.price = Math.Round((tempGood?.SellingPrice ?? 0), 2);
                                                    lastItem.picUrl = tempGood?.CoverImage != null ? Common.Config.GetFileUrl(tempGood.CoverImage) : "";
                                                    lastItem.OriginalPrice = Math.Round((tempGood?.OriginalPrice ?? 0), 2);
                                                    lastItem.courseScore = (tempGood.CourseScore ?? 0);
                                                    newGoodsList.Add(lastItem);
                                                }
                                            }
                                            childItem.goodsList = newGoodsList;
                                        }
                                    }
                                    //自动添加商品
                                    else
                                    {
                                        childItem.goodsList = new List<GoodsDetailsItem2>();
                                        var catGoodsList = productModule.GetProductGoodsPageList_V2(1, childItem.goodsNum, out long rowsCount, new Model.Extend.Product.RB_Goods_Extend()
                                        {
                                            TenantId = TenantId,
                                            MallBaseId = MallBaseId,
                                            CategoryIds = childItem.id.ToString(),
                                            GoodsStatus = 1,
                                            GoodsClassify = 1,//查询非司导
                                            GoodsPageType = IsOpenSchool == 1 ? Common.Enum.Goods.GoodsPageTypeEnum.School : Common.Enum.Goods.GoodsPageTypeEnum.Mall
                                        }, SmallShopsId: SmallShopsId);
                                        if (catGoodsList != null && catGoodsList.Count > 0)
                                        {
                                            foreach (var gItem in catGoodsList)
                                            {
                                                childItem.goodsList.Add(new GoodsDetailsItem2()
                                                {
                                                    id = gItem.Id,
                                                    price = Math.Round((gItem?.SellingPrice ?? 0), 2),
                                                    name = gItem.Name,
                                                    picUrl = Common.Config.GetFileUrl(gItem.CoverImage),
                                                    OriginalPrice = Math.Round((gItem?.OriginalPrice ?? 0), 2),
                                                    courseScore = gItem.CourseScore ?? 0
                                                });
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        //不显示商品分类
                        else
                        {
                            //自动添加商品
                            if (goodsData.addGoodsType == 0)
                            {
                                goodsData.list = new List<GoodsDetailsItem2>();
                                var goodsList = productModule.GetProductGoodsPageList_V2(1, goodsData.goodsLength, out long rowsCount, new Model.Extend.Product.RB_Goods_Extend()
                                {
                                    TenantId = TenantId,
                                    MallBaseId = MallBaseId,
                                    GoodsStatus = 1,
                                    GoodsClassify = 1,//查询非司导
                                    GoodsPageType = IsOpenSchool == 1 ? Common.Enum.Goods.GoodsPageTypeEnum.School : Common.Enum.Goods.GoodsPageTypeEnum.Mall
                                });
                                #region 微店价格
                                RB_SmallShops_Info_Extend smallModel = new RB_SmallShops_Info_Extend();
                                List<RB_SmallShops_Price_Extend> smallPList = new List<RB_SmallShops_Price_Extend>();
                                if (SmallShopsId > 0 && goodsList.Any())
                                {
                                    string goodsId = string.Join(",", goodsList.Select(x => x.Id));
                                    smallModel = smallShops_InfoRepository.GetEntity<RB_SmallShops_Info_Extend>(SmallShopsId);
                                    smallPList = smallShops_PriceRepository.GetList(new RB_SmallShops_Price_Extend() { SmallShopsId = SmallShopsId, GoodsIds = goodsId });
                                    var spriceList = goods_SpecificationPriceRepository.GetList(new RB_Goods_SpecificationPrice_Extend() { GoodsIds = goodsId });
                                    foreach (var item in goodsList)
                                    {
                                        if ((smallModel.UpPrice ?? 0) > 0 || smallPList.Where(x => x.GoodsId == item.Id && x.UpPrice > 0).Any())
                                        {
                                            var spList = spriceList.Where(x => x.GoodsId == item.Id).ToList();
                                            if (spList.Any())
                                            {
                                                foreach (var qitem in spList)
                                                {
                                                    var sspModel = smallPList.Where(x => x.GoodsId == item.Id && x.SpecificationKey == qitem.SpecificationSort).FirstOrDefault();
                                                    if (sspModel != null)
                                                    {
                                                        //单商品设置的
                                                        if (sspModel.PriceType == 1)
                                                        {
                                                            qitem.SellingPrice = (qitem.SellingPrice ?? 0) + Math.Ceiling((qitem.SellingPrice ?? 0) * (sspModel.UpPrice ?? 0) / 100);
                                                        }
                                                        else if (sspModel.PriceType == 2)
                                                        {
                                                            qitem.SellingPrice = (qitem.SellingPrice ?? 0) + (sspModel.UpPrice ?? 0);
                                                        }
                                                    }
                                                    else
                                                    {
                                                        if ((smallModel.UpPrice ?? 0) > 0)
                                                        {
                                                            if (smallModel.PriceType == 1)
                                                            {
                                                                qitem.SellingPrice = (qitem.SellingPrice ?? 0) + Math.Ceiling((qitem.SellingPrice ?? 0) * (smallModel.UpPrice ?? 0) / 100);
                                                            }
                                                            else if (smallModel.PriceType == 2)
                                                            {
                                                                qitem.SellingPrice = (qitem.SellingPrice ?? 0) + (smallModel.UpPrice ?? 0);
                                                            }
                                                        }
                                                    }
                                                }
                                                item.SellingPrice = spList.Min(x => x.SellingPrice ?? 0);
                                                decimal MaxPrice = spList.Max(x => x.SellingPrice ?? 0);
                                                MaxPrice += Math.Ceiling(MaxPrice / 10);
                                                if (MaxPrice > item.OriginalPrice)
                                                {
                                                    item.OriginalPrice = MaxPrice;
                                                }
                                            }
                                            else
                                            {
                                                var sspModel = smallPList.Where(x => x.GoodsId == item.Id && x.SpecificationKey == "").FirstOrDefault();
                                                if (sspModel != null)
                                                {
                                                    //单商品设置的
                                                    if (sspModel.PriceType == 1)
                                                    {
                                                        item.SellingPrice = (item.SellingPrice ?? 0) + Math.Ceiling((item.SellingPrice ?? 0) * (sspModel.UpPrice ?? 0) / 100);
                                                        item.OriginalPrice = (item.OriginalPrice ?? 0) + Math.Ceiling((item.OriginalPrice ?? 0) * (sspModel.UpPrice ?? 0) / 100);
                                                    }
                                                    else if (sspModel.PriceType == 2)
                                                    {
                                                        item.SellingPrice = (item.SellingPrice ?? 0) + (sspModel.UpPrice ?? 0);
                                                        item.OriginalPrice = (item.OriginalPrice ?? 0) + (sspModel.UpPrice ?? 0);
                                                    }
                                                }
                                                else
                                                {
                                                    if ((smallModel.UpPrice ?? 0) > 0)
                                                    {
                                                        if (smallModel.PriceType == 1)
                                                        {
                                                            item.SellingPrice = (item.SellingPrice ?? 0) + Math.Ceiling((item.SellingPrice ?? 0) * (smallModel.UpPrice ?? 0) / 100);
                                                            item.OriginalPrice = (item.OriginalPrice ?? 0) + Math.Ceiling((item.OriginalPrice ?? 0) * (smallModel.UpPrice ?? 0) / 100);
                                                        }
                                                        else if (smallModel.PriceType == 2)
                                                        {
                                                            item.SellingPrice = (item.SellingPrice ?? 0) + (smallModel.UpPrice ?? 0);
                                                            item.OriginalPrice = (item.OriginalPrice ?? 0) + (smallModel.UpPrice ?? 0);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                #endregion
                                if (goodsList != null && goodsList.Count > 0)
                                {
                                    foreach (var gItem in goodsList)
                                    {
                                        goodsData.list.Add(new GoodsDetailsItem2()
                                        {
                                            id = gItem.Id,
                                            price = Math.Round((gItem?.SellingPrice ?? 0), 2),
                                            name = gItem.Name,
                                            picUrl = Common.Config.GetFileUrl(gItem.CoverImage),
                                            OriginalPrice = Math.Round((gItem?.OriginalPrice ?? 0), 2),
                                            courseScore = gItem.CourseScore ?? 0
                                        });
                                    }
                                }
                            }
                            //手动添加商品
                            else
                            {
                                if (goodsData.list != null && goodsData.list.Count > 0)
                                {
                                    var Ids = "0," + string.Join(",", goodsData.list.Select(qitem => qitem.id));
                                    var tempGoodsList = productModule.GetProductGoodsList(new Model.Extend.Product.RB_Goods_Extend()
                                    {
                                        TenantId = TenantId,
                                        MallBaseId = MallBaseId,
                                        GoodsIds = Ids,
                                        GoodsStatus = 1,
                                        GoodsClassify = 1,//查询非司导
                                        GoodsPageType = IsOpenSchool == 1 ? Common.Enum.Goods.GoodsPageTypeEnum.School : Common.Enum.Goods.GoodsPageTypeEnum.Mall
                                    });
                                    #region 微店价格
                                    RB_SmallShops_Info_Extend smallModel = new RB_SmallShops_Info_Extend();
                                    List<RB_SmallShops_Price_Extend> smallPList = new List<RB_SmallShops_Price_Extend>();
                                    if (SmallShopsId > 0 && tempGoodsList.Any())
                                    {
                                        string goodsId = string.Join(",", tempGoodsList.Select(x => x.Id));
                                        smallModel = smallShops_InfoRepository.GetEntity<RB_SmallShops_Info_Extend>(SmallShopsId);
                                        smallPList = smallShops_PriceRepository.GetList(new RB_SmallShops_Price_Extend() { SmallShopsId = SmallShopsId, GoodsIds = goodsId });
                                        var spriceList = goods_SpecificationPriceRepository.GetList(new RB_Goods_SpecificationPrice_Extend() { GoodsIds = goodsId });
                                        foreach (var item in tempGoodsList)
                                        {
                                            if ((smallModel.UpPrice ?? 0) > 0 || smallPList.Where(x => x.GoodsId == item.Id && x.UpPrice > 0).Any())
                                            {
                                                var spList = spriceList.Where(x => x.GoodsId == item.Id).ToList();
                                                if (spList.Any())
                                                {
                                                    foreach (var qitem in spList)
                                                    {
                                                        var sspModel = smallPList.Where(x => x.GoodsId == item.Id && x.SpecificationKey == qitem.SpecificationSort).FirstOrDefault();
                                                        if (sspModel != null)
                                                        {
                                                            //单商品设置的
                                                            if (sspModel.PriceType == 1)
                                                            {
                                                                qitem.SellingPrice = (qitem.SellingPrice ?? 0) + Math.Ceiling((qitem.SellingPrice ?? 0) * (sspModel.UpPrice ?? 0) / 100);
                                                            }
                                                            else if (sspModel.PriceType == 2)
                                                            {
                                                                qitem.SellingPrice = (qitem.SellingPrice ?? 0) + (sspModel.UpPrice ?? 0);
                                                            }
                                                        }
                                                        else
                                                        {
                                                            if ((smallModel.UpPrice ?? 0) > 0)
                                                            {
                                                                if (smallModel.PriceType == 1)
                                                                {
                                                                    qitem.SellingPrice = (qitem.SellingPrice ?? 0) + Math.Ceiling((qitem.SellingPrice ?? 0) * (smallModel.UpPrice ?? 0) / 100);
                                                                }
                                                                else if (smallModel.PriceType == 2)
                                                                {
                                                                    qitem.SellingPrice = (qitem.SellingPrice ?? 0) + (smallModel.UpPrice ?? 0);
                                                                }
                                                            }
                                                        }
                                                    }
                                                    item.SellingPrice = spList.Min(x => x.SellingPrice ?? 0);
                                                    decimal MaxPrice = spList.Max(x => x.SellingPrice ?? 0);
                                                    MaxPrice += Math.Ceiling(MaxPrice / 10);
                                                    if (MaxPrice > item.OriginalPrice)
                                                    {
                                                        item.OriginalPrice = MaxPrice;
                                                    }
                                                }
                                                else
                                                {
                                                    var sspModel = smallPList.Where(x => x.GoodsId == item.Id && x.SpecificationKey == "").FirstOrDefault();
                                                    if (sspModel != null)
                                                    {
                                                        //单商品设置的
                                                        if (sspModel.PriceType == 1)
                                                        {
                                                            item.SellingPrice = (item.SellingPrice ?? 0) + Math.Ceiling((item.SellingPrice ?? 0) * (sspModel.UpPrice ?? 0) / 100);
                                                            item.OriginalPrice = (item.OriginalPrice ?? 0) + Math.Ceiling((item.OriginalPrice ?? 0) * (sspModel.UpPrice ?? 0) / 100);
                                                        }
                                                        else if (sspModel.PriceType == 2)
                                                        {
                                                            item.SellingPrice = (item.SellingPrice ?? 0) + (sspModel.UpPrice ?? 0);
                                                            item.OriginalPrice = (item.OriginalPrice ?? 0) + (sspModel.UpPrice ?? 0);
                                                        }
                                                    }
                                                    else
                                                    {
                                                        if ((smallModel.UpPrice ?? 0) > 0)
                                                        {
                                                            if (smallModel.PriceType == 1)
                                                            {
                                                                item.SellingPrice = (item.SellingPrice ?? 0) + Math.Ceiling((item.SellingPrice ?? 0) * (smallModel.UpPrice ?? 0) / 100);
                                                                item.OriginalPrice = (item.OriginalPrice ?? 0) + Math.Ceiling((item.OriginalPrice ?? 0) * (smallModel.UpPrice ?? 0) / 100);
                                                            }
                                                            else if (smallModel.PriceType == 2)
                                                            {
                                                                item.SellingPrice = (item.SellingPrice ?? 0) + (smallModel.UpPrice ?? 0);
                                                                item.OriginalPrice = (item.OriginalPrice ?? 0) + (smallModel.UpPrice ?? 0);
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    #endregion
                                    List<GoodsDetailsItem2> newGoodsList = new List<GoodsDetailsItem2>();
                                    foreach (var goodItem in goodsData.list)
                                    {
                                        var childItem = new GoodsDetailsItem2();
                                        var tempGood = tempGoodsList?.Where(qitem => qitem.Id == goodItem.id)?.FirstOrDefault();
                                        if (tempGood != null && tempGood.Id > 0)
                                        {
                                            childItem.id = tempGood.Id;
                                            childItem.name = tempGood?.Name ?? "";
                                            childItem.price = Math.Round((tempGood?.SellingPrice ?? 0), 2);
                                            childItem.picUrl = tempGood?.CoverImage != null ? Common.Config.GetFileUrl(tempGood.CoverImage) : "";
                                            childItem.OriginalPrice = Math.Round((tempGood?.OriginalPrice ?? 0), 2);
                                            childItem.courseScore = (tempGood.CourseScore ?? 0);
                                            newGoodsList.Add(childItem);
                                        }
                                    }
                                    goodsData.list = newGoodsList;
                                }
                            }
                        }
                    }
                    obj = new
                    {
                        id = subItem.Id,
                        data = goodsData
                    };
                    break;
                //门店插件
                case "store":
                    var storeData = subItem.data as storeItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = storeData
                    };
                    break;
                //版权插件
                case "copyright":
                    var copyrightData = subItem.data as copyrightItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = copyrightData
                    };
                    break;
                //签到插件
                case "check-in":
                    var checkinData = subItem.data as checkinItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = checkinData
                    };
                    break;
                //用户信息插件
                case "user-info":
                    var userinfoData = subItem.data as userinfoItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = userinfoData
                    };
                    break;
                //用户订单插件
                case "user-order":
                    var userorderData = subItem.data as userorderItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = userorderData
                    };
                    break;
                //地图插件
                case "map":
                    var mapData = subItem.data as mapItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = mapData
                    };
                    break;
                //微信公众号插件
                case "mp-link":
                    var mplinkData = subItem.data as mplinkItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = mplinkData
                    };
                    break;
                //图文插件
                case "image-text":
                    var imagetextData = subItem.data as imagetextItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = imagetextData
                    };
                    break;
                //优惠券插件
                case "coupon":
                    var couponData = subItem.data as couponItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = couponData
                    };
                    break;
                //倒计时插件
                case "timer":
                    var timerData = subItem.data as timerItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = timerData
                    };
                    break;
                //拼团插件
                case "pintuan":
                    var pintuanData = subItem.data as pintuanItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = pintuanData
                    };
                    break;
                //预约插件
                case "booking":
                    var bookingData = subItem.data as bookingItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = bookingData
                    };
                    break;
                //砍价插件
                case "bargain":
                    var bargainData = subItem.data as bargainItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = bargainData
                    };
                    break;
                //积分商城插件
                case "integral-mall":
                    var integralmallData = subItem.data as integralmallItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = integralmallData
                    };
                    break;
                //抽奖插件
                case "lottery":
                    var lotteryData = subItem.data as lotteryItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = lotteryData
                    };
                    break;

                //预售
                case "advance":
                    var advanceData = subItem.data as advanceItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = advanceData
                    };
                    break;

                //超级会员卡
                case "vip-card":
                    var vipcardData = subItem.data as vipcardItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = vipcardData
                    };
                    break;
                //直播组件
                case "live":
                    var liveData = subItem.data as liveItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = liveData
                    };
                    break;


                //空组件
                case "empty":
                    var emptyData = subItem.data as emptyItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = emptyData
                    };
                    break;

                //流量主广告
                case "ad":
                    var adData = subItem.data as adItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = adData
                    };
                    break;

                //弹窗广告
                case "modal":
                    var modalData = subItem.data as modalItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = modalData
                    };
                    break;

                //弹窗广告
                case "quick-nav":
                    var quicknavData = subItem.data as quicknavItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = quicknavData
                    };
                    break;
                //店铺信息
                case "shop-info":
                    var shopInfo = subItem.data as shopinfoItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = shopInfo
                    };
                    break;
                //司导插件
                case "drive-guide":
                    var driveInfo = subItem.data as driveGuideItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = driveInfo
                    };
                    break;
                //教育模块-最近学习组件
                case "education":
                    var educationInfo = subItem.data as educationItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = educationInfo
                    };
                    break;
                //教育模块-自定义列表
                case "educationCustom":
                    var educationCustomerInfo = subItem.data as educationCustomItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = educationCustomerInfo
                    };
                    break;
                //教育模块-资讯列表
                case "educationArticle":
                    var educationArticleInfo = subItem.data as educationArticleItem;

                    if (educationArticleInfo != null)
                    {
                        //自定义商品
                        if (educationArticleInfo.addGoodsType == 0)
                        {
                            if (educationArticleInfo.list != null && educationArticleInfo.list.Count > 0)
                            {
                                var Ids = "0," + string.Join(",", educationArticleInfo.list.Select(qitem => qitem.id));
                                var tempGoodsList = educationModule.GetArticleList(new Model.Extend.Education.RB_Education_Article_Extend()
                                {
                                    TenantId = TenantId,
                                    MallBaseId = MallBaseId,
                                    Ids = Ids,
                                    ArticleStatus = 1
                                });
                                List<CustomDetailsItem2> newGoodsList = new List<CustomDetailsItem2>();
                                foreach (var goodItem in educationArticleInfo.list)
                                {
                                    var lastItem = new CustomDetailsItem2();
                                    var tempGood = tempGoodsList?.Where(qitem => qitem.ID == goodItem.id)?.FirstOrDefault();
                                    if (tempGood != null && tempGood.ID > 0)
                                    {
                                        lastItem.id = tempGood.ID;
                                        lastItem.name = tempGood.Name;
                                        lastItem.lableName = tempGood.LableName;
                                        lastItem.picUrl = tempGood.ArticlePic;
                                        if (!string.IsNullOrWhiteSpace(lastItem.lableName))
                                        {
                                            lastItem.lableNameList = JsonConvert.DeserializeObject<List<string>>(lastItem.lableName);
                                        }
                                        newGoodsList.Add(lastItem);
                                    }
                                }
                                educationArticleInfo.list = newGoodsList;
                            }
                        }
                        //自动添加商品
                        else
                        {
                            educationArticleInfo.list = new List<CustomDetailsItem2>();
                            var articleList = educationModule.GetArticlePageListRepository(1, educationArticleInfo.goodsLength, out long rowsCount, new Model.Extend.Education.RB_Education_Article_Extend()
                            {
                                TenantId = TenantId,
                                MallBaseId = MallBaseId,
                                ArticleStatus = 1,
                                OrderBy = 1
                            });
                            if (articleList != null && articleList.Count > 0)
                            {
                                foreach (var gItem in articleList)
                                {
                                    educationArticleInfo.list.Add(new CustomDetailsItem2()
                                    {
                                        id = gItem.ID,
                                        name = gItem.Name,
                                        lableName = gItem.LableName,
                                        picUrl = gItem.ArticlePic,
                                        lableNameList = string.IsNullOrWhiteSpace(gItem.LableName) ? new List<string>() : JsonConvert.DeserializeObject<List<string>>(gItem.LableName)
                                    }); ;

                                }
                            }
                        }
                    }
                    obj = new
                    {
                        id = subItem.Id,
                        data = educationArticleInfo
                    };
                    break;
                //教育模块-老师列表
                case "educationteacher":
                    var educationTeacherInfo = subItem.data as educationTeacherItem;

                    if (educationTeacherInfo != null)
                    {
                        //自定义商品

                        if (educationTeacherInfo.TeacherList != null && educationTeacherInfo.TeacherList.Count > 0)
                        {
                            var Ids = "0," + string.Join(",", educationTeacherInfo.TeacherList.Select(qitem => qitem.id));
                            var tempGoodsList = educationModule.GetTeacherList(new Model.Extend.Education.RB_Education_Teacher_Extend()
                            {
                                TenantId = TenantId,
                                MallBaseId = MallBaseId,
                                Ids = Ids,
                                TeacherStatus = 1
                            });
                            List<TeacherDetailsItem> newTeacherList = new List<TeacherDetailsItem>();
                            foreach (var goodItem in educationTeacherInfo.TeacherList)
                            {
                                var lastItem = new TeacherDetailsItem();
                                var tempGood = tempGoodsList?.Where(qitem => qitem.ID == goodItem.id)?.FirstOrDefault();
                                if (tempGood != null && tempGood.ID > 0)
                                {
                                    lastItem.id = tempGood.ID;
                                    lastItem.name = tempGood.Name;
                                    lastItem.lableName = tempGood.LableName;
                                    lastItem.picUrl = tempGood.TeacherLogo;
                                    lastItem.nationality = tempGood.Nationality;
                                    lastItem.foreignersUrl = tempGood.ForeignersUrl;
                                    if (!string.IsNullOrWhiteSpace(lastItem.lableName))
                                    {
                                        lastItem.lableNameList = JsonConvert.DeserializeObject<List<string>>(lastItem.lableName);
                                    }
                                    newTeacherList.Add(lastItem);
                                }
                            }
                            educationTeacherInfo.TeacherList = newTeacherList;
                        }
                    }
                    obj = new
                    {
                        id = subItem.Id,
                        data = educationTeacherInfo
                    };
                    break;
                //商品插件
                case "storeGoods":
                    var storeGoodsData = subItem.data as StoreGoodsItem;
                    if (storeGoodsData != null)
                    {
                        //显示商品分类
                        if (storeGoodsData.showCat)
                        {
                            if (storeGoodsData.catList != null && storeGoodsData.catList.Count > 0)
                            {
                                foreach (var childItem in storeGoodsData.catList)
                                {
                                    //自定义商品
                                    if (childItem.staticGoods)
                                    {
                                        if (childItem.goodsList != null && childItem.goodsList.Count > 0)
                                        {
                                            var Ids = "0," + string.Join(",", childItem.goodsList.Select(qitem => qitem.id));
                                            var tempGoodsList = productModule.GetProductGoodsList(new Model.Extend.Product.RB_Goods_Extend()
                                            {
                                                TenantId = TenantId,
                                                MallBaseId = MallBaseId,
                                                GoodsIds = Ids,
                                                GoodsStatus = 1,
                                                GoodsClassify = 3,//查询非司导
                                                StoresIds = StoreId.ToString()
                                                // GoodsPageType = IsOpenSchool == 1 ? Common.Enum.Goods.GoodsPageTypeEnum.School : Common.Enum.Goods.GoodsPageTypeEnum.Mall
                                            }, SmallShopsId: SmallShopsId);

                                            List<StoreGoodsDetailsItem2> newGoodsList = new List<StoreGoodsDetailsItem2>();
                                            foreach (var goodItem in childItem.goodsList)
                                            {
                                                var lastItem = new StoreGoodsDetailsItem2();
                                                var tempGood = tempGoodsList?.Where(qitem => qitem.Id == goodItem.id)?.FirstOrDefault();
                                                if (tempGood != null && tempGood.Id > 0)
                                                {
                                                    lastItem.id = tempGood.Id;
                                                    lastItem.name = tempGood.Name;
                                                    lastItem.price = Math.Round((tempGood?.SellingPrice ?? 0), 2);
                                                    lastItem.picUrl = tempGood?.CoverImage != null ? Common.Config.GetFileUrl(tempGood.CoverImage) : "";
                                                    lastItem.OriginalPrice = Math.Round((tempGood?.OriginalPrice ?? 0), 2);
                                                    lastItem.courseScore = (tempGood.CourseScore ?? 0);
                                                    lastItem.IsChooseServicePerson = tempGood.IsChooseServicePerson;
                                                    lastItem.DepositMoney = Math.Round((tempGood?.DepositMoney ?? 0), 2);
                                                    newGoodsList.Add(lastItem);
                                                }
                                            }
                                            childItem.goodsList = newGoodsList;
                                        }
                                    }
                                    //自动添加商品
                                    else
                                    {
                                        childItem.goodsList = new List<StoreGoodsDetailsItem2>();
                                        var catGoodsList = productModule.GetProductGoodsPageList_V2(1, childItem.goodsNum, out long rowsCount, new Model.Extend.Product.RB_Goods_Extend()
                                        {
                                            TenantId = TenantId,
                                            MallBaseId = MallBaseId,
                                            CategoryIds = childItem.id.ToString(),
                                            GoodsStatus = 1,
                                            GoodsClassify = 3,//查询非司导
                                            StoresIds = StoreId.ToString()
                                            // GoodsPageType = IsOpenSchool == 1 ? Common.Enum.Goods.GoodsPageTypeEnum.School : Common.Enum.Goods.GoodsPageTypeEnum.Mall
                                        }, SmallShopsId: SmallShopsId);
                                        if (catGoodsList != null && catGoodsList.Count > 0)
                                        {
                                            foreach (var gItem in catGoodsList)
                                            {
                                                childItem.goodsList.Add(new StoreGoodsDetailsItem2()
                                                {
                                                    id = gItem.Id,
                                                    price = Math.Round((gItem?.SellingPrice ?? 0), 2),
                                                    name = gItem.Name,
                                                    picUrl = Common.Config.GetFileUrl(gItem.CoverImage),
                                                    OriginalPrice = Math.Round((gItem?.OriginalPrice ?? 0), 2),
                                                    courseScore = gItem.CourseScore ?? 0,
                                                    IsChooseServicePerson = gItem.IsChooseServicePerson,
                                                    DepositMoney = gItem.DepositMoney
                                                });
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        //不显示商品分类
                        else
                        {
                            //自动添加商品
                            if (storeGoodsData.addGoodsType == 0)
                            {
                                storeGoodsData.list = new List<StoreGoodsDetailsItem2>();
                                var goodsList = productModule.GetProductGoodsPageList_V2(1, storeGoodsData.goodsLength, out long rowsCount, new Model.Extend.Product.RB_Goods_Extend()
                                {
                                    TenantId = TenantId,
                                    MallBaseId = MallBaseId,
                                    GoodsStatus = 1,
                                    GoodsClassify = 3,//查询非司导
                                    StoresIds = StoreId.ToString()
                                    // GoodsPageType = IsOpenSchool == 1 ? Common.Enum.Goods.GoodsPageTypeEnum.School : Common.Enum.Goods.GoodsPageTypeEnum.Mall
                                });
                                #region 微店价格
                                RB_SmallShops_Info_Extend smallModel = new RB_SmallShops_Info_Extend();
                                List<RB_SmallShops_Price_Extend> smallPList = new List<RB_SmallShops_Price_Extend>();
                                if (SmallShopsId > 0 && goodsList.Any())
                                {
                                    string goodsId = string.Join(",", goodsList.Select(x => x.Id));
                                    smallModel = smallShops_InfoRepository.GetEntity<RB_SmallShops_Info_Extend>(SmallShopsId);
                                    smallPList = smallShops_PriceRepository.GetList(new RB_SmallShops_Price_Extend() { SmallShopsId = SmallShopsId, GoodsIds = goodsId });
                                    var spriceList = goods_SpecificationPriceRepository.GetList(new RB_Goods_SpecificationPrice_Extend() { GoodsIds = goodsId });
                                    foreach (var item in goodsList)
                                    {
                                        if ((smallModel.UpPrice ?? 0) > 0 || smallPList.Where(x => x.GoodsId == item.Id && x.UpPrice > 0).Any())
                                        {
                                            var spList = spriceList.Where(x => x.GoodsId == item.Id).ToList();
                                            if (spList.Any())
                                            {
                                                foreach (var qitem in spList)
                                                {
                                                    var sspModel = smallPList.Where(x => x.GoodsId == item.Id && x.SpecificationKey == qitem.SpecificationSort).FirstOrDefault();
                                                    if (sspModel != null)
                                                    {
                                                        //单商品设置的
                                                        if (sspModel.PriceType == 1)
                                                        {
                                                            qitem.SellingPrice = (qitem.SellingPrice ?? 0) + Math.Ceiling((qitem.SellingPrice ?? 0) * (sspModel.UpPrice ?? 0) / 100);
                                                        }
                                                        else if (sspModel.PriceType == 2)
                                                        {
                                                            qitem.SellingPrice = (qitem.SellingPrice ?? 0) + (sspModel.UpPrice ?? 0);
                                                        }
                                                    }
                                                    else
                                                    {
                                                        if ((smallModel.UpPrice ?? 0) > 0)
                                                        {
                                                            if (smallModel.PriceType == 1)
                                                            {
                                                                qitem.SellingPrice = (qitem.SellingPrice ?? 0) + Math.Ceiling((qitem.SellingPrice ?? 0) * (smallModel.UpPrice ?? 0) / 100);
                                                            }
                                                            else if (smallModel.PriceType == 2)
                                                            {
                                                                qitem.SellingPrice = (qitem.SellingPrice ?? 0) + (smallModel.UpPrice ?? 0);
                                                            }
                                                        }
                                                    }
                                                }
                                                item.SellingPrice = spList.Min(x => x.SellingPrice ?? 0);
                                                decimal MaxPrice = spList.Max(x => x.SellingPrice ?? 0);
                                                MaxPrice += Math.Ceiling(MaxPrice / 10);
                                                if (MaxPrice > item.OriginalPrice)
                                                {
                                                    item.OriginalPrice = MaxPrice;
                                                }
                                            }
                                            else
                                            {
                                                var sspModel = smallPList.Where(x => x.GoodsId == item.Id && x.SpecificationKey == "").FirstOrDefault();
                                                if (sspModel != null)
                                                {
                                                    //单商品设置的
                                                    if (sspModel.PriceType == 1)
                                                    {
                                                        item.SellingPrice = (item.SellingPrice ?? 0) + Math.Ceiling((item.SellingPrice ?? 0) * (sspModel.UpPrice ?? 0) / 100);
                                                        item.OriginalPrice = (item.OriginalPrice ?? 0) + Math.Ceiling((item.OriginalPrice ?? 0) * (sspModel.UpPrice ?? 0) / 100);
                                                    }
                                                    else if (sspModel.PriceType == 2)
                                                    {
                                                        item.SellingPrice = (item.SellingPrice ?? 0) + (sspModel.UpPrice ?? 0);
                                                        item.OriginalPrice = (item.OriginalPrice ?? 0) + (sspModel.UpPrice ?? 0);
                                                    }
                                                }
                                                else
                                                {
                                                    if ((smallModel.UpPrice ?? 0) > 0)
                                                    {
                                                        if (smallModel.PriceType == 1)
                                                        {
                                                            item.SellingPrice = (item.SellingPrice ?? 0) + Math.Ceiling((item.SellingPrice ?? 0) * (smallModel.UpPrice ?? 0) / 100);
                                                            item.OriginalPrice = (item.OriginalPrice ?? 0) + Math.Ceiling((item.OriginalPrice ?? 0) * (smallModel.UpPrice ?? 0) / 100);
                                                        }
                                                        else if (smallModel.PriceType == 2)
                                                        {
                                                            item.SellingPrice = (item.SellingPrice ?? 0) + (smallModel.UpPrice ?? 0);
                                                            item.OriginalPrice = (item.OriginalPrice ?? 0) + (smallModel.UpPrice ?? 0);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                #endregion
                                if (goodsList != null && goodsList.Count > 0)
                                {
                                    foreach (var gItem in goodsList)
                                    {
                                        storeGoodsData.list.Add(new StoreGoodsDetailsItem2()
                                        {
                                            id = gItem.Id,
                                            price = Math.Round((gItem?.SellingPrice ?? 0), 2),
                                            name = gItem.Name,
                                            picUrl = Common.Config.GetFileUrl(gItem.CoverImage),
                                            OriginalPrice = Math.Round((gItem?.OriginalPrice ?? 0), 2),
                                            courseScore = gItem.CourseScore ?? 0,
                                            IsChooseServicePerson = gItem.IsChooseServicePerson,
                                            DepositMoney = gItem.DepositMoney,
                                        });
                                    }
                                }
                            }
                            //手动添加商品
                            else
                            {
                                if (storeGoodsData.list != null && storeGoodsData.list.Count > 0)
                                {
                                    var Ids = "0," + string.Join(",", storeGoodsData.list.Select(qitem => qitem.id));
                                    var tempGoodsList = productModule.GetProductGoodsList(new Model.Extend.Product.RB_Goods_Extend()
                                    {
                                        TenantId = TenantId,
                                        MallBaseId = MallBaseId,
                                        GoodsIds = Ids,
                                        GoodsStatus = 1,
                                        GoodsClassify = 3,//查询非司导
                                        StoresIds = StoreId.ToString()
                                        // GoodsPageType = IsOpenSchool == 1 ? Common.Enum.Goods.GoodsPageTypeEnum.School : Common.Enum.Goods.GoodsPageTypeEnum.Mall
                                    });
                                    #region 微店价格
                                    RB_SmallShops_Info_Extend smallModel = new RB_SmallShops_Info_Extend();
                                    List<RB_SmallShops_Price_Extend> smallPList = new List<RB_SmallShops_Price_Extend>();
                                    if (SmallShopsId > 0 && tempGoodsList.Any())
                                    {
                                        string goodsId = string.Join(",", tempGoodsList.Select(x => x.Id));
                                        smallModel = smallShops_InfoRepository.GetEntity<RB_SmallShops_Info_Extend>(SmallShopsId);
                                        smallPList = smallShops_PriceRepository.GetList(new RB_SmallShops_Price_Extend() { SmallShopsId = SmallShopsId, GoodsIds = goodsId });
                                        var spriceList = goods_SpecificationPriceRepository.GetList(new RB_Goods_SpecificationPrice_Extend() { GoodsIds = goodsId });
                                        foreach (var item in tempGoodsList)
                                        {
                                            if ((smallModel.UpPrice ?? 0) > 0 || smallPList.Where(x => x.GoodsId == item.Id && x.UpPrice > 0).Any())
                                            {
                                                var spList = spriceList.Where(x => x.GoodsId == item.Id).ToList();
                                                if (spList.Any())
                                                {
                                                    foreach (var qitem in spList)
                                                    {
                                                        var sspModel = smallPList.Where(x => x.GoodsId == item.Id && x.SpecificationKey == qitem.SpecificationSort).FirstOrDefault();
                                                        if (sspModel != null)
                                                        {
                                                            //单商品设置的
                                                            if (sspModel.PriceType == 1)
                                                            {
                                                                qitem.SellingPrice = (qitem.SellingPrice ?? 0) + Math.Ceiling((qitem.SellingPrice ?? 0) * (sspModel.UpPrice ?? 0) / 100);
                                                            }
                                                            else if (sspModel.PriceType == 2)
                                                            {
                                                                qitem.SellingPrice = (qitem.SellingPrice ?? 0) + (sspModel.UpPrice ?? 0);
                                                            }
                                                        }
                                                        else
                                                        {
                                                            if ((smallModel.UpPrice ?? 0) > 0)
                                                            {
                                                                if (smallModel.PriceType == 1)
                                                                {
                                                                    qitem.SellingPrice = (qitem.SellingPrice ?? 0) + Math.Ceiling((qitem.SellingPrice ?? 0) * (smallModel.UpPrice ?? 0) / 100);
                                                                }
                                                                else if (smallModel.PriceType == 2)
                                                                {
                                                                    qitem.SellingPrice = (qitem.SellingPrice ?? 0) + (smallModel.UpPrice ?? 0);
                                                                }
                                                            }
                                                        }
                                                    }
                                                    item.SellingPrice = spList.Min(x => x.SellingPrice ?? 0);
                                                    decimal MaxPrice = spList.Max(x => x.SellingPrice ?? 0);
                                                    MaxPrice += Math.Ceiling(MaxPrice / 10);
                                                    if (MaxPrice > item.OriginalPrice)
                                                    {
                                                        item.OriginalPrice = MaxPrice;
                                                    }
                                                }
                                                else
                                                {
                                                    var sspModel = smallPList.Where(x => x.GoodsId == item.Id && x.SpecificationKey == "").FirstOrDefault();
                                                    if (sspModel != null)
                                                    {
                                                        //单商品设置的
                                                        if (sspModel.PriceType == 1)
                                                        {
                                                            item.SellingPrice = (item.SellingPrice ?? 0) + Math.Ceiling((item.SellingPrice ?? 0) * (sspModel.UpPrice ?? 0) / 100);
                                                            item.OriginalPrice = (item.OriginalPrice ?? 0) + Math.Ceiling((item.OriginalPrice ?? 0) * (sspModel.UpPrice ?? 0) / 100);
                                                        }
                                                        else if (sspModel.PriceType == 2)
                                                        {
                                                            item.SellingPrice = (item.SellingPrice ?? 0) + (sspModel.UpPrice ?? 0);
                                                            item.OriginalPrice = (item.OriginalPrice ?? 0) + (sspModel.UpPrice ?? 0);
                                                        }
                                                    }
                                                    else
                                                    {
                                                        if ((smallModel.UpPrice ?? 0) > 0)
                                                        {
                                                            if (smallModel.PriceType == 1)
                                                            {
                                                                item.SellingPrice = (item.SellingPrice ?? 0) + Math.Ceiling((item.SellingPrice ?? 0) * (smallModel.UpPrice ?? 0) / 100);
                                                                item.OriginalPrice = (item.OriginalPrice ?? 0) + Math.Ceiling((item.OriginalPrice ?? 0) * (smallModel.UpPrice ?? 0) / 100);
                                                            }
                                                            else if (smallModel.PriceType == 2)
                                                            {
                                                                item.SellingPrice = (item.SellingPrice ?? 0) + (smallModel.UpPrice ?? 0);
                                                                item.OriginalPrice = (item.OriginalPrice ?? 0) + (smallModel.UpPrice ?? 0);
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    #endregion
                                    List<StoreGoodsDetailsItem2> newGoodsList = new List<StoreGoodsDetailsItem2>();
                                    foreach (var goodItem in storeGoodsData.list)
                                    {
                                        var childItem = new StoreGoodsDetailsItem2();
                                        var tempGood = tempGoodsList?.Where(qitem => qitem.Id == goodItem.id)?.FirstOrDefault();
                                        if (tempGood != null && tempGood.Id > 0)
                                        {
                                            childItem.id = tempGood.Id;
                                            childItem.name = tempGood?.Name ?? "";
                                            childItem.price = Math.Round((tempGood?.SellingPrice ?? 0), 2);
                                            childItem.picUrl = tempGood?.CoverImage != null ? Common.Config.GetFileUrl(tempGood.CoverImage) : "";
                                            childItem.OriginalPrice = Math.Round((tempGood?.OriginalPrice ?? 0), 2);
                                            childItem.courseScore = (tempGood.CourseScore ?? 0);
                                            childItem.IsChooseServicePerson = tempGood.IsChooseServicePerson;
                                            childItem.DepositMoney = tempGood.DepositMoney;
                                            newGoodsList.Add(childItem);
                                        }
                                    }
                                    storeGoodsData.list = newGoodsList;
                                }
                            }
                        }
                    }
                    obj = new
                    {
                        id = subItem.Id,
                        data = storeGoodsData
                    };
                    break;
                case "reservestore":
                    var reserveStoreInfo = subItem.data as ReserveStoreItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = reserveStoreInfo
                    };
                    break;

                //详情-人物插件
                case "miaiuser":
                    var miAiUserItem = subItem.data as MiAiUserItem;

                    if (miAiUserItem != null)
                    {
                        int Sex = 0;
                        int Age = 0;
                        if (UserId > 0)//说明用户登录了的
                        {
                            //查看用户的
                            var baseInfo = miaiModule.GetBaseInfoList(new Model.Extend.Miai.RB_MiAi_BaseInfo_Extend { TenantId = TenantId, MallBaseId = MallBaseId, UserId = UserId }).FirstOrDefault();
                            if (baseInfo != null)
                            {
                                Sex = baseInfo.Sex;
                                if (!string.IsNullOrWhiteSpace(baseInfo.Birthday))
                                {
                                    try
                                    {
                                        Age = Convert.ToInt32(Common.Plugin.StringHelper.GetAge(baseInfo.Birthday));
                                    }
                                    catch (Exception)
                                    {

                                        Age = 0;
                                    }
                                }
                            }
                            if (miAiUserItem.sexType > 0)
                            {
                                Sex = miAiUserItem.sexType == 1 ? 2 : (miAiUserItem.sexType == 2 ? 1 : 0);
                            }
                        }


                        //自定义商品
                        if (miAiUserItem.addUserType == 0)
                        {
                            if (miAiUserItem.list != null && miAiUserItem.list.Count > 0)
                            {
                                var Ids = "0," + string.Join(",", miAiUserItem.list.Select(qitem => qitem.id));
                                var tempGoodsList = miaiModule.GetFirstBaseInfoList(new Model.Extend.Miai.RB_MiAi_BaseInfo_Extend
                                {
                                    TenantId = TenantId,
                                    MallBaseId = MallBaseId,
                                    UserIds = Ids,
                                    UserId = UserId
                                });
                                List<miaiUserDetail> newGoodsList = new List<miaiUserDetail>();
                                foreach (var goodItem in miAiUserItem.list)
                                {
                                    var lastItem = new miaiUserDetail();
                                    var tempGood = tempGoodsList?.Where(qitem => qitem.UserId == goodItem.id)?.FirstOrDefault();
                                    if (tempGood != null && tempGood.Id > 0)
                                    {
                                        lastItem.id = tempGood.UserId;
                                        lastItem.name = tempGood.Name;
                                        lastItem.Photo = tempGood.Photo;
                                        lastItem.SexStr = tempGood.Sex == 1 ? "男" : "女";
                                        lastItem.Age = tempGood.Age.ToString(); //Common.Plugin.StringHelper.GetAge(tempGood.Birthday);
                                        lastItem.Marriage = (tempGood.Marriage.HasValue && tempGood.Marriage.Value > 0) ? Common.Plugin.EnumHelper.GetEnumName(tempGood.Marriage) : "";
                                        lastItem.Education = (tempGood.EducationType.HasValue && tempGood.EducationType.Value > 0) ? Common.Plugin.EnumHelper.GetEnumName(tempGood.EducationType) : "";
                                        if (UserId > 0 && Age > 0)
                                        {
                                            if (Age == tempGood.Age)
                                            {
                                                lastItem.MatchingRate = 90;
                                            }
                                            else if (Age > tempGood.Age)
                                            {
                                                lastItem.MatchingRate = ((Age - tempGood.Age) + 90) > 100 ? 100 : ((Age - tempGood.Age) + 90);
                                            }
                                            else if (Age < tempGood.Age)
                                            {
                                                lastItem.MatchingRate = (90 - (tempGood.Age - Age)) < 0 ? 0 : (90 - (tempGood.Age - Age));
                                            }
                                            else
                                            {
                                                lastItem.MatchingRate = 0;
                                            }
                                        }
                                        else
                                        {
                                            lastItem.MatchingRate = 0;
                                        }

                                        lastItem.Score = 0;
                                        lastItem.Album = tempGood.Album;
                                        if (!string.IsNullOrWhiteSpace(lastItem.Album))
                                        {
                                            lastItem.AlbumList = JsonConvert.DeserializeObject<List<string>>(lastItem.Album);
                                        }
                                        newGoodsList.Add(lastItem);
                                    }
                                }
                                miAiUserItem.list = newGoodsList;
                            }
                        }
                        else if (miAiUserItem.addUserType == 1)//匹配度暂无规则
                        {

                            var tempGoodsList = miaiModule.GetMatchingBaseInfoList(new Model.Extend.Miai.RB_MiAi_BaseInfo_Extend
                            {
                                TenantId = TenantId,
                                MallBaseId = MallBaseId,
                                UserId = UserId,
                                Sex = Sex
                            }, miAiUserItem.goodsLength);
                            List<miaiUserDetail> newGoodsList = new List<miaiUserDetail>();
                            foreach (var tempGood in tempGoodsList)
                            {
                                var lastItem = new miaiUserDetail();
                               // var tempGood = tempGoodsList?.Where(qitem => qitem.UserId == goodItem.id)?.FirstOrDefault();
                                if (tempGood != null && tempGood.Id > 0)
                                {
                                    lastItem.id = tempGood.UserId;
                                    lastItem.name = tempGood.Name;
                                    lastItem.Photo = tempGood.Photo;
                                    lastItem.SexStr = tempGood.Sex == 1 ? "男" : "女";
                                    lastItem.Age = tempGood.Age.ToString();
                                    lastItem.Marriage = (tempGood.Marriage.HasValue && tempGood.Marriage.Value > 0) ? Common.Plugin.EnumHelper.GetEnumName(tempGood.Marriage) : "";
                                    lastItem.Education = (tempGood.EducationType.HasValue && tempGood.EducationType.Value > 0) ? Common.Plugin.EnumHelper.GetEnumName(tempGood.EducationType) : "";
                                    if (UserId > 0 && Age > 0)
                                    {
                                        if (Age == tempGood.Age)
                                        {
                                            lastItem.MatchingRate = 90;
                                        }
                                        else if (Age > tempGood.Age)
                                        {
                                            lastItem.MatchingRate = ((Age - tempGood.Age) + 90) > 100 ? 100 : ((Age - tempGood.Age) + 90);
                                        }
                                        else if (Age < tempGood.Age)
                                        {
                                            lastItem.MatchingRate = (90 - (tempGood.Age - Age)) < 0 ? 0 : (90 - (tempGood.Age - Age));
                                        }
                                        else
                                        {
                                            lastItem.MatchingRate = 0;
                                        }
                                    }
                                    else
                                    {
                                        lastItem.MatchingRate = 0;
                                    }
                                    lastItem.Score = 0;
                                    lastItem.Album = tempGood.Album;
                                    if (!string.IsNullOrWhiteSpace(lastItem.Album))
                                    {
                                        lastItem.AlbumList = JsonConvert.DeserializeObject<List<string>>(lastItem.Album);
                                    }
                                    newGoodsList.Add(lastItem);
                                }
                            }
                            miAiUserItem.list = newGoodsList;
                        }
                        else if (miAiUserItem.addUserType == 2)
                        {


                            long rowCount = 0;
                            var tempGoodsList = miaiModule.GetFirstBaseInfoPageList(1, miAiUserItem.goodsLength, out rowCount, new Model.Extend.Miai.RB_MiAi_BaseInfo_Extend
                            {
                                TenantId = TenantId,
                                MallBaseId = MallBaseId,
                                Sort = 2,
                                Sex = Sex,
                                UserId = UserId,
                                FollowRate = miAiUserItem.FollowRate == 0 ? 1 : miAiUserItem.FollowRate,
                                BrowseRate = miAiUserItem.BrowseRate == 0 ? 1 : miAiUserItem.BrowseRate,
                            });
                            List<miaiUserDetail> newGoodsList = new List<miaiUserDetail>();
                            foreach (var tempGood in tempGoodsList)
                            {
                                var lastItem = new miaiUserDetail();
                              //  var tempGood = tempGoodsList?.Where(qitem => qitem.UserId == goodItem.id)?.FirstOrDefault();
                                if (tempGood != null && tempGood.Id > 0)
                                {
                                    lastItem.id = tempGood.UserId;
                                    lastItem.name = tempGood.Name;
                                    lastItem.Photo = tempGood.Photo;
                                    lastItem.SexStr = tempGood.Sex == 1 ? "男" : "女";
                                    lastItem.Age = tempGood.Age.ToString();
                                    lastItem.Marriage = (tempGood.Marriage.HasValue && tempGood.Marriage.Value > 0) ? Common.Plugin.EnumHelper.GetEnumName(tempGood.Marriage) : "";
                                    lastItem.Education = (tempGood.EducationType.HasValue && tempGood.EducationType.Value > 0) ? Common.Plugin.EnumHelper.GetEnumName(tempGood.EducationType) : "";

                                    if (UserId > 0 && Age > 0)
                                    {
                                        if (Age == tempGood.Age)
                                        {
                                            lastItem.MatchingRate = 90;
                                        }
                                        else if (Age > tempGood.Age)
                                        {
                                            lastItem.MatchingRate = ((Age - tempGood.Age) + 90) > 100 ? 100 : ((Age - tempGood.Age) + 90);
                                        }
                                        else if (Age < tempGood.Age)
                                        {
                                            lastItem.MatchingRate = (90 - (tempGood.Age - Age)) < 0 ? 0 : (90 - (tempGood.Age - Age));
                                        }
                                        else
                                        {
                                            lastItem.MatchingRate = 0;
                                        }
                                    }
                                    else
                                    {
                                        lastItem.MatchingRate = 0;
                                    }
                                    lastItem.Score = 0;
                                    lastItem.Album = tempGood.Album;
                                    if (!string.IsNullOrWhiteSpace(lastItem.Album))
                                    {
                                        lastItem.AlbumList = JsonConvert.DeserializeObject<List<string>>(lastItem.Album);
                                    }
                                    newGoodsList.Add(lastItem);
                                }
                            }
                            miAiUserItem.list = newGoodsList;

                        }

                        else if (miAiUserItem.addUserType == 3)
                        {

                            long rowCount = 0;
                            var tempGoodsList = miaiModule.GetFirstBaseInfoPageList(1, miAiUserItem.goodsLength, out rowCount, new Model.Extend.Miai.RB_MiAi_BaseInfo_Extend
                            {
                                TenantId = TenantId,
                                MallBaseId = MallBaseId,
                                Sort = 3,
                                Sex = Sex,
                                UserId = UserId
                            });
                            List<miaiUserDetail> newGoodsList = new List<miaiUserDetail>();
                            foreach (var tempGood in tempGoodsList)
                            {
                                var lastItem = new miaiUserDetail();
                               // var tempGood = tempGoodsList?.Where(qitem => qitem.UserId == goodItem.id)?.FirstOrDefault();
                                if (tempGood != null && tempGood.Id > 0)
                                {
                                    lastItem.id = tempGood.UserId;
                                    lastItem.name = tempGood.Name;
                                    lastItem.Photo = tempGood.Photo;
                                    lastItem.SexStr = tempGood.Sex == 1 ? "男" : "女";
                                    lastItem.Age = tempGood.Age.ToString();
                                    lastItem.Marriage = (tempGood.Marriage.HasValue && tempGood.Marriage.Value > 0) ? Common.Plugin.EnumHelper.GetEnumName(tempGood.Marriage) : "";
                                    lastItem.Education = (tempGood.EducationType.HasValue && tempGood.EducationType.Value > 0) ? Common.Plugin.EnumHelper.GetEnumName(tempGood.EducationType) : "";

                                    if (UserId > 0 && Age > 0)
                                    {
                                        if (Age == tempGood.Age)
                                        {
                                            lastItem.MatchingRate = 90;
                                        }
                                        else if (Age > tempGood.Age)
                                        {
                                            lastItem.MatchingRate = ((Age - tempGood.Age) + 90) > 100 ? 100 : ((Age - tempGood.Age) + 90);
                                        }
                                        else if (Age < tempGood.Age)
                                        {
                                            lastItem.MatchingRate = (90 - (tempGood.Age - Age)) < 0 ? 0 : (90 - (tempGood.Age - Age));
                                        }
                                        else
                                        {
                                            lastItem.MatchingRate = 0;
                                        }
                                    }
                                    else
                                    {
                                        lastItem.MatchingRate = 0;
                                    }
                                    lastItem.Score = 0;
                                    lastItem.Album = tempGood.Album;
                                    if (!string.IsNullOrWhiteSpace(lastItem.Album))
                                    {
                                        lastItem.AlbumList = JsonConvert.DeserializeObject<List<string>>(lastItem.Album);
                                    }
                                    newGoodsList.Add(lastItem);
                                }
                            }
                            miAiUserItem.list = newGoodsList;

                        }
                    }
                    obj = new
                    {
                        id = subItem.Id,
                        data = miAiUserItem
                    };
                    break;


                case "miaiactivitytype":
                    var miAiActivityTypeItemInfo = subItem.data as MiAiActivityTypeItem;

                    if (miAiActivityTypeItemInfo != null)
                    {
                        //自定义商品

                        if (miAiActivityTypeItemInfo.list != null && miAiActivityTypeItemInfo.list.Count > 0)
                        {
                            var Ids = "0," + string.Join(",", miAiActivityTypeItemInfo.list.Select(qitem => qitem.id));
                            var tempGoodsList = commerceActivityModule.GetCommerceActivityTypeListModule(new Mall.Model.Extend.TradePavilion.RB_Commerce_ActivityType_Extend()
                            {
                                TenantId = TenantId,
                                MallBaseId = MallBaseId,
                                Ids = Ids
                            });
                            List<MiAiActivityTypeModel> newTeacherList = new List<MiAiActivityTypeModel>();
                            foreach (var goodItem in miAiActivityTypeItemInfo.list)
                            {
                                var lastItem = new MiAiActivityTypeModel();
                                var tempGood = tempGoodsList?.Where(qitem => qitem.Id == goodItem.id)?.FirstOrDefault();
                                if (tempGood != null && tempGood.Id > 0)
                                {
                                    lastItem.id = tempGood.Id;
                                    lastItem.name = tempGood.TypeName;
                                    lastItem.lableName = tempGood.LableName;
                                    lastItem.picUrl = tempGood.CoverImage;
                                    if (!string.IsNullOrWhiteSpace(lastItem.lableName))
                                    {
                                        lastItem.lableNameList = JsonConvert.DeserializeObject<List<string>>(lastItem.lableName);
                                    }
                                    newTeacherList.Add(lastItem);
                                }
                            }
                            miAiActivityTypeItemInfo.list = newTeacherList;
                        }
                    }
                    obj = new
                    {
                        id = subItem.Id,
                        data = miAiActivityTypeItemInfo
                    };
                    break;

                case "miaiactivityCustom":
                    var miAiActivityTypeCustomItem = subItem.data as MiAiActivityTypeCustomItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = miAiActivityTypeCustomItem
                    };
                    break;
            }
            return obj;
        }


        /// <summary>
        /// 自定义首页布局
        /// </summary>
        /// <param name="miniProgram"></param>
        /// <returns></returns>
        public static object DefaultHomepage(RB_MiniProgram_Extend miniProgram, int IsOpenSchool)
        {
            var templateData = new
            {
                id = 0,
                name = "",
                data = new List<object>()
            };
            foreach (var subitem in miniProgram.HomeDataList)
            {
                switch (subitem.key)
                {
                    //搜索框
                    case "search":
                        templateData.data.Add(new
                        {
                            id = subitem.key,
                            data = new searchItem()
                            {
                                color = "#FFFFFF",
                                background = "#f2f2f2", //背景颜色
                                radius = 4, //圆角
                                placeholder = "搜索", //提示文字
                                textColor = "#555555", //文字颜色
                                textPosition = "left" //文字位置
                            }
                        });
                        templateData.data.Add(new
                        {
                            id = "empty",
                            data = new emptyItem()
                            {
                                background = "#ffffff",
                                height = 10
                            }
                        });
                        break;

                    //轮播图
                    case "banner":
                        var bannerList = programModule.GetMallNavListModule(new Model.Entity.User.RB_Mall_Nav_Extend() { TenantId = miniProgram.TenantId, MallBaseId = miniProgram.MallBaseId });
                        var detailsBannerList = new List<bannerDetailItem>();
                        if (bannerList != null && bannerList.Count > 0)
                        {
                            foreach (var bItem in bannerList)
                            {
                                detailsBannerList.Add(new bannerDetailItem()
                                {
                                    url = bItem.NavLink,
                                    picUrl = Common.Config.GetFileUrl(bItem.NavImg)
                                });
                            }
                        }
                        templateData.data.Add(new
                        {
                            id = subitem.key,
                            data = new bannerItem()
                            {
                                style = 1, //样式
                                fill = 1, //填充方式0-留白 1填充
                                height = 450, //默认高度
                                banners = detailsBannerList
                            }
                        });
                        templateData.data.Add(new
                        {
                            id = "empty",
                            data = new emptyItem()
                            {
                                background = "#ffffff",
                                height = 10
                            }
                        });
                        break;
                    //导航图标
                    case "home_nav":
                        var navList = programNaviconModule.GetMiniProgramNaviconListModule(new RB_MiniProgram_Navicon_Extend()
                        {
                            MallBaseId = miniProgram.MallBaseId
                        });
                        List<navIconItem> navs = new List<navIconItem>();
                        if (navList != null && navList.Count > 0)
                        {
                            foreach (var nItem in navList)
                            {
                                navs.Add(new navIconItem()
                                {
                                    icon = Common.Config.GetFileUrl(nItem.NavIconImg),
                                    url = nItem.NavIconUrl,
                                    key = "",
                                    name = nItem.NavIconName,
                                    openType = ""
                                });
                            }
                        }
                        templateData.data.Add(new
                        {
                            id = "nav",
                            data = new navItem()
                            {
                                color = "#353535",
                                rows = 1,//每页行数
                                columns = subitem.row_num, //每行个数 
                                scroll = true, //左右滑动
                                showImg = false, //背景图片
                                backgroundColor = "#ffffff", //背景颜色
                                backgroundPicUrl = "", //背景链接
                                position = 5, //图片位置
                                mode = 1, //填充方式
                                backgroundHeight = 100, //背景图宽
                                backgroundWidth = 100, //背景图高
                                navs = navs, //导航图标
                            }
                        });
                        templateData.data.Add(new
                        {
                            id = "empty",
                            data = new emptyItem()
                            {
                                background = "#ffffff",
                                height = 10
                            }
                        });
                        break;

                    //视频插件
                    case "video":
                        templateData.data.Add(new
                        {
                            id = subitem.key,
                            data = new videoItem()
                            {
                                pic_url = Common.Config.GetFileUrl(subitem.video_pic_url),
                                url = subitem.video_url,
                                bottom = "0",
                                left = "0",
                                right = "0",
                                top = "0",
                                isfullscreen = false,
                                backgroundimage = "",
                                radius = "0"
                            }
                        });
                        templateData.data.Add(new
                        {
                            id = "empty",
                            data = new emptyItem()
                            {
                                background = "#ffffff",
                                height = 10
                            }
                        });
                        break;
                    //公告
                    case "notice":
                        templateData.data.Add(new
                        {
                            id = subitem.key,
                            data = new noticeItem()
                            {
                                name = subitem.NoticeName, //公告名称
                                content = subitem.NoticeContent, //公告内容
                                icon = Common.Config.GetFileUrl(subitem.notice_url), //公告图标
                                textColor = subitem.notice_text_color, //文字颜色
                                background = subitem.notice_bg_color, //背景颜色
                                headerUrl = "", //头部图片
                                btnColor = "#ff4544", //按钮颜色
                                btnWidth = 500, //按钮宽度 
                                btnHeight = 80, //按钮高度 
                                btnRadius = 40, //按钮圆角 
                                btnText = "我知道了", //按钮文本内容
                                btnTextColor = "#ffffff" //按钮文本颜色
                            }
                        });
                        templateData.data.Add(new
                        {
                            id = "empty",
                            data = new emptyItem()
                            {
                                background = "#ffffff",
                                height = 10
                            }
                        });
                        break;
                    //专题
                    case "topic":
                        var topicSourceList = contentModule.GetTopicListModule(new Model.Entity.User.RB_Topic_Extend()
                        {
                            MallBaseId = miniProgram.MallBaseId,
                            TenantId = miniProgram.TenantId,
                        });
                        var topic_list = new List<topicDetailsItem>();
                        if (topicSourceList != null && topicSourceList.Count > 0)
                        {
                            foreach (var tItem in topicSourceList)
                            {
                                topic_list.Add(new topicDetailsItem()
                                {
                                    cover_pic = Common.Config.GetFileUrl(tItem.CoverImg),
                                    read_count = 0,
                                    title = tItem.Title,
                                    id = tItem.Id,
                                    layout = 0
                                });
                            }
                        }
                        templateData.data.Add(new
                        {
                            id = subitem.key,
                            data = new topicItem()
                            {
                                style = "normal",
                                count = subitem.topic_num,
                                logo_1 = Common.Config.GetFileUrl(subitem.topic_url),
                                logo_2 = Common.Config.GetFileUrl(subitem.topic_url_2),
                                icon = Common.Config.GetFileUrl(subitem.label_url),
                                cat_show = false,
                                list = new List<topicTypeItem>(),
                                topic_list = topic_list
                            }
                        });
                        templateData.data.Add(new
                        {
                            id = "empty",
                            data = new emptyItem()
                            {
                                background = "#ffffff",
                                height = 10
                            }
                        });
                        break;
                    //领劵中心
                    case "coupon":

                        break;
                    //商品分类
                    case "cat":
                        var cats = new catItem()
                        {
                            goodsNum = 6,
                            id = subitem.relation_id,
                            menuName = subitem.name,
                            name = subitem.name,
                            staticGoods = false,
                            goodsList = new List<GoodsDetailsItem2>()
                        };
                        if (subitem.relation_id == 0)
                        {
                            var goodsList = productModule.GetProductGoodsPageList_V2(1, 6, out long rowsCount, new Model.Extend.Product.RB_Goods_Extend()
                            {
                                TenantId = Convert.ToInt32(miniProgram.TenantId),
                                MallBaseId = miniProgram.MallBaseId,
                                GoodsStatus = 1,
                                GoodsPageType = IsOpenSchool == 1 ? Common.Enum.Goods.GoodsPageTypeEnum.School : Common.Enum.Goods.GoodsPageTypeEnum.Mall
                            });
                            if (goodsList != null && goodsList.Count > 0)
                            {
                                foreach (var gItem in goodsList)
                                {
                                    cats.goodsList.Add(new GoodsDetailsItem2()
                                    {
                                        id = gItem.Id,
                                        price = Math.Round(gItem?.SellingPrice ?? 0, 2),
                                        name = gItem.Name,
                                        picUrl = Common.Config.GetFileUrl(gItem.CoverImage),
                                        OriginalPrice = Math.Round(gItem?.OriginalPrice ?? 0, 2)
                                    });
                                }
                            }
                        }
                        else
                        {
                            var goodsList = productModule.GetProductGoodsPageList_V2(1, 6, out long rowsCount, new Model.Extend.Product.RB_Goods_Extend()
                            {
                                TenantId = Convert.ToInt32(miniProgram.TenantId),
                                MallBaseId = miniProgram.MallBaseId,
                                CategoryIds = subitem.relation_id.ToString(),
                                GoodsStatus = 1,
                                GoodsPageType = IsOpenSchool == 1 ? Common.Enum.Goods.GoodsPageTypeEnum.School : Common.Enum.Goods.GoodsPageTypeEnum.Mall
                            });
                            if (goodsList != null && goodsList.Count > 0)
                            {
                                foreach (var gItem in goodsList)
                                {
                                    cats.goodsList.Add(new GoodsDetailsItem2()
                                    {
                                        id = gItem.Id,
                                        price = Math.Round(gItem?.SellingPrice ?? 0, 2),
                                        name = gItem.Name,
                                        picUrl = Common.Config.GetFileUrl(gItem.CoverImage),
                                        OriginalPrice = Math.Round(gItem?.OriginalPrice ?? 0, 2)
                                    });
                                }
                            }
                        }
                        templateData.data.Add(new
                        {
                            id = "goods",
                            data = new goodsItem()
                            {
                                showCat = true,
                                catPosition = "top",
                                catStyle = 0,
                                addGoodsType = 0,
                                goodsLength = 6,
                                listStyle = 3,
                                goodsCoverProportion = "1-1",
                                fill = 1,
                                goodsStyle = 1,
                                textStyle = 1,
                                showGoodsName = true,
                                showGoodsPrice = true,
                                showBuyBtn = true,
                                buyBtn = "cart",
                                buyBtnStyle = 1,
                                buyBtnText = "购买",
                                buttonColor = "#ff4544",
                                showScore = false,
                                scoreColor = "#FFC86E",
                                showGoodsTag = false,
                                customizeGoodsTag = false,
                                goodsTagPicUrl = "",
                                showImg = false,
                                backgroundColor = "#fff",
                                backgroundPicUrl = "",
                                position = 5,
                                mode = 1,
                                backgroundHeight = 100,
                                backgroundWidth = 100,
                                list = new List<GoodsDetailsItem2>(),
                                catList = new List<catItem>() { cats }
                            }
                        });
                        templateData.data.Add(new
                        {
                            id = "empty",
                            data = new emptyItem()
                            {
                                background = "#ffffff",
                                height = 10
                            }
                        });
                        break;
                    //图片魔方
                    case "block":
                        var blockSource = programModule.GetMallMagicListModule(new Model.Entity.User.RB_Mall_Magic_Extend()
                        {
                            MallBaseId = miniProgram.MallBaseId,
                            TenantId = Convert.ToInt32(miniProgram.TenantId),
                            Id = subitem.relation_id
                        }).FirstOrDefault();
                        if (blockSource != null && blockSource.Id > 0)
                        {
                            var rubikData = new rubikItem()
                            {
                                style = Convert.ToInt32(blockSource.Style),
                                space = 0,
                                list = new List<rubikDetailItem>(),
                            };
                            switch (rubikData.style)
                            {
                                //1张图
                                case 0:
                                    rubikData.height = "360";
                                    rubikData.w = "1";
                                    rubikData.h = 1;
                                    rubikData.list.Add(new rubikDetailItem()
                                    {
                                        backgroundColor = "",
                                        numberX = 0,
                                        numberY = 0,
                                        w = 1,
                                        h = 1,
                                        x = 0,
                                        y = 0,
                                        link = new List<rubikLinkItem>()
                                        {
                                            new rubikLinkItem()
                                            {
                                                new_link_url = blockSource.MagicDataList[0].Link
                                            }
                                         },
                                        width = "calc(100%)",
                                        height = "calc(100%)",
                                        left = "0%",
                                        top = "0%",
                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[0].ImgUrl),
                                        backgroundImage = "",
                                        backgroundRepeat = "no-repeat",
                                        backgroundSize = "cover",
                                        backgroundPosition = "center"
                                    });
                                    break;
                                //两张图
                                case 1:
                                    rubikData.height = "360";
                                    rubikData.w = "25";
                                    rubikData.h = 12;
                                    rubikData.list.Add(new rubikDetailItem()
                                    {
                                        backgroundColor = "",
                                        numberX = 0,
                                        numberY = 0,
                                        w = 10,
                                        h = 12,
                                        x = 0,
                                        y = 0,
                                        link = new List<rubikLinkItem>()
                                        {
                                            new rubikLinkItem()
                                            {
                                                new_link_url = blockSource.MagicDataList[0].Link
                                            }
                                        },
                                        width = "calc(40%)",
                                        height = "calc(100%)",
                                        left = "0%",
                                        top = "0%",
                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[0].ImgUrl),
                                        backgroundImage = "",
                                        backgroundRepeat = "no-repeat",
                                        backgroundSize = "cover",
                                        backgroundPosition = "center"
                                    });
                                    rubikData.list.Add(new rubikDetailItem()
                                    {
                                        backgroundColor = "",
                                        numberX = 0,
                                        numberY = 0,
                                        w = 15,
                                        h = 12,
                                        x = 10,
                                        y = 0,
                                        link = new List<rubikLinkItem>()
                                        {
                                            new rubikLinkItem()
                                            {
                                                new_link_url = blockSource.MagicDataList[1].Link
                                            }
                                        },
                                        width = "calc(60%)",
                                        height = "calc(100%)",
                                        left = "calc(40%)",
                                        top = "0%",
                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[1].ImgUrl),
                                        backgroundImage = "",
                                        backgroundRepeat = "no-repeat",
                                        backgroundSize = "cover",
                                        backgroundPosition = "center"
                                    });
                                    break;
                                //三张图
                                case 2:
                                    rubikData.height = "360";
                                    rubikData.w = "25";
                                    rubikData.h = 12;
                                    rubikData.list.Add(new rubikDetailItem()
                                    {
                                        backgroundColor = "",
                                        numberX = 0,
                                        numberY = 0,
                                        w = 10,
                                        h = 12,
                                        x = 0,
                                        y = 0,
                                        link = new List<rubikLinkItem>()
                                        {
                                            new rubikLinkItem()
                                            {
                                                new_link_url = blockSource.MagicDataList[0].Link
                                            }
                                        },
                                        width = "calc(40%)",
                                        height = "calc(100%)",
                                        left = "0%",
                                        top = "0%",
                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[0].ImgUrl),
                                        backgroundImage = "",
                                        backgroundRepeat = "no-repeat",
                                        backgroundSize = "cover",
                                        backgroundPosition = "center"
                                    });
                                    rubikData.list.Add(new rubikDetailItem()
                                    {
                                        backgroundColor = "",
                                        numberX = 0,
                                        numberY = 0,
                                        w = 15,
                                        h = 6,
                                        x = 10,
                                        y = 0,
                                        link = new List<rubikLinkItem>()
                                        {
                                            new rubikLinkItem()
                                            {
                                                new_link_url = blockSource.MagicDataList[1].Link
                                            }
                                        },
                                        width = "calc(60%)",
                                        height = "calc(50%)",
                                        left = "calc(40%)",
                                        top = "0%",
                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[1].ImgUrl),
                                        backgroundImage = "",
                                        backgroundRepeat = "no-repeat",
                                        backgroundSize = "cover",
                                        backgroundPosition = "center"
                                    });
                                    rubikData.list.Add(new rubikDetailItem()
                                    {
                                        backgroundColor = "",
                                        numberX = 0,
                                        numberY = 0,
                                        w = 15,
                                        h = 6,
                                        x = 10,
                                        y = 6,
                                        link = new List<rubikLinkItem>()
                                        {
                                            new rubikLinkItem()
                                            {
                                                new_link_url = blockSource.MagicDataList[2].Link
                                            }
                                        },
                                        width = "calc(60%)",
                                        height = "calc(50%)",
                                        left = "calc(40%)",
                                        top = "calc(50%)",
                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[2].ImgUrl),
                                        backgroundImage = "",
                                        backgroundRepeat = "no-repeat",
                                        backgroundSize = "cover",
                                        backgroundPosition = "center"
                                    });
                                    break;
                                //四张图
                                case 3:
                                    rubikData.height = "360";
                                    rubikData.w = "50";
                                    rubikData.h = 24;
                                    rubikData.list.Add(new rubikDetailItem()
                                    {
                                        backgroundColor = "",
                                        numberX = 0,
                                        numberY = 0,
                                        w = 20,
                                        h = 24,
                                        x = 0,
                                        y = 0,
                                        link = new List<rubikLinkItem>()
                                        {
                                            new rubikLinkItem()
                                            {
                                                new_link_url = blockSource.MagicDataList[0].Link
                                            }
                                        },
                                        width = "calc(40%)",
                                        height = "calc(100%)",
                                        left = "0%",
                                        top = "0%",
                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[0].ImgUrl),
                                        backgroundImage = "",
                                        backgroundRepeat = "no-repeat",
                                        backgroundSize = "cover",
                                        backgroundPosition = "center"
                                    });
                                    rubikData.list.Add(new rubikDetailItem()
                                    {
                                        backgroundColor = "",
                                        numberX = 0,
                                        numberY = 0,
                                        w = 30,
                                        h = 12,
                                        x = 20,
                                        y = 0,
                                        link = new List<rubikLinkItem>()
                                        {
                                            new rubikLinkItem()
                                            {
                                                new_link_url = blockSource.MagicDataList[1].Link
                                            }
                                         },
                                        width = "calc(60%)",
                                        height = "calc(50%)",
                                        left = "calc(40%)",
                                        top = "0%",
                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[1].ImgUrl),
                                        backgroundImage = "",
                                        backgroundRepeat = "no-repeat",
                                        backgroundSize = "cover",
                                        backgroundPosition = "center"
                                    });
                                    rubikData.list.Add(new rubikDetailItem()
                                    {
                                        backgroundColor = "",
                                        numberX = 0,
                                        numberY = 0,
                                        w = 15,
                                        h = 12,
                                        x = 20,
                                        y = 12,
                                        link = new List<rubikLinkItem>()
                                        {
                                            new rubikLinkItem()
                                            {
                                                new_link_url = blockSource.MagicDataList[2].Link
                                            }
                                         },
                                        width = "calc(30%)",
                                        height = "calc(50%)",
                                        left = "calc(40%)",
                                        top = "calc(50%)",
                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[2].ImgUrl),
                                        backgroundImage = "",
                                        backgroundRepeat = "no-repeat",
                                        backgroundSize = "cover",
                                        backgroundPosition = "center"
                                    });
                                    rubikData.list.Add(new rubikDetailItem()
                                    {
                                        backgroundColor = "",
                                        numberX = 0,
                                        numberY = 0,
                                        w = 15,
                                        h = 12,
                                        x = 35,
                                        y = 12,
                                        link = new List<rubikLinkItem>()
                                        {
                                            new rubikLinkItem()
                                            {
                                                new_link_url = blockSource.MagicDataList[3].Link
                                            }
                                         },
                                        width = "calc(30%)",
                                        height = "calc(50%)",
                                        left = "calc(70%)",
                                        top = "calc(50%)",
                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[3].ImgUrl),
                                        backgroundImage = "",
                                        backgroundRepeat = "no-repeat",
                                        backgroundSize = "cover",
                                        backgroundPosition = "center"
                                    });
                                    break;
                                //两张平分图
                                case 4:
                                    rubikData.height = "240";
                                    rubikData.w = "50";
                                    rubikData.h = 16;
                                    rubikData.list.Add(new rubikDetailItem()
                                    {
                                        backgroundColor = "",
                                        numberX = 0,
                                        numberY = 0,
                                        w = 25,
                                        h = 16,
                                        x = 0,
                                        y = 0,
                                        link = new List<rubikLinkItem>()
                                        {
                                            new rubikLinkItem()
                                            {
                                                new_link_url = blockSource.MagicDataList[0].Link
                                            }
                                         },
                                        width = "calc(50%)",
                                        height = "calc(100%)",
                                        left = "0%",
                                        top = "0%",
                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[0].ImgUrl),
                                        backgroundImage = "",
                                        backgroundRepeat = "no-repeat",
                                        backgroundSize = "cover",
                                        backgroundPosition = "center"
                                    });
                                    rubikData.list.Add(new rubikDetailItem()
                                    {
                                        backgroundColor = "",
                                        numberX = 0,
                                        numberY = 0,
                                        w = 25,
                                        h = 16,
                                        x = 25,
                                        y = 0,
                                        link = new List<rubikLinkItem>()
                                        {
                                            new rubikLinkItem()
                                            {
                                                new_link_url = blockSource.MagicDataList[1].Link
                                            }
                                        },
                                        width = "calc(50%)",
                                        height = "calc(100%)",
                                        left = "0%",
                                        top = "0%",
                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[1].ImgUrl),
                                        backgroundImage = "",
                                        backgroundRepeat = "no-repeat",
                                        backgroundSize = "cover",
                                        backgroundPosition = "center"
                                    });
                                    break;
                                //三张平分图
                                case 5:
                                    rubikData.height = "240";
                                    rubikData.w = "75";
                                    rubikData.h = 24;
                                    rubikData.list.Add(new rubikDetailItem()
                                    {
                                        backgroundColor = "",
                                        numberX = 0,
                                        numberY = 0,
                                        w = 25,
                                        h = 24,
                                        x = 0,
                                        y = 0,
                                        link = new List<rubikLinkItem>()
                                        {
                                            new rubikLinkItem()
                                            {
                                                new_link_url = blockSource.MagicDataList[0].Link
                                            }
                                        },
                                        width = "calc(33.33%)",
                                        height = "calc(100%)",
                                        left = "0%",
                                        top = "0%",
                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[0].ImgUrl),
                                        backgroundImage = "",
                                        backgroundRepeat = "no-repeat",
                                        backgroundSize = "cover",
                                        backgroundPosition = "center"
                                    });
                                    rubikData.list.Add(new rubikDetailItem()
                                    {
                                        backgroundColor = "",
                                        numberX = 0,
                                        numberY = 0,
                                        w = 25,
                                        h = 24,
                                        x = 25,
                                        y = 0,
                                        link = new List<rubikLinkItem>()
                                        {
                                            new rubikLinkItem()
                                            {
                                                new_link_url = blockSource.MagicDataList[1].Link
                                            }
                                        },
                                        width = "calc(33.33%)",
                                        height = "calc(100%)",
                                        left = "calc(33.33%)",
                                        top = "0%",
                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[1].ImgUrl),
                                        backgroundImage = "",
                                        backgroundRepeat = "no-repeat",
                                        backgroundSize = "cover",
                                        backgroundPosition = "center"
                                    });
                                    rubikData.list.Add(new rubikDetailItem()
                                    {
                                        backgroundColor = "",
                                        numberX = 0,
                                        numberY = 0,
                                        w = 25,
                                        h = 24,
                                        x = 50,
                                        y = 6,
                                        link = new List<rubikLinkItem>()
                                        {
                                            new rubikLinkItem()
                                            {
                                                new_link_url = blockSource.MagicDataList[2].Link
                                            }
                                        },
                                        width = "calc(33.34%)",
                                        height = "calc(100%)",
                                        left = "calc(66.66%)",
                                        top = "calc(0%)",
                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[2].ImgUrl),
                                        backgroundImage = "",
                                        backgroundRepeat = "no-repeat",
                                        backgroundSize = "cover",
                                        backgroundPosition = "center"
                                    });
                                    break;

                                //四张平分
                                case 6:
                                    rubikData.height = "186";
                                    rubikData.w = "4";
                                    rubikData.h = 1;
                                    rubikData.list.Add(new rubikDetailItem()
                                    {
                                        backgroundColor = "",
                                        numberX = 0,
                                        numberY = 0,
                                        w = 1,
                                        h = 1,
                                        x = 0,
                                        y = 0,
                                        link = new List<rubikLinkItem>()
                                        {
                                            new rubikLinkItem()
                                            {
                                                new_link_url = blockSource.MagicDataList[0].Link
                                            }
                                        },
                                        width = "calc(25%)",
                                        height = "calc(100%)",
                                        left = "0%",
                                        top = "0%",
                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[0].ImgUrl),
                                        backgroundImage = "",
                                        backgroundRepeat = "no-repeat",
                                        backgroundSize = "cover",
                                        backgroundPosition = "center"
                                    });
                                    rubikData.list.Add(new rubikDetailItem()
                                    {
                                        backgroundColor = "",
                                        numberX = 0,
                                        numberY = 0,
                                        w = 1,
                                        h = 1,
                                        x = 1,
                                        y = 0,
                                        link = new List<rubikLinkItem>()
                                        {
                                            new rubikLinkItem()
                                            {
                                                new_link_url = blockSource.MagicDataList[1].Link
                                            }
                                        },
                                        width = "calc(25%)",
                                        height = "calc(100%)",
                                        left = "calc(25%)",
                                        top = "0%",
                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[1].ImgUrl),
                                        backgroundImage = "",
                                        backgroundRepeat = "no-repeat",
                                        backgroundSize = "cover",
                                        backgroundPosition = "center"
                                    });
                                    rubikData.list.Add(new rubikDetailItem()
                                    {
                                        backgroundColor = "",
                                        numberX = 0,
                                        numberY = 0,
                                        w = 1,
                                        h = 1,
                                        x = 2,
                                        y = 0,
                                        link = new List<rubikLinkItem>()
                                        {
                                            new rubikLinkItem()
                                            {
                                                new_link_url = blockSource.MagicDataList[2].Link
                                            }
                                        },
                                        width = "calc(25%)",
                                        height = "calc(100%)",
                                        left = "calc(50%)",
                                        top = "calc(0%)",
                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[2].ImgUrl),
                                        backgroundImage = "",
                                        backgroundRepeat = "no-repeat",
                                        backgroundSize = "cover",
                                        backgroundPosition = "center"
                                    });
                                    rubikData.list.Add(new rubikDetailItem()
                                    {
                                        backgroundColor = "",
                                        numberX = 0,
                                        numberY = 0,
                                        w = 1,
                                        h = 1,
                                        x = 3,
                                        y = 0,
                                        link = new List<rubikLinkItem>()
                                        {
                                            new rubikLinkItem()
                                            {
                                                new_link_url = blockSource.MagicDataList[3].Link
                                            }
                                        },
                                        width = "calc(25%)",
                                        height = "calc(100%)",
                                        left = "calc(75%)",
                                        top = "calc(0%)",
                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[3].ImgUrl),
                                        backgroundImage = "",
                                        backgroundRepeat = "no-repeat",
                                        backgroundSize = "cover",
                                        backgroundPosition = "center"
                                    });
                                    break;
                                //四张上下平分
                                case 7:
                                    rubikData.height = "372";
                                    rubikData.w = "250";
                                    rubikData.h = 124;
                                    rubikData.list.Add(new rubikDetailItem()
                                    {
                                        backgroundColor = "",
                                        numberX = 0,
                                        numberY = 0,
                                        w = 125,
                                        h = 62,
                                        x = 0,
                                        y = 0,
                                        link = new List<rubikLinkItem>()
                                        {
                                            new rubikLinkItem()
                                            {
                                                new_link_url = blockSource.MagicDataList[0].Link
                                            }
                                         },
                                        width = "calc(50%)",
                                        height = "calc(50%)",
                                        left = "0%",
                                        top = "0%",
                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[0].ImgUrl),
                                        backgroundImage = "",
                                        backgroundRepeat = "no-repeat",
                                        backgroundSize = "cover",
                                        backgroundPosition = "center"
                                    });
                                    rubikData.list.Add(new rubikDetailItem()
                                    {
                                        backgroundColor = "",
                                        numberX = 0,
                                        numberY = 0,
                                        w = 125,
                                        h = 62,
                                        x = 125,
                                        y = 0,
                                        link = new List<rubikLinkItem>()
                                        {
                                            new rubikLinkItem()
                                            {
                                                new_link_url = blockSource.MagicDataList[1].Link
                                            }
                                        },
                                        width = "calc(50%)",
                                        height = "calc(50%)",
                                        left = "calc(50%)",
                                        top = "0%",
                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[1].ImgUrl),
                                        backgroundImage = "",
                                        backgroundRepeat = "no-repeat",
                                        backgroundSize = "cover",
                                        backgroundPosition = "center"
                                    });
                                    rubikData.list.Add(new rubikDetailItem()
                                    {
                                        backgroundColor = "",
                                        numberX = 0,
                                        numberY = 0,
                                        w = 125,
                                        h = 62,
                                        x = 0,
                                        y = 62,
                                        link = new List<rubikLinkItem>()
                                        {
                                            new rubikLinkItem()
                                            {
                                                new_link_url = blockSource.MagicDataList[2].Link
                                            }
                                        },
                                        width = "calc(50%)",
                                        height = "calc(50%)",
                                        left = "calc(0%)",
                                        top = "calc(50%)",
                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[2].ImgUrl),
                                        backgroundImage = "",
                                        backgroundRepeat = "no-repeat",
                                        backgroundSize = "cover",
                                        backgroundPosition = "center"
                                    });
                                    rubikData.list.Add(new rubikDetailItem()
                                    {
                                        backgroundColor = "",
                                        numberX = 0,
                                        numberY = 0,
                                        w = 125,
                                        h = 62,
                                        x = 125,
                                        y = 62,
                                        link = new List<rubikLinkItem>()
                                        {
                                            new rubikLinkItem()
                                            {
                                                new_link_url = blockSource.MagicDataList[3].Link
                                            }
                                        },
                                        width = "calc(50%)",
                                        height = "calc(50%)",
                                        left = "calc(50%)",
                                        top = "calc(50%)",
                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[3].ImgUrl),
                                        backgroundImage = "",
                                        backgroundRepeat = "no-repeat",
                                        backgroundSize = "cover",
                                        backgroundPosition = "center"
                                    });
                                    break;
                            }
                            templateData.data.Add(new
                            {
                                id = "rubik",
                                data = rubikData
                            });
                            templateData.data.Add(new
                            {
                                id = "empty",
                                data = new emptyItem()
                                {
                                    background = "#ffffff",
                                    height = 10
                                }
                            });
                        }
                        break;

                }
            }
            var tempObj = new
            {
                id = miniProgram.MallBaseId,
                name = "自定义首页布局",
                page_id = miniProgram.MallBaseId,
                template_id = miniProgram.MallBaseId,
                template = templateData
            };
            return tempObj;
        }


        /// <summary>
        /// 基本设置
        /// </summary>
        /// <param name="miniProgram"></param>
        /// <returns></returns>
        public static object GetBasicSetting(RB_MiniProgram_Extend miniProgram)
        {
            #region 基本设置
            //基础配置 Add By:W 2020年6月1号
            var mallBaseModel = mallBaseModule.GetListRepository(new RB_MallBase_Extend { TenantId = miniProgram.TenantId ?? 0, MallBaseId = miniProgram.MallBaseId }).FirstOrDefault();
            if (mallBaseModel == null)
            {
                mallBaseModel = new RB_MallBase_Extend();
            }
            //获取物流配置
            var logisticsRules = mallBaseModule.GetLogisticsList(new RB_Logistics { TenantId = miniProgram.TenantId ?? 0, MallBaseId = miniProgram.MallBaseId }).FirstOrDefault();
            if (logisticsRules == null)
            {
                logisticsRules = new RB_Logistics();
            }
            //用户积分
            var integralModel = integralModule.GetIntegralSettingsList(new RB_Integral_Settings { TenantId = miniProgram.TenantId ?? 0, MallBaseId = miniProgram.MallBaseId }).FirstOrDefault();
            if (integralModel == null)
            {
                integralModel = new RB_Integral_Settings();
            }

            //充值信息
            var rechargeModel = rechargeModule.GetRechargeSettingsList(new RB_Recharge_Settings { TenantId = miniProgram.TenantId ?? 0, MallBaseId = miniProgram.MallBaseId }).FirstOrDefault();
            if (rechargeModel == null)
            {
                rechargeModel = new RB_Recharge_Settings();
            }
            List<string> payment_type = new List<string>();
            if (!string.IsNullOrWhiteSpace(mallBaseModel.PayWay))
            {
                foreach (var item in mallBaseModel.PayWay.Split(","))
                {
                    switch (item)
                    {
                        case "1":
                            payment_type.Add("online_pay");
                            break;
                        case "2":
                            payment_type.Add("huodao");
                            break;
                        case "3":
                            payment_type.Add("balance");
                            break;
                        default:
                            break;
                    }
                }
            }
            List<string> send_type = new List<string>();
            if (!string.IsNullOrWhiteSpace(mallBaseModel.DeliverWay))
            {
                foreach (var item in mallBaseModel.DeliverWay.Split(","))
                {
                    switch (item)
                    {
                        case "1":
                            send_type.Add("express");
                            break;
                        case "2":
                            send_type.Add("offline");
                            break;
                        case "3":
                            send_type.Add("city");
                            break;
                        default:
                            break;
                    }
                }
            }
            List<string> good_negotiable = new List<string>();
            if (!string.IsNullOrWhiteSpace(mallBaseModel.ConsultWay))
            {
                foreach (var item in mallBaseModel.ConsultWay.Split(","))
                {
                    switch (item)
                    {
                        case "1":
                            good_negotiable.Add("contact");
                            break;
                        case "2":
                            good_negotiable.Add("contact_tel");
                            break;
                        case "3":
                            good_negotiable.Add("contact_web");
                            break;
                        default:
                            break;
                    }
                }
            }
            //商城风格
            var mallStyle = new object();

            ResultMallShopStyle resultMallShopStyle = new ResultMallShopStyle();
            switch (miniProgram.MallShopStyle)
            {
                case MallShopStyleEnum.Default:
                    resultMallShopStyle = new ResultMallShopStyle() { main = "#ff4544", secondary = "#f39800", IsEducation = 0 };
                    break;
                case MallShopStyleEnum.VibrantYellow:
                    resultMallShopStyle = new ResultMallShopStyle() { main = "#ff4544", secondary = "#f39800", IsEducation = 0 };
                    break;
                case MallShopStyleEnum.RomanticPowder:
                    resultMallShopStyle = new ResultMallShopStyle() { main = "#ff547b", secondary = "#ffe6e8", IsEducation = 0 };
                    break;
                case MallShopStyleEnum.StreamerGold:
                    resultMallShopStyle = new ResultMallShopStyle() { main = "#ddb766", secondary = "#f0ebd8", IsEducation = 0 };
                    break;
                case MallShopStyleEnum.ElegantPurple:
                    resultMallShopStyle = new ResultMallShopStyle() { main = "#7783ea", secondary = "#e9ebff", IsEducation = 0 };
                    break;
                case MallShopStyleEnum.TasteRed:
                    resultMallShopStyle = new ResultMallShopStyle() { main = "#ff4544", secondary = "#555555", IsEducation = 0 };
                    break;
                case MallShopStyleEnum.FreshGreen:
                    resultMallShopStyle = new ResultMallShopStyle() { main = "#00C6C1", secondary = "#e1f4e3", IsEducation = 0 };
                    break;
                case MallShopStyleEnum.BusinessBlue:
                    resultMallShopStyle = new ResultMallShopStyle() { main = "#4a90e2", secondary = "#dbe9f9", IsEducation = 0 };
                    break;
                case MallShopStyleEnum.PureBlack:
                    resultMallShopStyle = new ResultMallShopStyle() { main = "#333333", secondary = "#dedede", IsEducation = 0 };
                    break;
                case MallShopStyleEnum.PassionateRed:
                    resultMallShopStyle = new ResultMallShopStyle() { main = "#ff4544", secondary = "#ffdada", IsEducation = 0 };
                    break;
                case MallShopStyleEnum.Education:
                    resultMallShopStyle = new ResultMallShopStyle() { main = "#00d6a6", secondary = "#ffc86d", IsEducation = 1 };
                    break;
            }
            mallStyle = new
            {
                resultMallShopStyle?.main,
                resultMallShopStyle?.secondary,
                resultMallShopStyle?.IsEducation,
            };

            var setting = new
            {
                mallStyle,
                contact_tel = mallBaseModel?.ContactNumber,
                over_time = mallBaseModel?.CancelTime,
                delivery_time = mallBaseModel?.AutoReceiving,
                after_sale_time = mallBaseModel?.AfterTime,
                payment_type = payment_type.ToArray(),//支付方式 
                send_type = send_type.ToArray(),//发货方式
                kdniao_mch_id = logisticsRules?.ExpressBirdID,//快递鸟配置
                kdniao_api_key = logisticsRules?.ExpressBirdAPIKey,
                member_integral = integralModel?.IntegralNum,
                member_integral_rule = integralModel?.Explain,
                good_negotiable = good_negotiable.ToArray(),//商品面议联系方式
                mobile_verify = "",
                is_small_app = mallBaseModel?.TurnMini,
                small_app_id = mallBaseModel?.MinAppId,
                small_app_url = mallBaseModel?.MinUrl,
                small_app_pic = mallBaseModel?.TurnMiniIco,
                is_customer_services = mallBaseModel?.OnlineService,
                customer_services_pic = mallBaseModel?.OnlineServiceIco,
                is_dial = mallBaseModel?.OneCall,
                dial_pic = mallBaseModel?.OneCallIco,
                is_web_service = mallBaseModel?.ServiceOutLink,
                web_service_url = mallBaseModel?.OuterServiceLink,
                web_service_pic = mallBaseModel?.ServiceOutLinkIco,
                is_quick_navigation = mallBaseModel?.SuspendBtn,
                quick_navigation_style = mallBaseModel?.SuspendStyle,
                quick_navigation_opened_pic = mallBaseModel?.UnfoldIco,
                quick_navigation_closed_pic = mallBaseModel?.PackUpIco,
                is_show_stock = "",
                is_use_stock = "",
                sell_out_pic = "",
                sell_out_other_pic = "",
                is_common_user_member_price = mallBaseModel?.DetailsMemberPrice,
                is_member_user_member_price = mallBaseModel?.DetailsVipMemberPrice,
                is_share_price = mallBaseModel?.DetailsSharePrice,
                is_purchase_frame = mallBaseModel?.BuySwitch,
                purchase_num = mallBaseModel?.CarouselOrder,
                is_comment = mallBaseModel?.DetailsComment,
                is_sales = mallBaseModel?.DetailsBuyNum,
                is_mobile_auth = mallBaseModel?.OtherIndexMoblie,
                is_official_account = mallBaseModel?.OtherTencent,
                is_manual_mobile_auth = mallBaseModel?.OtherManualMobile,
                is_icon_members_grade = mallBaseModel?.OtherMemerLevel,
                is_goods_video = mallBaseModel?.DetailsVideo,
                is_quick_map = mallBaseModel?.ShortcutNavigation,
                quick_map_pic = mallBaseModel?.ShortcutNavigationIco,
                quick_map_address = mallBaseModel?.Address,
                longitude = !string.IsNullOrWhiteSpace(mallBaseModel.LongAndLat) ? mallBaseModel?.LongAndLat.Split(",")[0] : "",
                latitude = !string.IsNullOrWhiteSpace(mallBaseModel.LongAndLat) ? mallBaseModel?.LongAndLat.Split(",")[1] : "",
                is_quick_home = mallBaseModel?.BackTopNavigation,
                quick_home_pic = mallBaseModel?.BackTopNavigationIco,
                logo = "",
                share_title = mallBaseModel?.MinShareTitle,
                share_pic = mallBaseModel?.MinShareIco,
                is_add_app = mallBaseModel?.MinSwitch,
                add_app_bg_color = mallBaseModel?.MinBackColor,
                add_app_bg_transparency = mallBaseModel?.MinBackClarity,
                add_app_bg_radius = mallBaseModel?.MinBackCircularBead,
                add_app_text = mallBaseModel?.MinTips,
                add_app_text_color = mallBaseModel?.MinTipsColor,
                add_app_icon_color_type = mallBaseModel?.MinIcoColor,
                is_close = "",
                business_time_type = "",
                business_time_custom_type = "",
                business_time_type_day = "",
                business_time_type_week = "",
                auto_business = "",
                auto_business_time = "",
                is_icon_super_vip = "",
                is_show_normal_vip = "",
                is_show_super_vip = "",
                is_required_position = mallBaseModel?.OtherMustAddress,
                is_share_tip = mallBaseModel?.OtherApplyShare,
                is_show_cart = mallBaseModel?.ListShopCar,
                is_show_sales_num = mallBaseModel?.ListBuyCount,
                is_show_goods_name = mallBaseModel?.ListName,
                is_show_korea = miniProgram?.IsKorea ?? 0,//是否是韩国馆(1-是)
                is_show_miai = miniProgram?.IsOpenMiAi ?? 0,//是否开启相亲项目(1-是)
                is_underline_price = mallBaseModel?.DetailsLineationPrice,
                is_express = mallBaseModel?.DeatilsExpress,
                is_not_share_show = mallBaseModel?.OtherNoShare,
                is_show_cart_fly = mallBaseModel?.CarSuspendBtn,
                is_show_score_top = mallBaseModel?.BackTopBtn,
                express_select_type = logisticsRules?.LogisticsType,//待会儿处理
                express_aliapy_code = logisticsRules?.AliyunAppCode,
                is_quick_customize = mallBaseModel?.Custom,
                quick_customize_pic = mallBaseModel?.TurnIco,
                quick_customize_open_type = "",
                quick_customize_params = "",
                quick_customize_link_url = mallBaseModel?.TurnLink,
                quick_customize_new_params = "",
                theme_color = "",
                latitude_longitude = mallBaseModel?.LongAndLat,
                IsShowRecharge = rechargeModel.IsOpenBtn,
                IsOpenReserve = (miniProgram?.IsOpenReserve ?? 0),
            };
            #endregion
            return setting;
        }

        /// <summary>
        /// 分销基础信息
        /// </summary>
        /// <returns></returns>
        public static object GetDistributorBasicsInfo(RB_MiniProgram_Extend miniProgram)
        {
            #region 分销基础信息
            var distributorBasics = userModule.GetDistributorBasicsInfo((miniProgram.TenantId ?? 0).ToString(), miniProgram.MallBaseId);
            if (!string.IsNullOrEmpty(distributorBasics.WithdrawWay))
            {
                distributorBasics.WithdrawWayList = JsonConvert.DeserializeObject<List<int>>(distributorBasics.WithdrawWay);
            }
            List<string> pay_type = new List<string>();
            if (!string.IsNullOrWhiteSpace(distributorBasics.WithdrawWay))
            {
                foreach (var item in distributorBasics.WithdrawWayList)
                {
                    switch (item)
                    {
                        case 1:
                            pay_type.Add("auto");
                            break;
                        case 2:
                            pay_type.Add("wechat");
                            break;
                        case 3:
                            pay_type.Add("alipay");
                            break;
                        case 4:
                            pay_type.Add("bank");
                            break;
                        case 5:
                            pay_type.Add("balance");
                            break;
                        default:
                            break;
                    }
                }
            }

            var share_setting = new
            {
                level = distributorBasics?.DistributorTier,
                is_rebate = distributorBasics?.InPurchasing,
                price_type = distributorBasics?.DistributorCommissionType,
                first = distributorBasics?.OneCommission,
                second = distributorBasics?.TwoCommission,
                third = distributorBasics?.ThreeCommission,
                share_condition = "",
                condition = distributorBasics?.ReferralsCondition ?? 0,
                auto_share_val = "",
                share_goods_status = "",
                share_goods_warehouse_id = "",
                pay_type = pay_type.ToArray(),
                cash_max_day = distributorBasics?.DailyWithdrawalLimit,
                min_money = distributorBasics?.MinimumWithdrawalLimit,
                cash_service_charge = distributorBasics?.WithdrawFee,
                agree = distributorBasics?.ApplicationProtocol,
                content = distributorBasics?.UserNotes,
                pic_url_apply = "",
                pic_url_status = distributorBasics?.BackgroundImage,
                pic_url_home_head = distributorBasics?.IndexImage,
                become_condition = "",
                cat_list = "",
                is_show_share_level = "",
            };
            #endregion
            return share_setting;
        }

        /// <summary>
        /// 分销设置
        /// </summary>
        /// <param name="miniProgram"></param>
        /// <returns></returns>
        public static object GetDistributorCustomInfo(RB_MiniProgram_Extend miniProgram)
        {
            #region share_setting_custom
            var distributorCustom = userModule.GetDistributorCustomInfo((miniProgram.TenantId ?? 0).ToString(), miniProgram.MallBaseId);
            var share_setting_custom = new
            {
                menus = new
                {
                    money = new
                    {
                        name = distributorCustom?.DistributionCommissionName,
                        icon = distributorCustom?.DistributionCommissionImage,
                        open_type = "",
                        url = "",
                        tel = ""
                    },
                    order = new
                    {
                        name = distributorCustom?.DistributionOrderName,
                        icon = distributorCustom?.DistributionOrderImage,
                        open_type = "",
                        url = "",
                        tel = ""
                    },
                    cash = new
                    {
                        name = distributorCustom?.WithdrawDetialsName,
                        icon = distributorCustom?.WithdrawDetialsImage,
                        open_type = "",
                        url = "",
                        tel = ""
                    },
                    team = new
                    {
                        name = distributorCustom?.MyTeamName,
                        icon = distributorCustom?.MyTeamImage,
                        open_type = "",
                        url = "",
                        tel = ""
                    },
                    qrcode = new
                    {
                        name = distributorCustom?.PromoteQRCodeName,
                        icon = distributorCustom?.PromoteQRCodeImage,
                        open_type = "",
                        url = "",
                        tel = ""
                    },
                },
                words = new
                {
                    can_be_presented = new { name = distributorCustom?.CommissionForWithdrawalName, defaultStr = "可提现佣金" },
                    already_presented = new { name = distributorCustom?.CommissionWithdrawnName, defaultStr = "已提现佣金" },
                    parent_name = new { name = distributorCustom?.ReferrerName, defaultStr = "推荐人" },
                    pending_money = new { name = distributorCustom?.CommissionTobePaidName, defaultStr = "待打款佣金" },
                    cash = new { name = distributorCustom?.WithdrawDepositName, defaultStr = "提现" },
                    user_instructions = new { name = distributorCustom?.UserNotesName, defaultStr = "用户须知" },
                    apply_cash = new { name = distributorCustom?.IWantToWithdrawName, defaultStr = "我要提现" },
                    cash_type = new { name = distributorCustom?.WithdrawalWayName, defaultStr = "提现方式" },
                    cash_money = new { name = distributorCustom?.WithdrawalAmountName, defaultStr = "提现金额" },
                    order_money_un = new { name = distributorCustom?.OutstandingCommissionName, defaultStr = "未结算佣金" },
                    share_name = new { name = distributorCustom?.DistributorName, defaultStr = "分销商" },
                    one_share = new { name = distributorCustom?.OneDistributionName, defaultStr = "一级分销名称" },
                    second_share = new { name = distributorCustom?.TwoDistributionName, defaultStr = "二级分销名称" },
                    three_share = new { name = distributorCustom?.ThreeDistributionName, defaultStr = "三级分销名称" },
                    isshowvipbuypic = distributorCustom?.IsShowVIPBuyPic,
                    vipbuyico = distributorCustom?.VipBuyICO,
                    vipbuyurl = distributorCustom?.VipBuyUrl,
                },
                apply = new
                {
                    share_apply = new { name = distributorCustom?.DistributionApplication, defaultStr = "分销申请" },
                    share_apply_pact = new { name = distributorCustom?.ApplicationAgreement, defaultStr = "分销申请协议" },
                    apply_btn_color = distributorCustom?.ButtonTextColor,
                    apply_btn_background = distributorCustom?.ButtonColor,
                    apply_btn_title = distributorCustom?.ButtonText,
                    apply_btn_round = distributorCustom?.ButtonFilletPX,
                    apply_head_pic = distributorCustom?.HeadImage,
                    apply_end_pic = distributorCustom?.BottomImage
                },

            };
            #endregion
            return share_setting_custom;
        }

        /// <summary>
        /// 获取线下服务小程序配置
        /// </summary>
        /// <param name="miniProgram"></param>
        /// <returns></returns>
        public static object GetOfflineServiceConfig(RB_MiniProgram_Extend miniProgram)
        {
            var model = reserveModule.GetReserveBaseInfo(Convert.ToInt32(miniProgram.TenantId), miniProgram.MallBaseId);
            var obj = new
            {
                offlineServicePayType = model?.PayTypeList,
                offlineServiceOrderStateList = model?.OrderStateList
            };
            return obj;
        }
    }

    /// <summary>
    /// 商城风格
    /// </summary>
    public class ResultMallShopStyle
    {
        /// <summary>
        /// 主色
        /// </summary>
        public string main { get; set; }

        /// <summary>
        /// 辅色
        /// </summary>
        public string secondary { get; set; }
        /// <summary>
        /// 0-商品，1-是
        /// </summary>
        public int IsEducation { get; set; }


    }
}
